/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.studio;

import com.spacekiller.util.ListenerList;
import com.waxmonster.studio.Device;
import com.waxmonster.studio.DeviceInfo;
import com.waxmonster.studio.DeviceInfoListener;
import com.waxmonster.studio.PortType;
import com.waxmonster.studio.StudioException;
import java.util.LinkedList;
import java.util.List;

public abstract class DeviceProvider {
    private final String name;
    private ListenerList<DeviceInfoListener> deviceInfoListeners;
    private List deviceInfo;

    public DeviceProvider(String name) {
        this.name = name;
        this.deviceInfoListeners = new ListenerList(DeviceInfoListener.class);
        this.deviceInfo = new LinkedList();
    }

    public final String getName() {
        return this.name;
    }

    public final synchronized void addDeviceInfoListener(DeviceInfoListener listener) {
        if (listener == null) {
            return;
        }
        this.deviceInfoListeners.add((Object)listener);
    }

    public final synchronized void removeDeviceInfoListener(DeviceInfoListener listener) {
        if (listener == null) {
            return;
        }
        this.deviceInfoListeners.remove((Object)listener);
    }

    protected synchronized boolean addDeviceInfo(DeviceInfo info) {
        if (info != null && !this.deviceInfo.contains(info) && this.deviceInfo.add(info)) {
            this.fireDeviceInfoAdded(info);
            return true;
        }
        return false;
    }

    protected synchronized boolean removeDeviceInfo(DeviceInfo info) {
        if (this.deviceInfo.remove(info)) {
            this.fireDeviceInfoRemoved(info);
            return true;
        }
        return false;
    }

    private synchronized void fireDeviceInfoAdded(DeviceInfo info) {
        for (DeviceInfoListener l : (DeviceInfoListener[])this.deviceInfoListeners.array()) {
            l.deviceInfoAdded(info);
        }
    }

    private synchronized void fireDeviceInfoRemoved(DeviceInfo info) {
        for (DeviceInfoListener l : (DeviceInfoListener[])this.deviceInfoListeners.array()) {
            l.deviceInfoRemoved(info);
        }
    }

    public synchronized DeviceInfo[] getDeviceInfo() {
        return this.deviceInfo.toArray(new DeviceInfo[this.deviceInfo.size()]);
    }

    public abstract void refreshDeviceInfo();

    public abstract Device createDevice(DeviceInfo var1) throws StudioException;

    public abstract PortType getPortType(String var1);
}

