/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.studio;

import com.waxmonster.studio.Device;
import com.waxmonster.studio.LayoutPanel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Layout
implements Cloneable {
    private String id;
    private String name;
    private String title;
    private List panels;
    private Map devicePanelMap;

    public Layout(String name) {
        this.name = name;
        this.panels = new ArrayList();
        this.devicePanelMap = new HashMap();
    }

    final String getId() {
        return this.id;
    }

    final void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public synchronized int getPanelCount() {
        return this.panels.size();
    }

    public synchronized LayoutPanel getPanelAt(int index) {
        return (LayoutPanel)this.panels.get(index);
    }

    public synchronized LayoutPanel getPanelForDevice(Device device) {
        return (LayoutPanel)this.devicePanelMap.get(device);
    }

    public synchronized void addPanel(LayoutPanel panel) {
        if (panel == null) {
            throw new NullPointerException("panel");
        }
        this.panels.add(panel);
        Device dev = panel.getDevice();
        if (dev != null) {
            this.devicePanelMap.put(dev, panel);
        }
    }

    public synchronized void insertPanelAt(LayoutPanel panel, int index) {
        if (panel == null) {
            throw new NullPointerException("panel");
        }
        this.panels.add(index, panel);
        Device dev = panel.getDevice();
        if (dev != null) {
            this.devicePanelMap.put(dev, panel);
        }
    }

    public synchronized void removePanelAt(int index) {
        LayoutPanel panel = (LayoutPanel)this.panels.remove(index);
        if (panel == null) {
            return;
        }
        Device dev = panel.getDevice();
        if (dev != null) {
            this.devicePanelMap.remove(dev);
        }
    }

    public synchronized boolean removePanel(LayoutPanel panel) {
        if (!this.panels.remove(panel)) {
            return false;
        }
        Device dev = panel.getDevice();
        if (dev != null) {
            this.devicePanelMap.remove(dev);
        }
        return true;
    }

    public Layout cloneLayout() throws CloneNotSupportedException {
        Layout clone = new Layout(this.name);
        clone.setTitle(this.title);
        int num = this.panels.size();
        for (int i = 0; i < num; ++i) {
            LayoutPanel clonePanel;
            LayoutPanel panel = (LayoutPanel)this.panels.get(i);
            if (panel == null || (clonePanel = panel.cloneLayoutPanel()) == null) continue;
            clone.addPanel(clonePanel);
        }
        return clone;
    }

    public String toString() {
        return super.toString() + "[name=" + this.name + "]";
    }
}

