/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.studio;

import com.waxmonster.studio.Connection;
import com.waxmonster.studio.Device;
import com.waxmonster.studio.PortType;
import java.util.LinkedList;
import java.util.List;

public abstract class Port {
    private String id;
    protected final PortType type;
    private String name;
    private String title;
    private String tooltip;
    private Device device;
    private List conns;

    public Port(String name, PortType type) {
        this.name = name;
        this.type = type;
        this.conns = new LinkedList();
    }

    final String getId() {
        return this.id;
    }

    final void setId(String id) {
        this.id = id;
    }

    public final PortType getType() {
        return this.type;
    }

    public final Device getDevice() {
        return this.device;
    }

    final void setDevice(Device device) {
        this.device = device;
    }

    public final String getName() {
        return this.name;
    }

    final void setName(String name) {
        this.name = name;
    }

    public abstract boolean isConnectable(Port var1);

    public final synchronized Connection[] getConnections() {
        return this.conns.toArray(new Connection[this.conns.size()]);
    }

    public final synchronized boolean isConnected() {
        return !this.conns.isEmpty();
    }

    final synchronized void addConnection(Connection conn) {
        if (this.conns.add(conn)) {
            this.connectionAdded(conn);
        }
    }

    final synchronized void removeConnection(Connection conn) {
        if (this.conns.remove(conn)) {
            this.connectionRemoved(conn);
        }
    }

    protected abstract void connectionAdded(Connection var1);

    protected abstract void connectionRemoved(Connection var1);

    public String toString() {
        return super.toString() + "[name=" + this.name + ", type=" + this.type + ", device=" + this.device + "]";
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    protected void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }
}

