/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.studio;

import com.spacekiller.util.Clock;
import com.spacekiller.util.ListenerList;
import com.spacekiller.util.ThreadManager;
import com.spacekiller.util.Timer;
import com.spacekiller.util.media.control.Control;
import com.waxmonster.studio.Connection;
import com.waxmonster.studio.Device;
import com.waxmonster.studio.DeviceRegistry;
import com.waxmonster.studio.Layout;
import com.waxmonster.studio.Port;
import com.waxmonster.studio.PortType;
import com.waxmonster.studio.Preset;
import com.waxmonster.studio.PresetRegistry;
import com.waxmonster.studio.PresetStore;
import com.waxmonster.studio.StudioException;
import com.waxmonster.studio.StudioListener;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.undo.UndoManager;

public abstract class Studio {
    private static final Logger logger = Logger.getLogger(Studio.class.getName());
    private static final String LAYOUT_ID_PREFIX = "layout";
    private static final String DEFAULT_LAYOUT_ID = "layout1";
    private static final String DEFAULT_LAYOUT_NAME = "Layout 1";
    private static final int MAX_ERRORS_PER_DEVICE = 100;
    private volatile int state = 0;
    private ListenerList<StudioListener> listeners = new ListenerList(StudioListener.class);
    private File directory;
    private List devices = new ArrayList();
    private List conns = new ArrayList();
    private List invalidConns = new ArrayList();
    private List presets = new ArrayList();
    private String comment;
    private Rectangle viewBounds;
    private List layouts = new ArrayList();
    private Layout layout = new Layout("Layout 1");

    public Studio() {
        this.layout.setId(DEFAULT_LAYOUT_ID);
        this.layouts.add(this.layout);
    }

    public abstract DeviceRegistry getDeviceRegistry();

    public abstract PresetRegistry getPresetRegistry();

    public abstract PresetStore getPresetStore();

    public abstract long getTime();

    public abstract Clock getClock();

    public abstract ThreadManager getThreadManager();

    public final int getState() {
        return this.state;
    }

    public final boolean isStarted() {
        return this.state == 1;
    }

    public final synchronized void start() throws StudioException {
        Device device;
        int i;
        if (this.state == 1) {
            return;
        }
        Device[] devices = this.getDevices();
        for (i = 0; i < devices.length; ++i) {
            device = devices[i];
            device.clearErrors();
        }
        for (i = 0; i < devices.length; ++i) {
            Connection[] conns;
            device = devices[i];
            if (!device.isEnabled() || (conns = device.getConnections()).length < 1) continue;
            try {
                this.activateDevice(device);
                continue;
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                try {
                    device.addError(e);
                    continue;
                }
                catch (Throwable x) {
                    logger.log(Level.SEVERE, x.getMessage(), x);
                }
            }
        }
        this.state = 1;
        this.fireStudioStateChanged(1);
    }

    public final synchronized void stop() throws StudioException {
        if (this.state == 0) {
            return;
        }
        Device[] devices = this.getDevices();
        for (int i = 0; i < devices.length; ++i) {
            Device device = devices[i];
            if (!device.isActive()) continue;
            try {
                this.deactivateDevice(device);
                continue;
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                try {
                    device.addError(e);
                    continue;
                }
                catch (Throwable x) {
                    logger.log(Level.SEVERE, x.getMessage(), x);
                }
            }
        }
        this.state = 0;
        this.fireStudioStateChanged(0);
    }

    public synchronized void addStudioListener(StudioListener l) {
        if (l == null) {
            return;
        }
        this.listeners.add((Object)l);
    }

    public synchronized void removeStudioListener(StudioListener l) {
        if (l == null) {
            return;
        }
        this.listeners.remove((Object)l);
    }

    public synchronized Device[] getDevices() {
        return this.devices.toArray(new Device[this.devices.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addDevice(Device device) throws StudioException {
        if (device == null) {
            return;
        }
        if (this.devices.contains(device)) {
            return;
        }
        boolean success = false;
        try {
            this.registerDevice(device);
            this.handleDeviceAdded(device);
            success = true;
        }
        finally {
            if (success) {
                this.fireDeviceAdded(device);
            } else {
                this.unregisterDevice(device);
            }
        }
    }

    public synchronized void removeDevice(Device device) throws StudioException {
        if (device == null) {
            return;
        }
        Studio studio = device.getStudio();
        if (studio != this) {
            return;
        }
        this.disconnect(device);
        this.unregisterDevice(device);
        this.handleDeviceRemoved(device);
        this.fireDeviceRemoved(device);
    }

    public synchronized void validateDevice(Device device) throws StudioException {
        if (device == null) {
            return;
        }
        Studio studio = device.getStudio();
        if (studio != this) {
            return;
        }
        device.validate();
    }

    public synchronized Connection[] getConnections() {
        return this.conns.toArray(new Connection[this.conns.size()]);
    }

    public synchronized Connection[] getConnections(Device device) {
        return device.getConnections();
    }

    public synchronized Connection[] getConnections(Port port) {
        return port.getConnections();
    }

    public synchronized boolean isConnectable(Port source, Port target) {
        PortType targetType;
        if (source == null) {
            return false;
        }
        if (target == null) {
            return false;
        }
        if (source == target) {
            return false;
        }
        Device sourceDevice = source.getDevice();
        if (sourceDevice == null) {
            return false;
        }
        Device targetDevice = target.getDevice();
        if (targetDevice == null) {
            return false;
        }
        if (sourceDevice.getStudio() != this) {
            return false;
        }
        if (targetDevice.getStudio() != this) {
            return false;
        }
        PortType sourceType = source.getType();
        if (!sourceType.isConnectable(targetType = target.getType())) {
            return false;
        }
        if (!targetType.isConnectable(sourceType)) {
            return false;
        }
        if (!source.isConnectable(target)) {
            return false;
        }
        return target.isConnectable(source);
    }

    public synchronized Connection connect(Port source, Port target) throws StudioException {
        PortType targetType;
        if (source == target) {
            throw new StudioException("Cannot connect Port to itself: " + source);
        }
        Device sourceDevice = source.getDevice();
        if (sourceDevice == null) {
            throw new StudioException("Port is not installed: " + source);
        }
        Device targetDevice = target.getDevice();
        if (targetDevice == null) {
            throw new StudioException("Port is not installed: " + target);
        }
        if (sourceDevice.getStudio() != this) {
            throw new StudioException("Device is not installed: " + sourceDevice);
        }
        if (targetDevice.getStudio() != this) {
            throw new StudioException("Device is not installed: " + targetDevice);
        }
        PortType sourceType = source.getType();
        if (!sourceType.isConnectable(targetType = target.getType())) {
            throw new StudioException("Ports types are not compatible: port=" + source + ", partner=" + target);
        }
        if (!targetType.isConnectable(sourceType)) {
            throw new StudioException("Ports types are not compatible: port=" + source + ", partner=" + target);
        }
        if (!source.isConnectable(target)) {
            throw new StudioException("Ports are not connectable: port=" + source + ", partner=" + target);
        }
        if (!target.isConnectable(source)) {
            throw new StudioException("Ports are not connectable: port=" + target + ", partner=" + source);
        }
        Connection conn = new Connection(source, target);
        this.conns.add(conn);
        source.addConnection(conn);
        target.addConnection(conn);
        sourceDevice.addConnection(conn);
        if (targetDevice != sourceDevice) {
            targetDevice.addConnection(conn);
        }
        this.fireConnectionAdded(conn);
        if (this.isStarted()) {
            int connCount;
            Connection[] conns;
            if (sourceDevice != null && !sourceDevice.isActive() && sourceDevice.isEnabled()) {
                conns = sourceDevice.getConnections();
                int n = connCount = conns == null ? 0 : conns.length;
                if (connCount > 0) {
                    this.activateDevice(sourceDevice);
                }
            }
            if (targetDevice != null && !targetDevice.isActive() && targetDevice.isEnabled()) {
                conns = targetDevice.getConnections();
                int n = connCount = conns == null ? 0 : conns.length;
                if (connCount > 0) {
                    this.activateDevice(targetDevice);
                }
            }
        }
        return conn;
    }

    public synchronized void disconnect(Connection conn) throws StudioException {
        int connCount;
        Connection[] conns;
        if (!this.conns.remove(conn)) {
            if (this.invalidConns.contains(conn)) {
                this.removeInvalidConnection(conn);
            }
            return;
        }
        Port source = conn.getSource();
        Port target = conn.getTarget();
        Device sourceDevice = null;
        Device targetDevice = null;
        if (source != null) {
            source.removeConnection(conn);
            sourceDevice = source.getDevice();
            if (sourceDevice != null) {
                sourceDevice.removeConnection(conn);
            }
        }
        if (target != null) {
            target.removeConnection(conn);
            targetDevice = target.getDevice();
            if (targetDevice != null && targetDevice != sourceDevice) {
                targetDevice.removeConnection(conn);
            }
        }
        this.fireConnectionRemoved(conn);
        if (sourceDevice != null && sourceDevice.isActive()) {
            conns = sourceDevice.getConnections();
            int n = connCount = conns == null ? 0 : conns.length;
            if (connCount < 1) {
                this.deactivateDevice(sourceDevice);
            }
        }
        if (targetDevice != null && targetDevice.isActive()) {
            conns = targetDevice.getConnections();
            int n = connCount = conns == null ? 0 : conns.length;
            if (connCount < 1) {
                this.deactivateDevice(targetDevice);
            }
        }
    }

    public synchronized void disconnect(Connection[] arr) throws StudioException {
        int n = arr.length;
        for (int i = 0; i < n; ++i) {
            this.disconnect(arr[i]);
        }
    }

    public synchronized Connection[] disconnect(Port port) throws StudioException {
        Connection[] arr = this.getConnections(port);
        this.disconnect(arr);
        return arr;
    }

    public synchronized void disconnect(Device device) throws StudioException {
        Connection[] arr = this.getConnections(device);
        if (arr != null) {
            this.disconnect(arr);
        }
        if ((arr = this.getInvalidConnections(device)) != null) {
            this.disconnect(arr);
        }
    }

    public synchronized void enableDevice(Device device) throws StudioException {
        if (device.getStudio() != this) {
            return;
        }
        device.setEnabled(true);
    }

    public synchronized void disableDevice(Device device) throws StudioException {
        if (device.getStudio() != this) {
            return;
        }
        device.setEnabled(false);
    }

    protected synchronized void activateDevice(Device device) throws StudioException {
        if (!device.isActive()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Activating device: " + device);
            }
            device.setActive(true);
        }
    }

    protected synchronized void deactivateDevice(Device device) throws StudioException {
        if (device.isActive()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Deactivating device: " + device);
            }
            device.setActive(false);
        }
    }

    private void fireStudioStateChanged(int state) {
        for (StudioListener l : (StudioListener[])this.listeners.array()) {
            l.studioStateChanged(state);
        }
    }

    private void fireLayoutChanged(Layout layout) {
        for (StudioListener l : (StudioListener[])this.listeners.array()) {
            l.layoutChanged(layout);
        }
    }

    private void fireLayoutsChanged() {
        for (StudioListener l : (StudioListener[])this.listeners.array()) {
            l.layoutsChanged();
        }
    }

    private void fireErrorReported(Device device, LogRecord error) {
        for (StudioListener l : (StudioListener[])this.listeners.array()) {
            l.errorReported(device, error);
        }
    }

    private void fireErrorResolved(Device device, LogRecord error) {
        for (StudioListener l : (StudioListener[])this.listeners.array()) {
            l.errorResolved(device, error);
        }
    }

    private void fireDeviceAdded(Device device) {
        for (StudioListener l : (StudioListener[])this.listeners.array()) {
            l.deviceAdded(device);
        }
    }

    private void fireDeviceRemoved(Device device) {
        for (StudioListener l : (StudioListener[])this.listeners.array()) {
            l.deviceRemoved(device);
        }
    }

    private void fireDeviceRenamed(Device device) {
        for (StudioListener l : (StudioListener[])this.listeners.array()) {
            l.deviceRenamed(device);
        }
    }

    private void fireDeviceTitleChanged(Device device) {
        for (StudioListener l : (StudioListener[])this.listeners.array()) {
            l.deviceTitleChanged(device);
        }
    }

    private void fireDeviceEnabled(Device device) {
        for (StudioListener l : (StudioListener[])this.listeners.array()) {
            l.deviceEnabled(device);
        }
    }

    private void fireDeviceDisabled(Device device) {
        for (StudioListener l : (StudioListener[])this.listeners.array()) {
            l.deviceDisabled(device);
        }
    }

    private void firePortAdded(Port port, Device device) {
        for (StudioListener l : (StudioListener[])this.listeners.array()) {
            l.portAdded(port, device);
        }
    }

    private void firePortRemoved(Port port, Device device) {
        for (StudioListener l : (StudioListener[])this.listeners.array()) {
            l.portRemoved(port, device);
        }
    }

    private void firePortRenamed(Port port) {
        for (StudioListener l : (StudioListener[])this.listeners.array()) {
            l.portRenamed(port);
        }
    }

    private void fireConnectionAdded(Connection conn) {
        for (StudioListener l : (StudioListener[])this.listeners.array()) {
            l.connectionAdded(conn);
        }
    }

    private void fireConnectionRemoved(Connection conn) {
        for (StudioListener l : (StudioListener[])this.listeners.array()) {
            l.connectionRemoved(conn);
        }
    }

    private void fireControlAdded(Control control, int index, Device device) {
        for (StudioListener l : (StudioListener[])this.listeners.array()) {
            l.controlAdded(control, index, device);
        }
    }

    private void fireControlRemoved(Control control, int index, Device device) {
        for (StudioListener l : (StudioListener[])this.listeners.array()) {
            l.controlRemoved(control, index, device);
        }
    }

    final void deviceEnabled(Device device) {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("deviceEnabled: " + device);
        }
        this.handleDeviceEnabled(device);
        this.fireDeviceEnabled(device);
    }

    final void deviceDisabled(Device device) {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("deviceDisabled: " + device);
        }
        this.handleDeviceDisabled(device);
        this.fireDeviceDisabled(device);
    }

    final void deviceRenamed(Device device, String name) {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("deviceRenamed: device=" + device + ", name=" + name);
        }
        this.handleDeviceRenamed(device, name);
        this.fireDeviceRenamed(device);
    }

    final void deviceTitleChanged(Device device, String title) {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("deviceTitleChanged: device=" + device + ", title=" + title);
        }
        this.handleDeviceTitleChanged(device, title);
        this.fireDeviceTitleChanged(device);
    }

    final void portAdded(Port port, Device device) {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("portAdded: port=" + port + ", device=" + device);
        }
        this.handlePortAdded(port, device);
        this.firePortAdded(port, device);
    }

    final void portRemoved(Port port, Device device) {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("portRemoved: port=" + port + ", device=" + device);
        }
        this.handlePortRemoved(port, device);
        this.firePortRemoved(port, device);
    }

    final void portRenamed(Port port, Device device) {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("portRenamed: port=" + port + ", device=" + device);
        }
        this.handlePortRenamed(port);
        this.firePortRenamed(port);
    }

    final void controlAdded(Control control, int index, Device device) {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("controlAdded: control=" + control + ", device=" + device);
        }
        this.handleControlAdded(control, index, device);
        this.fireControlAdded(control, index, device);
    }

    final void controlRemoved(Control control, int index, Device device) {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("controlRemoved: control=" + control + ", device=" + device);
        }
        this.handleControlRemoved(control, index, device);
        this.fireControlRemoved(control, index, device);
    }

    final void errorReported(Device device, LogRecord error) {
        if (error == null || device == null) {
            return;
        }
        if (device.getErrorCount() < 100) {
            device.addErrorInternal(error);
            this.fireErrorReported(device, error);
        } else if (logger.isLoggable(Level.FINER)) {
            logger.finer("Suppressing device error: " + error + ", device=" + device);
        }
    }

    final void errorResolved(Device device, LogRecord error) {
        if (error == null || device == null) {
            return;
        }
        device.removeErrorInternal(error);
        this.fireErrorResolved(device, error);
    }

    protected void reportDeviceError(Device device, LogRecord error) {
        this.errorReported(device, error);
    }

    protected abstract void handleDeviceAdded(Device var1);

    protected abstract void handleDeviceRemoved(Device var1);

    protected abstract void handleDeviceRenamed(Device var1, String var2);

    protected abstract void handleDeviceTitleChanged(Device var1, String var2);

    protected abstract void handleDeviceEnabled(Device var1);

    protected abstract void handleDeviceDisabled(Device var1);

    protected abstract void handlePortAdded(Port var1, Device var2);

    protected abstract void handlePortRemoved(Port var1, Device var2);

    protected abstract void handlePortRenamed(Port var1);

    protected abstract void handleConnectionAdded(Connection var1);

    protected abstract void handleConnectionRemoved(Connection var1);

    protected abstract void handleControlAdded(Control var1, int var2, Device var3);

    protected abstract void handleControlRemoved(Control var1, int var2, Device var3);

    protected synchronized void registerDevice(Device device) {
        this.devices.add(device);
        device.setStudio(this);
    }

    protected synchronized void unregisterDevice(Device device) {
        if (this.devices.remove(device)) {
            device.setStudio(null);
        }
    }

    public synchronized String getPortId(Port port) {
        return port.getId();
    }

    protected void setPortId(Port port, String id) {
        port.setId(id);
    }

    public synchronized String getDeviceId(Device device) {
        return device.getId();
    }

    protected void setDeviceId(Device device, String id) {
        device.setId(id);
    }

    public void setDevicePosition(Device device, int x, int y) {
        device.setPosition(new Point(x, y));
    }

    public abstract PortType createMissingPortType(String var1, String var2, Object var3) throws StudioException;

    public abstract Port createMissingPort(Device var1, PortType var2, String var3, String var4, String var5) throws StudioException;

    protected void addMissingPort(Port port, Device device) throws StudioException {
        device.addMissingPort(port);
    }

    protected void removeMissingPort(Port port, Device device) throws StudioException {
        device.removeMissingPort(port);
    }

    public synchronized Connection[] getInvalidConnections() {
        return this.invalidConns.toArray(new Connection[this.invalidConns.size()]);
    }

    public synchronized Connection[] getInvalidConnections(Device device) {
        return device.getInvalidConnections();
    }

    public synchronized boolean isInvalidConnection(Connection conn) {
        return this.invalidConns.contains(conn);
    }

    protected synchronized void addInvalidConnection(Connection conn) throws StudioException {
        if (conn == null) {
            return;
        }
        if (this.invalidConns.contains(conn)) {
            return;
        }
        Port source = conn.getSource();
        Port target = conn.getTarget();
        if (source == null || target == null) {
            return;
        }
        Device sourceDev = source.getDevice();
        Device targetDev = target.getDevice();
        if (sourceDev == null || targetDev == null) {
            return;
        }
        sourceDev.addInvalidConnection(conn);
        if (targetDev != sourceDev) {
            targetDev.addInvalidConnection(conn);
        }
        this.invalidConns.add(conn);
        this.fireConnectionAdded(conn);
    }

    public abstract Connection addInvalidConnection(Port var1, Port var2) throws StudioException;

    public synchronized void removeInvalidConnection(Connection conn) throws StudioException {
        if (conn == null) {
            return;
        }
        if (!this.invalidConns.remove(conn)) {
            return;
        }
        Port source = conn.getSource();
        Port target = conn.getTarget();
        if (source == null || target == null) {
            return;
        }
        Device sourceDev = source.getDevice();
        Device targetDev = target.getDevice();
        if (sourceDev == null || targetDev == null) {
            return;
        }
        sourceDev.removeInvalidConnection(conn);
        if (targetDev != sourceDev) {
            targetDev.removeInvalidConnection(conn);
        }
        this.fireConnectionRemoved(conn);
    }

    protected void addMissingControl(Control control, Device device) {
        if (control == null) {
            return;
        }
        device.addControl(control);
    }

    protected void removeMissingControl(Control control, Device device) {
        device.removeControl(control);
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public Rectangle getViewBounds() {
        return this.viewBounds;
    }

    public void setViewBounds(Rectangle viewBounds) {
        this.viewBounds = viewBounds;
    }

    public synchronized Connection[] resolveInvalidConnections() throws StudioException {
        return this.resolveInvalidConnections(this.getInvalidConnections());
    }

    public synchronized Connection[] resolveInvalidConnections(Device device) throws StudioException {
        return this.resolveInvalidConnections(device.getInvalidConnections());
    }

    public synchronized Connection[] resolveInvalidConnections(Connection[] conns) throws StudioException {
        LinkedList<Connection> resolvedConns = null;
        int num = conns.length;
        for (int i = 0; i < num; ++i) {
            Connection conn = this.resolveInvalidConnection(conns[i]);
            if (conn == null) continue;
            if (resolvedConns == null) {
                resolvedConns = new LinkedList<Connection>();
            }
            resolvedConns.add(conn);
        }
        if (resolvedConns == null) {
            return new Connection[0];
        }
        return resolvedConns.toArray(new Connection[resolvedConns.size()]);
    }

    public abstract Connection resolveInvalidConnection(Connection var1) throws StudioException;

    public synchronized void cleanupMissingPorts(Device device) throws StudioException {
        device.cleanupMissingPorts();
    }

    public abstract UndoManager getUndoManager();

    public abstract Timer createTimer(Runnable var1, int var2);

    public abstract Timer createTimer(Runnable var1);

    public synchronized int getPresetCount() {
        return this.presets.size();
    }

    public synchronized Preset getPresetAt(int index) {
        return (Preset)this.presets.get(index);
    }

    public synchronized int getPresetIndex(Preset preset) {
        return this.presets.indexOf(preset);
    }

    public synchronized Preset[] getPresets() {
        return this.presets.toArray(new Preset[this.presets.size()]);
    }

    public synchronized boolean addPreset(Preset preset) {
        if (preset == null) {
            return false;
        }
        this.insertPresetAt(preset, this.presets.size());
        return true;
    }

    public synchronized void insertPresetAt(Preset preset, int index) {
        if (preset == null) {
            throw new NullPointerException("preset");
        }
        this.presets.add(index, preset);
    }

    public synchronized boolean removePreset(Preset preset) {
        int index = this.presets.indexOf(preset);
        if (index < 0) {
            return false;
        }
        this.removePresetAt(index);
        return true;
    }

    public synchronized void removePresetAt(int index) {
        this.presets.remove(index);
    }

    public synchronized int getLayoutCount() {
        return this.layouts.size();
    }

    public synchronized Layout getLayoutAt(int index) {
        return (Layout)this.layouts.get(index);
    }

    public synchronized int getLayoutIndex(Layout layout) {
        return this.layouts.indexOf(layout);
    }

    public synchronized Layout[] getLayouts() {
        return this.layouts.toArray(new Layout[this.layouts.size()]);
    }

    public synchronized boolean addLayout(Layout layout) {
        this.insertLayoutAt(layout, this.layouts.size());
        return true;
    }

    public synchronized void insertLayoutAt(Layout layout, int index) {
        if (layout == null) {
            throw new NullPointerException(LAYOUT_ID_PREFIX);
        }
        String id = layout.getId();
        if (id != null && this.getLayoutForId(id) != null) {
            id = null;
        }
        if (id == null) {
            id = this.generateLayoutId();
            layout.setId(id);
        }
        this.layouts.add(index, layout);
        this.fireLayoutsChanged();
    }

    public synchronized boolean removeLayout(Layout layout) {
        int index = this.layouts.indexOf(layout);
        if (index < 0) {
            return false;
        }
        this.removeLayoutAt(index);
        return true;
    }

    public synchronized void removeLayoutAt(int index) {
        this.layouts.remove(index);
        this.fireLayoutsChanged();
    }

    protected synchronized String generateLayoutId() {
        int num = this.layouts.size() + 1;
        String id;
        while (this.getLayoutForId(id = LAYOUT_ID_PREFIX + num) != null) {
            ++num;
        }
        return id;
    }

    public synchronized Layout getLayoutForId(String id) {
        if (id == null) {
            return null;
        }
        int num = this.layouts.size();
        for (int i = 0; i < num; ++i) {
            Layout layout = (Layout)this.layouts.get(i);
            if (layout == null || !id.equals(layout.getId())) continue;
            return layout;
        }
        return null;
    }

    public synchronized Layout getLayout() {
        return this.layout;
    }

    public synchronized void setLayout(Layout layout) {
        if (layout == null) {
            throw new NullPointerException(LAYOUT_ID_PREFIX);
        }
        if (this.layout == layout) {
            return;
        }
        this.layout = layout;
        this.fireLayoutChanged(layout);
    }

    public String getLayoutId(Layout layout) {
        return layout.getId();
    }

    protected void setLayoutId(Layout layout, String id) {
        layout.setId(id);
    }

    public File getDirectory() {
        return this.directory;
    }

    protected void setDirectory(File directory) {
        this.directory = directory;
    }
}

