/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.studio.common;

import com.waxmonster.studio.common.AbstractMeter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;

public class BarUnitMeter
extends AbstractMeter {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int DEFAULT_LED_SIZE = 4;
    public static final int DEFAULT_GAP_SIZE = 1;
    public static final Color DEFAULT_LED_HI_COLOR = Color.GREEN;
    public static final Color DEFAULT_LED_LO_COLOR = new Color(0.0f, 0.3f, 0.0f);
    public static final Color DEFAULT_ERR_LO_COLOR = new Color(0.3f, 0.0f, 0.0f);
    public static final Color DEFAULT_ERR_HI_COLOR = Color.RED;
    private int orientation = 0;
    private boolean reverse;
    private int ledSize = 4;
    private int gapSize = 1;
    private int unitSize = this.ledSize + this.gapSize;
    private double threshold;
    private double limit;
    private double increaseMillis = 300.0;
    private double decreaseMillis = 700.0;
    private double ledOffMillis = 500.0;
    private double errorOffMillis = 3000.0;
    private Paint[] ledPaints;
    private Paint[] errPaints;
    private boolean valid;
    private BarLed[] leds;
    private int ledCount;
    private int normCount;
    private int errCount;
    private double val;
    private long time;

    public BarUnitMeter() {
        this.min = 0.0;
        this.threshold = 0.001;
        this.limit = 1.0;
        this.max = 1.2;
        this.val = 0.0;
        this.valid = false;
        this.time = System.currentTimeMillis();
        this.leds = new BarLed[0];
        this.ledPaints = new Paint[]{DEFAULT_LED_LO_COLOR, DEFAULT_LED_HI_COLOR};
        this.errPaints = new Paint[]{DEFAULT_ERR_LO_COLOR, DEFAULT_ERR_HI_COLOR};
    }

    public static Color[] createColorArray(Color loColor, Color hiColor, int steps) {
        Color[] arr = new Color[steps];
        arr[0] = loColor;
        float[] loRGBA = loColor.getRGBComponents(new float[4]);
        float[] hiRGBA = hiColor.getRGBComponents(new float[4]);
        int n = steps - 1;
        for (int i = 1; i < n; ++i) {
            float r = loRGBA[0] + (hiRGBA[0] - loRGBA[0]) * (float)i / (float)n;
            float g = loRGBA[1] + (hiRGBA[1] - loRGBA[1]) * (float)i / (float)n;
            float b = loRGBA[2] + (hiRGBA[2] - loRGBA[2]) * (float)i / (float)n;
            float a = loRGBA[3] + (hiRGBA[3] - loRGBA[3]) * (float)i / (float)n;
            arr[i] = new Color(r, g, b, a);
        }
        arr[n] = hiColor;
        return arr;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public boolean isReverse() {
        return this.reverse;
    }

    public void setReverse(boolean reverse) {
        this.reverse = reverse;
    }

    public int getLedSize() {
        return this.ledSize;
    }

    public void setLedSize(int ledSize) {
        this.ledSize = ledSize;
        this.valid = false;
    }

    public int getGapSize() {
        return this.gapSize;
    }

    public void setGapSize(int gapSize) {
        this.gapSize = gapSize;
        this.valid = false;
    }

    public double getIncreaseMillis() {
        return this.increaseMillis;
    }

    public void setIncreaseMillis(double increaseMillis) {
        this.increaseMillis = increaseMillis;
    }

    public double getDecreaseMillis() {
        return this.decreaseMillis;
    }

    public void setDecreaseMillis(double decreaseMillis) {
        this.decreaseMillis = decreaseMillis;
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.valid = false;
    }

    @Override
    public void setBounds(Rectangle bounds) {
        super.setBounds(bounds);
        this.valid = false;
    }

    private void validate() {
        int i;
        BarLed led;
        int i2;
        BarLed[] arr;
        this.unitSize = this.ledSize + this.gapSize;
        int units = this.orientation == 0 ? (this.w + this.gapSize) / this.unitSize : (this.h + this.gapSize) / this.unitSize;
        if (units < 1) {
            units = 1;
        }
        if (units > (arr = this.leds).length) {
            BarLed[] newArr = new BarLed[units];
            System.arraycopy(arr, 0, newArr, 0, arr.length);
            for (i2 = arr.length; i2 < units; ++i2) {
                newArr[i2] = new BarLed();
            }
            this.leds = newArr;
            arr = newArr;
        }
        switch (this.orientation) {
            case 0: {
                if (this.reverse) {
                    int p = this.x + this.w;
                    for (i2 = 0; i2 < units; ++i2) {
                        led = arr[i2];
                        led.x = p -= this.unitSize;
                        led.y = this.y;
                        led.w = this.ledSize;
                        led.h = this.h;
                    }
                    break;
                }
                int p = this.x;
                for (i2 = 0; i2 < units; ++i2) {
                    led = arr[i2];
                    led.x = p;
                    led.y = this.y;
                    led.w = this.ledSize;
                    led.h = this.h;
                    p += this.unitSize;
                }
                led = arr[units - 1];
                led.w = this.x + this.w - led.x;
                break;
            }
            case 1: {
                if (this.reverse) {
                    int p = this.y + this.h;
                    for (i2 = 0; i2 < units; ++i2) {
                        led = arr[i2];
                        led.x = this.x;
                        led.y = p -= this.unitSize;
                        led.w = this.w;
                        led.h = this.ledSize;
                    }
                } else {
                    int p = this.x;
                    for (i2 = 0; i2 < units; ++i2) {
                        led = arr[i2];
                        led.x = this.x;
                        led.y = p;
                        led.w = this.w;
                        led.h = this.ledSize;
                        p += this.unitSize;
                    }
                }
                break;
            }
        }
        this.ledCount = units;
        this.errCount = (int)((double)units * (this.max - this.limit) / (this.max - this.min));
        if (this.errCount < 1) {
            this.errCount = 1;
        }
        this.normCount = units - this.errCount;
        for (i = 0; i < this.normCount; ++i) {
            led = arr[i];
            led.v = 0.0;
            double t = this.min + (this.limit - this.min) * (double)i / (double)this.normCount;
            if (t < this.threshold) {
                t = this.threshold;
            }
            led.t = t;
        }
        while (i < this.ledCount) {
            double t;
            led = arr[i];
            led.v = 0.0;
            led.t = t = this.limit + (this.max - this.limit) * (double)(i - this.normCount) / (double)this.errCount;
            ++i;
        }
        this.valid = true;
    }

    @Override
    public void paint(Graphics2D g) {
        Paint pnt;
        double v;
        BarLed led;
        int i;
        double peak = Math.abs(this.value);
        long currTime = System.currentTimeMillis();
        long deltaTime = currTime - this.time;
        if (peak > this.val) {
            this.val += (double)deltaTime / this.increaseMillis;
            if (this.val > peak) {
                this.val = peak;
            }
        } else if (peak < this.val) {
            this.val -= (double)deltaTime / this.decreaseMillis;
            if (this.val < peak) {
                this.val = peak;
            }
        }
        this.time = currTime;
        if (!this.valid) {
            this.validate();
        }
        BarLed[] arr = this.leds;
        Paint[] ledPnts = this.ledPaints;
        Paint[] errPnts = this.errPaints;
        Paint ledLoPaint = ledPnts[0];
        Paint ledHiPaint = ledPnts[ledPnts.length - 1];
        Paint errLoPaint = errPnts[0];
        Paint errHiPaint = errPnts[errPnts.length - 1];
        for (i = 0; i < this.normCount; ++i) {
            led = arr[i];
            if (this.val > led.t) {
                led.v = 1.0;
                g.setPaint(ledHiPaint);
                led.paint(g);
                continue;
            }
            v = led.v;
            if (v > 0.0) {
                if ((v -= (double)deltaTime / this.ledOffMillis) < 0.0) {
                    v = 0.0;
                    pnt = ledLoPaint;
                } else {
                    pnt = ledPnts[(int)(v * (double)ledPnts.length)];
                }
                led.v = v;
                g.setPaint(pnt);
                led.paint(g);
                continue;
            }
            g.setPaint(ledLoPaint);
            led.paint(g);
        }
        while (i < this.ledCount) {
            led = arr[i];
            if (this.val > led.t) {
                led.v = 1.0;
                g.setPaint(errHiPaint);
                led.paint(g);
            } else {
                v = led.v;
                if (v > 0.0) {
                    if ((v -= (double)deltaTime / this.errorOffMillis) < 0.0) {
                        v = 0.0;
                        pnt = errLoPaint;
                    } else {
                        pnt = errPnts[(int)(v * (double)errPnts.length)];
                    }
                    led.v = v;
                    g.setPaint(pnt);
                    led.paint(g);
                } else {
                    g.setPaint(errLoPaint);
                    led.paint(g);
                }
            }
            ++i;
        }
    }

    public double getLedOffMillis() {
        return this.ledOffMillis;
    }

    public void setLedOffMillis(double ledOffMillis) {
        this.ledOffMillis = ledOffMillis;
    }

    public double getErrorOffMillis() {
        return this.errorOffMillis;
    }

    public void setErrorOffMillis(double errorOffMillis) {
        this.errorOffMillis = errorOffMillis;
    }

    public Paint[] getLedPaints() {
        return this.ledPaints;
    }

    public void setLedPaints(Paint[] ledPaints) {
        this.ledPaints = ledPaints;
    }

    public Paint[] getErrPaints() {
        return this.errPaints;
    }

    public void setErrPaints(Paint[] errPaints) {
        this.errPaints = errPaints;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public void setThreshold(double threshold) {
        this.threshold = threshold;
    }

    public double getLimit() {
        return this.limit;
    }

    public void setLimit(double limit) {
        this.limit = limit;
    }

    protected static class BarLed {
        protected int x;
        protected int y;
        protected int w;
        protected int h;
        protected double t;
        protected double v;

        protected BarLed() {
        }

        public void paint(Graphics2D g) {
            g.fillRect(this.x, this.y, this.w, this.h);
        }
    }
}

