/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.studio.common;

public class CharSeq
implements CharSequence {
    private static final String MIN_LONG_STR = Long.toString(Long.MIN_VALUE);
    private static final char[] MIN_LONG = MIN_LONG_STR.toCharArray();
    public static final int MIN_LONG_LEN = MIN_LONG.length;
    private static final char[] DigitTens = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
    private static final char[] DigitOnes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private char[] arr;
    private int ofs;
    private int len;

    public CharSeq(char[] arr, int ofs, int len) {
        this.arr = arr;
        this.ofs = ofs;
        this.len = len;
    }

    @Override
    public int length() {
        return this.len;
    }

    @Override
    public char charAt(int index) {
        return this.arr[this.ofs + index];
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return new CharSeq(this.arr, this.ofs + start, end - start);
    }

    public void setArray(char[] arr) {
        this.arr = arr;
    }

    public void setOffset(int ofs) {
        this.ofs = ofs;
    }

    public void setLength(int len) {
        this.len = len;
    }

    public void setLong(long i) throws ArrayIndexOutOfBoundsException {
        int q2;
        int r;
        if (i == Long.MIN_VALUE) {
            this.ofs = 0;
            this.len = MIN_LONG.length;
            System.arraycopy(MIN_LONG, 0, this.arr, 0, this.len);
            return;
        }
        this.ofs = this.arr.length;
        int sign = 0;
        if (i < 0L) {
            sign = 45;
            i = -i;
        }
        while (i > Integer.MAX_VALUE) {
            long q = i / 100L;
            r = (int)(i - ((q << 6) + (q << 5) + (q << 2)));
            i = q;
            this.arr[--this.ofs] = DigitOnes[r];
            this.arr[--this.ofs] = DigitTens[r];
        }
        int i2 = (int)i;
        while (i2 >= 65536) {
            q2 = i2 / 100;
            r = i2 - ((q2 << 6) + (q2 << 5) + (q2 << 2));
            i2 = q2;
            this.arr[--this.ofs] = DigitOnes[r];
            this.arr[--this.ofs] = DigitTens[r];
        }
        do {
            q2 = i2 * 52429 >>> 19;
            r = i2 - ((q2 << 3) + (q2 << 1));
            this.arr[--this.ofs] = digits[r];
        } while ((i2 = q2) != 0);
        if (sign != 0) {
            this.arr[--this.ofs] = sign;
        }
        this.len = this.arr.length - this.ofs;
    }

    public void setMillis(long i) {
        int sign = 0;
        if (i < 0L) {
            sign = 45;
            i = -i;
        }
        if (i < 1000L) {
            this.setLong(1000L + i);
            this.arr[this.ofs] = 46;
            this.arr[--this.ofs] = 48;
        } else if (i < 60000L) {
            this.setLong(i);
            System.arraycopy(this.arr, this.ofs, this.arr, this.ofs - 1, this.len - 3);
            this.arr[this.arr.length - 4] = 46;
            --this.ofs;
        } else {
            long secs = i / 1000L;
            long v = secs / 60L * 100000L + secs % 60L * 1000L + i % 1000L;
            this.setLong(v);
            System.arraycopy(this.arr, this.ofs, this.arr, this.ofs - 2, this.len - 5);
            System.arraycopy(this.arr, this.arr.length - 5, this.arr, this.arr.length - 6, 2);
            this.arr[this.arr.length - 4] = 46;
            this.arr[this.arr.length - 7] = 58;
            this.ofs -= 2;
        }
        if (sign != 0) {
            this.arr[--this.ofs] = sign;
        }
        this.len = this.arr.length - this.ofs;
    }
}

