/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.studio.common;

import com.spacekiller.util.Clock;
import com.spacekiller.util.Throttle;

public class CommonThrottle
implements Throttle {
    protected final Clock clk;
    protected double rate;
    protected double factor;
    protected long maxSleep;
    protected long millis;

    public CommonThrottle(Clock clock, double rate, long maxSleepMillis) {
        this.clk = clock;
        this.millis = clock.millis();
        this.maxSleep = maxSleepMillis;
        this.setRate(rate);
    }

    public double getRate() {
        return this.rate;
    }

    public void setRate(double rate) {
        if (rate <= 0.0) {
            throw new IllegalArgumentException("Invalid rate: " + rate + " <= 0");
        }
        this.rate = rate;
        this.factor = 1000.0 / rate;
    }

    public void throttle(long amount) {
        long ms;
        if (amount < 1L) {
            return;
        }
        long at = (long)Math.ceil((double)amount * this.factor);
        long et = this.millis + at;
        long sleep = et - (ms = this.clk.millis());
        if (sleep < 1L) {
            this.millis = ms;
            return;
        }
        if (sleep > this.maxSleep) {
            sleep = this.maxSleep;
        }
        this.millis = ms + sleep;
        try {
            Thread.sleep(sleep);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }
}

