/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.studio.common;

import com.spacekiller.util.media.control.ComboBoxControlUI;
import com.spacekiller.util.media.control.Control;
import com.spacekiller.util.media.control.ControlUI;
import com.spacekiller.util.media.control.FaderControlUI;
import com.spacekiller.util.media.control.TextFieldControlUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ControlListPanel
extends JPanel {
    private static final long serialVersionUID = 4325522322303253709L;
    private static final Logger logger = Logger.getLogger(ControlListPanel.class.getName());
    private JPanel panelControls;
    private Control[] controls;
    private List entries = new ArrayList();
    private Map entryMap = new HashMap();
    private TextFieldControlUI dummyTextFieldControlUI = new TextFieldControlUI();
    private FaderControlUI dummyFaderControlUI = new FaderControlUI();
    private ComboBoxControlUI dummyComboBoxControlUI = new ComboBoxControlUI();
    private Insets labelInsets = new Insets(4, 4, 4, 4);
    private Insets compInsets = new Insets(0, 0, 0, 4);
    private Component filler = new JPanel();

    public ControlListPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JScrollPane scrollPane = new JScrollPane();
        GridBagConstraints gbc_scrollPane = new GridBagConstraints();
        gbc_scrollPane.weighty = 1.0;
        gbc_scrollPane.weightx = 1.0;
        gbc_scrollPane.fill = 1;
        gbc_scrollPane.gridx = 0;
        gbc_scrollPane.gridy = 0;
        this.add((Component)scrollPane, gbc_scrollPane);
        this.panelControls = new JPanel();
        scrollPane.setViewportView(this.panelControls);
        GridBagLayout gbl_panelControls = new GridBagLayout();
        gbl_panelControls.columnWidths = new int[]{0};
        gbl_panelControls.rowHeights = new int[]{0};
        gbl_panelControls.columnWeights = new double[]{Double.MIN_VALUE};
        gbl_panelControls.rowWeights = new double[]{Double.MIN_VALUE};
        this.panelControls.setLayout(gbl_panelControls);
    }

    protected JPanel getPanelControls() {
        return this.panelControls;
    }

    public Control[] getControls() {
        return this.controls;
    }

    public synchronized void setControls(Control[] controls) {
        ControlEntry entry2;
        Control control;
        this.controls = controls;
        int newCount = controls == null ? 0 : controls.length;
        this.entries.clear();
        for (int i = 0; i < newCount; ++i) {
            control = controls[i];
            if (control == null) continue;
            entry2 = (ControlEntry)this.entryMap.remove(control);
            if (entry2 == null) {
                entry2 = this.createEntry(control);
            }
            this.entries.add(entry2);
        }
        if (!this.entryMap.isEmpty()) {
            for (ControlEntry entry2 : this.entryMap.values()) {
                ControlUI[] uis = entry2.getControlUIs();
                int num = uis == null ? 0 : uis.length;
                for (int k = 0; k < num; ++k) {
                    ControlUI ui = uis[k];
                    if (ui == null) continue;
                    try {
                        ui.setControl(null);
                        continue;
                    }
                    catch (Throwable e) {
                        logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            }
            this.entryMap.clear();
        }
        this.panelControls.removeAll();
        int entryCount = this.entries.size();
        for (int i = 0; i < entryCount; ++i) {
            Component[] comps;
            entry2 = (ControlEntry)this.entries.get(i);
            control = entry2.getControl();
            this.entryMap.put(control, entry2);
            JLabel label = entry2.getLabel();
            if (label != null) {
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = i;
                gbc.anchor = 17;
                gbc.insets = this.labelInsets;
                this.panelControls.add((Component)label, gbc);
            }
            int compCount = (comps = entry2.getComponents()) == null ? 0 : comps.length;
            for (int k = 0; k < compCount; ++k) {
                Component comp = comps[k];
                if (comp == null) continue;
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridx = 1 + k;
                gbc.gridy = i;
                gbc.anchor = 17;
                gbc.insets = this.compInsets;
                gbc.weightx = 1.0;
                gbc.fill = 2;
                this.panelControls.add(comp, gbc);
            }
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = entryCount;
        gbc.weighty = 1.0;
        this.panelControls.add(this.filler, gbc);
        this.panelControls.validate();
        this.panelControls.repaint();
    }

    protected ControlEntry createEntry(Control control) {
        if (control == null) {
            return null;
        }
        ControlUI[] controlUIs = this.createControlUIs(control);
        Component[] components = null;
        if (controlUIs != null) {
            int num = controlUIs.length;
            components = new Component[num];
            for (int i = 0; i < num; ++i) {
                try {
                    controlUIs[i].setControl(control);
                    components[i] = controlUIs[i].getComponent();
                    continue;
                }
                catch (Throwable e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
        JLabel label = new JLabel(String.valueOf(control.getName()));
        label.setToolTipText(control.getTooltip());
        ControlEntry entry = new ControlEntry();
        entry.setControl(control);
        entry.setControlUIs(controlUIs);
        entry.setComponents(components);
        entry.setLabel(label);
        return entry;
    }

    protected ControlUI[] createControlUIs(Control control) {
        TextFieldControlUI controlUI;
        if (control == null) {
            return null;
        }
        LinkedList<TextFieldControlUI> uiList = null;
        if (this.dummyTextFieldControlUI.isControlSupported(control)) {
            if (uiList == null) {
                uiList = new LinkedList<TextFieldControlUI>();
            }
            controlUI = new TextFieldControlUI();
            uiList.add(controlUI);
        }
        if (this.dummyComboBoxControlUI.isControlSupported(control)) {
            if (uiList == null) {
                uiList = new LinkedList();
            }
            controlUI = new ComboBoxControlUI();
            uiList.add(controlUI);
        }
        if (this.dummyFaderControlUI.isControlSupported(control)) {
            if (uiList == null) {
                uiList = new LinkedList();
            }
            controlUI = new FaderControlUI();
            controlUI.setOrientation(0);
            uiList.add(controlUI);
        }
        if (uiList == null) {
            return null;
        }
        return uiList.toArray(new ControlUI[uiList.size()]);
    }

    protected class ControlEntry {
        private Control control;
        private JLabel label;
        private ControlUI[] controlUIs;
        private Component[] components;

        public Control getControl() {
            return this.control;
        }

        public void setControl(Control control) {
            this.control = control;
        }

        public JLabel getLabel() {
            return this.label;
        }

        public void setLabel(JLabel label) {
            this.label = label;
        }

        public ControlUI[] getControlUIs() {
            return this.controlUIs;
        }

        public void setControlUIs(ControlUI[] controlUIs) {
            this.controlUIs = controlUIs;
        }

        public Component[] getComponents() {
            return this.components;
        }

        public void setComponents(Component[] components) {
            this.components = components;
        }
    }
}

