/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.studio.common;

import com.spacekiller.util.Tools;
import com.waxmonster.studio.Device;
import javax.swing.Icon;
import javax.swing.JLabel;

public class DeviceStatusLabel
extends JLabel {
    private static final long serialVersionUID = -5009886877438380511L;
    private static boolean defaultIconsInit;
    private static Icon defaultIconActive;
    private static Icon defaultIconIdle;
    private static Icon defaultIconDisabled;
    private Icon deviceIconActive;
    private Icon deviceIconIdle;
    private Icon deviceIconDisabled;

    public DeviceStatusLabel() {
        if (!defaultIconsInit) {
            defaultIconActive = Tools.getIcon(this.getClass(), (String)"/com/waxmonster/studio/common/icons/waxmonster_device_active_icon16.png");
            defaultIconIdle = Tools.getIcon(this.getClass(), (String)"/com/waxmonster/studio/common/icons/waxmonster_device_idle_icon16.png");
            defaultIconDisabled = Tools.getIcon(this.getClass(), (String)"/com/waxmonster/studio/common/icons/waxmonster_device_disabled_icon16.png");
            defaultIconsInit = true;
        }
        this.deviceIconActive = defaultIconActive;
        this.deviceIconIdle = defaultIconIdle;
        this.deviceIconDisabled = defaultIconDisabled;
    }

    public DeviceStatusLabel(String text) {
        this();
        this.setText(text);
    }

    public void updateStatus(Device device) {
        String text = null;
        Icon icon = null;
        if (device != null) {
            if (device.isActive()) {
                text = "Active";
                icon = this.deviceIconActive;
            } else if (device.isEnabled()) {
                text = "Idle";
                icon = this.deviceIconIdle;
            } else {
                text = "Disabled";
                icon = this.deviceIconDisabled;
            }
        }
        if (text == null) {
            text = "";
        }
        this.setText(text);
        this.setIcon(icon);
    }

    public Icon getDeviceIconActive() {
        return this.deviceIconActive;
    }

    public void setDeviceIconActive(Icon deviceIconActive) {
        this.deviceIconActive = deviceIconActive;
    }

    public Icon getDeviceIconIdle() {
        return this.deviceIconIdle;
    }

    public void setDeviceIconIdle(Icon deviceIconIdle) {
        this.deviceIconIdle = deviceIconIdle;
    }

    public Icon getDeviceIconDisabled() {
        return this.deviceIconDisabled;
    }

    public void setDeviceIconDisabled(Icon deviceIconDisabled) {
        this.deviceIconDisabled = deviceIconDisabled;
    }
}

