/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.studio.common;

import com.waxmonster.studio.Preset;
import com.waxmonster.studio.PresetProvider;
import com.waxmonster.studio.PresetStore;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

public class FilePresetStore
extends PresetProvider
implements PresetStore {
    private static final int HEADER_MAGIC = -333875493;
    private static final int VERSION_0 = 0;
    private static final int VERSION = 0;
    private static final int TAG_HEADER = -861208594;
    private static final int TAG_PRESET = -286331391;
    private static final int TAG_PROPERTY = -1424870153;
    private static final int TAG_CONTROL = -867871533;
    private static final int TAG_PRESET_END = -313246359;
    private static final int TAG_FOOTER = -285234484;
    private final File file;
    private List presets;
    private boolean dirty = false;

    public FilePresetStore(String name, File file) throws IOException {
        super(name);
        this.file = file;
        this.presets = new LinkedList();
        if (file.exists()) {
            this.loadPresets();
        } else {
            this.savePresets();
        }
    }

    public synchronized int getPresetCount() {
        return this.presets.size();
    }

    public synchronized Preset[] getPresets() {
        return this.presets.toArray(new Preset[this.presets.size()]);
    }

    public synchronized void getPresets(Collection dst) {
        dst.addAll(this.presets);
    }

    public synchronized void addPreset(Preset preset) {
        if (preset == null) {
            return;
        }
        if (this.presets.add(preset)) {
            this.dirty = true;
        }
    }

    public synchronized void removePreset(Preset preset) {
        if (this.presets.remove(preset)) {
            this.dirty = true;
        }
    }

    public synchronized void flush() throws IOException {
        if (this.dirty) {
            this.savePresets();
            this.dirty = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void savePresets() throws IOException {
        FileOutputStream fos = new FileOutputStream(this.file);
        try {
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            try {
                DataOutputStream dos = new DataOutputStream(bos);
                try {
                    dos.writeInt(-333875493);
                    dos.writeInt(0);
                    dos.writeInt(-861208594);
                    for (Preset preset : this.presets) {
                        if (preset == null) continue;
                        dos.writeInt(-286331391);
                        this.writePreset(preset, dos);
                    }
                    dos.writeInt(-285234484);
                    dos.flush();
                }
                finally {
                    dos.close();
                }
            }
            finally {
                bos.close();
            }
        }
        finally {
            fos.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected synchronized void loadPresets() throws IOException {
        FileInputStream fis = new FileInputStream(this.file);
        try {
            BufferedInputStream bis = new BufferedInputStream(fis);
            try {
                DataInputStream dis = new DataInputStream(bis);
                try {
                    int magic = dis.readInt();
                    if (magic != -333875493) {
                        throw new StreamCorruptedException("Invalid preset file header magic: " + magic + " != " + -333875493);
                    }
                    int ver = dis.readInt();
                    if (ver < 0 || ver > 0) {
                        throw new StreamCorruptedException("Unsupported preset file version: " + ver + " (current=" + 0 + ")");
                    }
                    block14: while (true) {
                        int tag = dis.readInt();
                        switch (tag) {
                            case -861208594: {
                                continue block14;
                            }
                            case -286331391: {
                                Preset preset = this.readPreset(dis);
                                if (preset == null) continue block14;
                                this.presets.add(preset);
                                continue block14;
                            }
                            case -285234484: {
                                return;
                            }
                            default: {
                                throw new StreamCorruptedException("Invalid preset tag: " + tag);
                            }
                        }
                        break;
                    }
                }
                finally {
                    dis.close();
                }
            }
            finally {
                bis.close();
            }
        }
        finally {
            fis.close();
        }
    }

    protected void writePreset(Preset preset, DataOutput out) throws IOException {
        Map controls;
        String presetName = preset.getPresetName();
        if (presetName == null) {
            presetName = "";
        }
        out.writeUTF(presetName);
        String deviceName = preset.getDeviceName();
        if (deviceName == null) {
            deviceName = "";
        }
        out.writeUTF(deviceName);
        String providerName = preset.getProviderName();
        if (providerName == null) {
            providerName = "";
        }
        out.writeUTF(providerName);
        Properties props = preset.getProperties();
        if (props != null) {
            TreeMap<Object, Object> map = new TreeMap<Object, Object>(props);
            for (Map.Entry<Object, Object> me : map.entrySet()) {
                Object key = me.getKey();
                Object value = me.getValue();
                if (key == null || value == null) continue;
                out.writeInt(-1424870153);
                out.writeUTF(String.valueOf(key));
                out.writeUTF(String.valueOf(value));
            }
        }
        if ((controls = preset.getControls()) != null) {
            TreeMap map = new TreeMap(controls);
            for (Map.Entry me : map.entrySet()) {
                Object key = me.getKey();
                Object value = me.getValue();
                out.writeInt(-867871533);
                out.writeUTF(String.valueOf(key));
                out.writeUTF(String.valueOf(value));
            }
        }
        out.writeInt(-313246359);
    }

    protected Preset readPreset(DataInput in) throws IOException {
        String providerName;
        String deviceName;
        String presetName = in.readUTF();
        if (presetName.length() < 1) {
            presetName = null;
        }
        if ((deviceName = in.readUTF()).length() < 1) {
            deviceName = null;
        }
        if ((providerName = in.readUTF()).length() < 1) {
            providerName = null;
        }
        Properties properties = new Properties();
        HashMap<String, String> controls = new HashMap<String, String>();
        block4: while (true) {
            int tag = in.readInt();
            switch (tag) {
                case -1424870153: {
                    String key = in.readUTF();
                    String value = in.readUTF();
                    properties.put(key, value);
                    continue block4;
                }
                case -867871533: {
                    String key = in.readUTF();
                    String value = in.readUTF();
                    controls.put(key, value);
                    continue block4;
                }
            }
            break;
        }
        Preset preset = new Preset();
        preset.setPresetName(presetName);
        preset.setDeviceName(deviceName);
        preset.setProviderName(providerName);
        preset.setProperties(properties);
        preset.setControls(controls);
        return preset;
    }
}

