/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.studio.common;

import com.waxmonster.studio.common.Monitor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import javax.swing.JComponent;

public class MonitorComponent
extends JComponent {
    private static final long serialVersionUID = 1785102995315389663L;
    private Monitor monitor;
    private Paint backgroundPaint = Color.BLACK;

    @Override
    public void doLayout() {
        super.doLayout();
        Monitor mon = this.monitor;
        if (mon != null) {
            mon.setBounds(0, 0, this.getWidth(), this.getHeight());
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        Monitor mon;
        Graphics2D g2d = (Graphics2D)g;
        Rectangle r = g.getClipBounds();
        if (r == null) {
            return;
        }
        Paint paint = this.backgroundPaint;
        if (paint != null) {
            g2d.setPaint(paint);
            g2d.fillRect(r.x, r.y, r.width, r.height);
        }
        if ((mon = this.monitor) != null) {
            mon.paint(g2d);
        }
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public void setBackgroundPaint(Paint backgroundPaint) {
        this.backgroundPaint = backgroundPaint;
    }

    public Monitor getMonitor() {
        return this.monitor;
    }

    public void setMonitor(Monitor monitor) {
        this.monitor = monitor;
        this.invalidate();
    }
}

