/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.studio.common;

import com.spacekiller.util.Tools;
import com.waxmonster.studio.Preset;
import com.waxmonster.studio.PresetRegistry;
import com.waxmonster.studio.Studio;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PresetChooserPanel
extends JPanel {
    private static final long serialVersionUID = 2598045514137504542L;
    private static final Logger logger = Logger.getLogger(PresetChooserPanel.class.getName());
    private Studio studio;
    private String deviceName;
    private DefaultListModel presetListModel;
    private transient ActionListener actionListeners;
    private JTextField textFieldSearch;
    private JList listPresets;

    public PresetChooserPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        this.textFieldSearch = new JTextField();
        this.textFieldSearch.setToolTipText("Search presets...");
        this.textFieldSearch.setOpaque(false);
        GridBagConstraints gbc_textFieldSearch = new GridBagConstraints();
        gbc_textFieldSearch.weightx = 1.0;
        gbc_textFieldSearch.fill = 2;
        gbc_textFieldSearch.gridx = 0;
        gbc_textFieldSearch.gridy = 0;
        this.add((Component)this.textFieldSearch, gbc_textFieldSearch);
        this.textFieldSearch.setColumns(10);
        JScrollPane scrollPane = new JScrollPane();
        GridBagConstraints gbc_scrollPane = new GridBagConstraints();
        gbc_scrollPane.weighty = 1.0;
        gbc_scrollPane.weightx = 1.0;
        gbc_scrollPane.fill = 1;
        gbc_scrollPane.gridx = 0;
        gbc_scrollPane.gridy = 1;
        this.add((Component)scrollPane, gbc_scrollPane);
        this.listPresets = new JList();
        this.listPresets.setToolTipText("Presets");
        this.listPresets.setSelectionMode(0);
        this.listPresets.setOpaque(false);
        scrollPane.setViewportView(this.listPresets);
        this.initPresetChooserPanel();
    }

    private void initPresetChooserPanel() {
        this.textFieldSearch.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                PresetChooserPanel.this.searchChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                PresetChooserPanel.this.searchChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                PresetChooserPanel.this.searchChanged();
            }
        });
        this.presetListModel = new DefaultListModel();
        this.listPresets.setModel(this.presetListModel);
        this.listPresets.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                PresetChooserPanel.this.presetClicked(e);
            }
        });
    }

    protected JTextField getTextFieldSearch() {
        return this.textFieldSearch;
    }

    protected JList getListPresets() {
        return this.listPresets;
    }

    public Preset getSelectedPreset() {
        Object value = this.listPresets.getSelectedValue();
        if (value != null && value instanceof Preset) {
            return (Preset)value;
        }
        return null;
    }

    protected void presetClicked(MouseEvent ev) {
        if (ev.getClickCount() == 2) {
            this.fireActionPerformed(new ActionEvent(this, 1001, "action"));
        }
    }

    protected void fireActionPerformed(ActionEvent e) {
        if (this.actionListeners == null) {
            return;
        }
        this.actionListeners.actionPerformed(e);
    }

    public void addActionListener(ActionListener listener) {
        this.actionListeners = AWTEventMulticaster.add(this.actionListeners, listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.actionListeners = AWTEventMulticaster.remove(this.actionListeners, listener);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])AWTEventMulticaster.getListeners((EventListener)this.actionListeners, ActionListener.class);
    }

    protected void searchChanged() {
        try {
            String search = this.textFieldSearch.getText();
            StringBuffer sb = new StringBuffer();
            sb.append(".*");
            StringTokenizer tok = new StringTokenizer(search, "*%", true);
            while (tok.hasMoreTokens()) {
                String s = tok.nextToken();
                if ("*".equals(s) || "%".equals(s)) {
                    sb.append(".*");
                    continue;
                }
                String q = Tools.quoteRegex((String)s);
                sb.append(q);
            }
            sb.append(".*");
            String regex = sb.toString();
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Searching presets: " + search + " => " + regex);
            }
            int flags = 34;
            Pattern presetNamePattern = Pattern.compile(regex, flags);
            final ArrayList results = new ArrayList();
            this.searchByPresetName(presetNamePattern, results);
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Results: " + results.size());
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PresetChooserPanel.this.presetListModel.removeAllElements();
                    if (!results.isEmpty()) {
                        Iterator i = results.iterator();
                        while (i.hasNext()) {
                            PresetChooserPanel.this.presetListModel.addElement(i.next());
                        }
                    }
                }
            });
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected void searchByPresetName(Pattern presetNamePattern, Collection results) {
        String deviceName = this.deviceName;
        Studio studio = this.studio;
        if (studio == null) {
            return;
        }
        try {
            int num = studio.getPresetCount();
            for (int i = 0; i < num; ++i) {
                Matcher matcher;
                String presetName;
                Preset preset = studio.getPresetAt(i);
                if (preset == null || (presetName = preset.getPresetName()) == null || deviceName != null && !deviceName.equals(preset.getDeviceName()) || !(matcher = presetNamePattern.matcher(presetName)).matches()) continue;
                results.add(preset);
            }
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        try {
            PresetRegistry registry = studio.getPresetRegistry();
            if (registry != null) {
                registry.searchByPresetName(presetNamePattern, deviceName, results);
            }
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public Studio getStudio() {
        return this.studio;
    }

    public void setStudio(Studio studio) {
        this.studio = studio;
        this.refresh();
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
        this.refresh();
    }

    public void refresh() {
        this.searchChanged();
    }
}

