/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.studio.common;

import com.waxmonster.studio.Preset;
import com.waxmonster.studio.common.PresetManagerPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class PresetManagerDialog
extends JDialog {
    private static final long serialVersionUID = -576677242582304588L;
    private final ActionHandler actionHandler = new ActionHandler();
    private boolean loadPresetAction;
    private PresetManagerPanel presetManagerPanel;
    private JButton btnLoadPreset;
    private JPanel panelContent;

    public PresetManagerDialog() {
        this.setTitle("Presets");
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        this.getContentPane().setLayout(gridBagLayout);
        this.panelContent = new JPanel();
        GridBagConstraints gbc_panelContent = new GridBagConstraints();
        gbc_panelContent.weighty = 1.0;
        gbc_panelContent.weightx = 1.0;
        gbc_panelContent.insets = new Insets(8, 8, 8, 8);
        gbc_panelContent.fill = 1;
        gbc_panelContent.gridx = 0;
        gbc_panelContent.gridy = 0;
        this.getContentPane().add((Component)this.panelContent, gbc_panelContent);
        this.panelContent.setLayout(new GridLayout(1, 0, 0, 0));
        JPanel panelButtons = new JPanel();
        GridBagConstraints gbc_panelButtons = new GridBagConstraints();
        gbc_panelButtons.insets = new Insets(0, 8, 8, 8);
        gbc_panelButtons.gridx = 0;
        gbc_panelButtons.gridy = 1;
        this.getContentPane().add((Component)panelButtons, gbc_panelButtons);
        GridBagLayout gbl_panelButtons = new GridBagLayout();
        gbl_panelButtons.columnWidths = new int[]{0, 0, 0};
        gbl_panelButtons.rowHeights = new int[]{0, 0};
        gbl_panelButtons.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_panelButtons.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panelButtons.setLayout(gbl_panelButtons);
        this.btnLoadPreset = new JButton("Load Preset");
        this.btnLoadPreset.setToolTipText("Load selected preset");
        this.btnLoadPreset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PresetManagerDialog.this.actionLoad();
            }
        });
        GridBagConstraints gbc_btnLoadPreset = new GridBagConstraints();
        gbc_btnLoadPreset.insets = new Insets(0, 0, 0, 5);
        gbc_btnLoadPreset.gridx = 0;
        gbc_btnLoadPreset.gridy = 0;
        panelButtons.add((Component)this.btnLoadPreset, gbc_btnLoadPreset);
        JButton btnCancel = new JButton("Close");
        btnCancel.setToolTipText("Close dialog");
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PresetManagerDialog.this.actionCancel();
            }
        });
        GridBagConstraints gbc_btnCancel = new GridBagConstraints();
        gbc_btnCancel.gridx = 1;
        gbc_btnCancel.gridy = 0;
        panelButtons.add((Component)btnCancel, gbc_btnCancel);
    }

    public PresetManagerPanel getPresetManagerPanel() {
        return this.presetManagerPanel;
    }

    public synchronized void setPresetManagerPanel(PresetManagerPanel newPresetManagerPanel) {
        if (this.presetManagerPanel != null) {
            this.presetManagerPanel.removeActionListener(this.actionHandler);
            this.panelContent.removeAll();
        }
        this.presetManagerPanel = newPresetManagerPanel;
        if (this.presetManagerPanel != null) {
            this.presetManagerPanel.addActionListener(this.actionHandler);
            this.panelContent.add(this.presetManagerPanel);
        }
    }

    protected JButton getBtnLoadPreset() {
        return this.btnLoadPreset;
    }

    protected JPanel getPanelContent() {
        return this.panelContent;
    }

    protected void actionLoad() {
        Preset preset;
        Preset preset2 = preset = this.presetManagerPanel == null ? null : this.presetManagerPanel.getSelectedPreset();
        if (preset == null) {
            return;
        }
        this.loadPresetAction = true;
        this.dispose();
    }

    protected void actionCancel() {
        this.loadPresetAction = false;
        this.dispose();
    }

    public boolean isLoadPresetAction() {
        return this.loadPresetAction;
    }

    protected void setLoadPresetAction(boolean loadPresetAction) {
        this.loadPresetAction = loadPresetAction;
    }

    protected class ActionHandler
    implements ActionListener {
        protected ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PresetManagerDialog.this.actionLoad();
        }
    }
}

