/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.studio.common;

import com.spacekiller.util.Tools;
import com.waxmonster.studio.Preset;
import com.waxmonster.studio.Studio;
import com.waxmonster.studio.common.PresetChooserPanel;
import com.waxmonster.studio.common.PresetManagerDialog;
import com.waxmonster.studio.common.PresetProducer;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PresetManagerPanel
extends JPanel {
    private static final long serialVersionUID = 8983442320419385523L;
    private static final Logger logger = Logger.getLogger(PresetManagerPanel.class.getName());
    private Studio studio;
    private String deviceName;
    private String presetName;
    private PresetProducer presetProducer;
    private PresetChooserPanel presetChooserPanel;
    private JTextField textFieldName;
    private JButton btnSave;

    public PresetManagerPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JPanel panelPreset = new JPanel();
        GridBagConstraints gbc_panelPreset = new GridBagConstraints();
        gbc_panelPreset.insets = new Insets(0, 0, 5, 0);
        gbc_panelPreset.fill = 1;
        gbc_panelPreset.gridx = 0;
        gbc_panelPreset.gridy = 0;
        this.add((Component)panelPreset, gbc_panelPreset);
        GridBagLayout gbl_panelPreset = new GridBagLayout();
        gbl_panelPreset.columnWidths = new int[]{0, 0, 0, 0};
        gbl_panelPreset.rowHeights = new int[]{0, 0};
        gbl_panelPreset.columnWeights = new double[]{0.0, 1.0, 0.0, Double.MIN_VALUE};
        gbl_panelPreset.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panelPreset.setLayout(gbl_panelPreset);
        JLabel lblPreset = new JLabel("Preset:");
        GridBagConstraints gbc_lblPreset = new GridBagConstraints();
        gbc_lblPreset.insets = new Insets(0, 0, 0, 5);
        gbc_lblPreset.anchor = 13;
        gbc_lblPreset.gridx = 0;
        gbc_lblPreset.gridy = 0;
        panelPreset.add((Component)lblPreset, gbc_lblPreset);
        this.textFieldName = new JTextField();
        this.textFieldName.setToolTipText("Preset Name");
        GridBagConstraints gbc_textFieldName = new GridBagConstraints();
        gbc_textFieldName.insets = new Insets(0, 0, 0, 5);
        gbc_textFieldName.fill = 1;
        gbc_textFieldName.gridx = 1;
        gbc_textFieldName.gridy = 0;
        panelPreset.add((Component)this.textFieldName, gbc_textFieldName);
        this.textFieldName.setColumns(10);
        this.btnSave = new JButton("");
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PresetManagerPanel.this.actionSavePreset();
            }
        });
        this.btnSave.setMargin(new Insets(2, 4, 2, 4));
        this.btnSave.setIcon(new ImageIcon(PresetManagerPanel.class.getResource("/com/waxmonster/studio/common/icons/insert.gif")));
        this.btnSave.setToolTipText("Create Preset");
        GridBagConstraints gbc_btnSave = new GridBagConstraints();
        gbc_btnSave.gridx = 2;
        gbc_btnSave.gridy = 0;
        panelPreset.add((Component)this.btnSave, gbc_btnSave);
        this.presetChooserPanel = new PresetChooserPanel();
        GridBagConstraints gbc_presetChooserPanel = new GridBagConstraints();
        gbc_presetChooserPanel.weighty = 1.0;
        gbc_presetChooserPanel.weightx = 1.0;
        gbc_presetChooserPanel.fill = 1;
        gbc_presetChooserPanel.gridx = 0;
        gbc_presetChooserPanel.gridy = 1;
        this.add((Component)this.presetChooserPanel, gbc_presetChooserPanel);
        this.initMidiPresetManagerPanel();
    }

    protected void initMidiPresetManagerPanel() {
        this.textFieldName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                PresetManagerPanel.this.checkEnable();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                PresetManagerPanel.this.checkEnable();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                PresetManagerPanel.this.checkEnable();
            }
        });
        this.checkEnable();
    }

    protected void checkEnable() {
        String name = this.textFieldName.getText();
        this.btnSave.setEnabled(this.presetProducer != null && name.trim().length() > 0);
    }

    protected PresetChooserPanel getPresetChooserPanel() {
        return this.presetChooserPanel;
    }

    public Studio getStudio() {
        return this.studio;
    }

    public void setStudio(Studio studio) {
        this.studio = studio;
        this.presetChooserPanel.setStudio(studio);
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
        this.presetChooserPanel.setDeviceName(deviceName);
    }

    public void addActionListener(ActionListener listener) {
        this.presetChooserPanel.addActionListener(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.presetChooserPanel.removeActionListener(listener);
    }

    public void refresh() {
        this.presetChooserPanel.refresh();
    }

    public boolean showDialog(Component parent, String title) {
        PresetManagerDialog dialog = new PresetManagerDialog();
        dialog.setModal(true);
        dialog.setPresetManagerPanel(this);
        dialog.pack();
        Tools.centerWindow((Component)parent, (Window)dialog);
        dialog.setVisible(true);
        return dialog.isLoadPresetAction();
    }

    public Preset getSelectedPreset() {
        return this.presetChooserPanel.getSelectedPreset();
    }

    protected JTextField getTextFieldName() {
        return this.textFieldName;
    }

    protected JButton getBtnSave() {
        return this.btnSave;
    }

    public String getPresetName() {
        return this.presetName;
    }

    public void setPresetName(String presetName) {
        this.presetName = presetName;
        if (presetName == null) {
            presetName = "";
        }
        this.textFieldName.setText(presetName);
    }

    public PresetProducer getPresetProducer() {
        return this.presetProducer;
    }

    public void setPresetProducer(PresetProducer presetProducer) {
        this.presetProducer = presetProducer;
    }

    protected void actionSavePreset() {
        PresetProducer producer = this.getPresetProducer();
        if (producer == null) {
            return;
        }
        Studio studio = this.getStudio();
        if (studio == null) {
            return;
        }
        String devName = this.getDeviceName();
        if (devName == null) {
            return;
        }
        try {
            Preset preset;
            String presetName = this.textFieldName.getText();
            if (presetName == null) {
                return;
            }
            if ((presetName = presetName.trim()).length() < 1) {
                return;
            }
            Preset old = null;
            Preset[] presets = studio.getPresets();
            if (presets != null) {
                int messageType;
                int optionType;
                String title;
                String message;
                int rc;
                for (Preset preset2 : presets) {
                    if (preset2 == null || !presetName.equals(preset2.getPresetName()) || devName == null || !devName.equals(preset2.getDeviceName())) continue;
                    old = preset2;
                    break;
                }
                if (old != null && (rc = JOptionPane.showConfirmDialog(this, message = "Are you sure to overwrite the existing preset ?", title = "Overwrite Preset ?", optionType = 2, messageType = 3)) != 0) {
                    return;
                }
            }
            if ((preset = producer.createPreset()) == null) {
                return;
            }
            preset.setPresetName(presetName);
            preset.setDeviceName(this.deviceName);
            int index = -1;
            if (old != null) {
                index = studio.getPresetIndex(old);
            }
            if (index >= 0) {
                studio.removePresetAt(index);
                studio.insertPresetAt(preset, index);
            } else {
                studio.addPreset(preset);
            }
            this.refresh();
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }
}

