/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.heap.j16;

import com.spacekiller.util.heap.AbstractPage;
import com.spacekiller.util.heap.Area;
import com.spacekiller.util.heap.ByteArrayPage;
import com.spacekiller.util.heap.ByteBufferPage;
import com.spacekiller.util.heap.Page;
import com.spacekiller.util.heap.j16.Unsafer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.misc.Unsafe;

public class UnsafePage
extends AbstractPage {
    private static final Logger logger = Logger.getLogger(UnsafePage.class.getName());
    private static final Unsafe unsafe = UnsafePage.initUnsafe();
    private static final long arrayBaseOffset = UnsafePage.initArrayBaseOffset();
    private long addr;
    protected final byte[] cb;

    protected UnsafePage(Area area, int size, byte[] copyBuf) {
        super(area, size);
        long address;
        if (size < 1) {
            throw new IllegalArgumentException("Invalid page size: " + size);
        }
        this.addr = address = unsafe.allocateMemory(size);
        this.cb = copyBuf;
    }

    public static AbstractPage createUnsafePage(Area area, int size, byte[] copyBuf) {
        if (unsafe == null) {
            return null;
        }
        return new UnsafePage(area, size, copyBuf);
    }

    private static Unsafe initUnsafe() {
        return Unsafer.getUnsafe();
    }

    private static long initArrayBaseOffset() {
        try {
            Unsafe unsafe = Unsafer.getUnsafe();
            if (unsafe != null) {
                long offset = unsafe.arrayBaseOffset(byte[].class);
                return offset;
            }
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        return 0L;
    }

    void checkRange(int off, int len) {
        if (off < 0 || off + len > this.size) {
            throw new IndexOutOfBoundsException();
        }
    }

    public void read(int off, byte[] arr, int ofs, int len) throws IOException {
        this.checkRange(off, len);
        long a = this.addr + (long)off;
        Unsafer.copyToArray(a, arr, arrayBaseOffset, ofs, len);
    }

    public void write(int off, byte[] arr, int ofs, int len) throws IOException {
        this.checkRange(off, len);
        long a = this.addr + (long)off;
        Unsafer.copyFromArray(arr, arrayBaseOffset, ofs, a, len);
    }

    public void read(int off, ByteBuffer buf) throws IOException {
        int len = buf.remaining();
        this.checkRange(off, len);
        long a = this.addr + (long)off;
        for (int i = 0; i < len; ++i) {
            buf.put(unsafe.getByte(a++));
        }
    }

    public void write(int off, ByteBuffer buf) throws IOException {
        int len = buf.remaining();
        this.checkRange(off, len);
        long a = this.addr + (long)off;
        for (int i = 0; i < len; ++i) {
            unsafe.putByte(a++, buf.get());
        }
    }

    public void read(int off, OutputStream dst, int len) throws IOException {
        this.checkRange(off, len);
        long a = this.addr + (long)off;
        byte[] byArray = this.cb;
        synchronized (this.cb) {
            while (true) {
                int n = Math.min(len, this.cb.length);
                Unsafer.copyToArray(a, this.cb, arrayBaseOffset, 0L, n);
                dst.write(this.cb, 0, n);
                if (n >= len) {
                    // ** MonitorExit[var7_5] (shouldn't be in output)
                    return;
                }
                len -= n;
                a += (long)n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(int off, InputStream src, int len) throws IOException {
        this.checkRange(off, len);
        long a = this.addr + (long)off;
        int n = Math.min(len, this.cb.length);
        byte[] byArray = this.cb;
        synchronized (this.cb) {
            n = src.read(this.cb, 0, n);
            if (n < 1) {
                // ** MonitorExit[var7_6] (shouldn't be in output)
                return n == 0 ? 0 : -1;
            }
            Unsafer.copyFromArray(this.cb, arrayBaseOffset, 0L, a, n);
            // ** MonitorExit[var7_6] (shouldn't be in output)
            return n;
        }
    }

    public void get(int off, Page dst, int ofs, int len) throws IOException {
        this.checkRange(off, len);
        dst.put(ofs, (Page)this, off, len);
    }

    public void put(int off, Page src, int ofs, int len) throws IOException {
        if (src instanceof ByteArrayPage || src instanceof ByteBufferPage) {
            src.get(ofs, (Page)this, off, len);
            return;
        }
        if (src instanceof UnsafePage) {
            UnsafePage up = (UnsafePage)src;
            up.checkRange(ofs, len);
            this.checkRange(off, len);
            unsafe.copyMemory(up.addr + (long)ofs, this.addr + (long)off, len);
            return;
        }
        byte[] byArray = this.cb;
        synchronized (this.cb) {
            while (true) {
                int n = Math.min(len, this.cb.length);
                src.read(ofs, this.cb, 0, n);
                this.write(off, this.cb, 0, n);
                if (n >= len) {
                    // ** MonitorExit[var6_7] (shouldn't be in output)
                    return;
                }
                ofs += n;
                off += n;
                len -= n;
            }
        }
    }

    protected synchronized void dispose() throws IOException {
        long address = this.addr;
        if (address != 0L) {
            this.addr = 0L;
            unsafe.freeMemory(address);
        }
    }
}

