/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.server;

import com.spacekiller.util.FileResource;
import com.spacekiller.util.Resource;
import com.spacekiller.util.buffer.ByteArrayOutputBuffer;
import com.spacekiller.util.media.DefaultMediaEntry;
import com.spacekiller.util.media.MediaContext;
import com.spacekiller.util.media.MediaCrate;
import com.spacekiller.util.media.MediaCrateEntry;
import com.spacekiller.util.media.MediaEntry;
import com.spacekiller.util.media.MediaLibrary;
import com.spacekiller.util.media.MediaUtil;
import com.spacekiller.util.media.MutableMediaEntry;
import com.spacekiller.util.media.SeekableStream;
import com.spacekiller.util.media.library.remote.ProtocolConst;
import com.spacekiller.util.media.server.MediaInputHandler;
import com.spacekiller.util.media.server.MediaInputManager;
import com.spacekiller.util.media.server.MediaServer;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;

public class MediaClientHandler
implements ProtocolConst {
    private static final Logger logger = Logger.getLogger(MediaClientHandler.class.getName());
    private final MediaServer server;
    private final Socket socket;
    private final DataInputStream in;
    private final DataOutputStream out;
    private final MediaLibrary lib;
    private final MediaContext ctx;
    private final Thread thread;
    private final MediaInputManager manager;
    private volatile boolean loop;
    private byte[] buf;
    private ByteArrayInputStream bais;
    private DataInputStream bdis;
    private ByteArrayOutputBuffer baos;
    private DataOutputStream bdos;

    public MediaClientHandler(MediaServer server, Socket socket, DataInputStream in, DataOutputStream out, MediaLibrary lib, MediaContext ctx, String threadName, int threadPriority, MediaInputManager manager) {
        if (server == null || socket == null || in == null || out == null || lib == null || ctx == null || manager == null) {
            throw new NullPointerException();
        }
        this.manager = manager;
        this.server = server;
        this.socket = socket;
        this.in = in;
        this.out = out;
        this.lib = lib;
        this.ctx = ctx;
        int bufSize = 16384;
        this.buf = new byte[bufSize];
        this.bais = new ByteArrayInputStream(this.buf);
        this.bdis = new DataInputStream(this.bais);
        this.baos = new ByteArrayOutputBuffer(bufSize);
        this.bdos = new DataOutputStream((OutputStream)this.baos);
        this.loop = true;
        Async async = new Async();
        this.thread = new Thread((Runnable)async, threadName);
        this.thread.setPriority(threadPriority);
    }

    public void start() {
        this.thread.start();
    }

    public void stop() throws InterruptedException {
        this.loop = false;
        this.thread.interrupt();
    }

    protected void process() throws IOException {
        block17: while (this.loop) {
            byte req = this.in.readByte();
            switch (req) {
                case -95: {
                    this.handleRQ_GET_ENTRY();
                    continue block17;
                }
                case -94: {
                    this.handleRQ_GET_ENTRIES();
                    continue block17;
                }
                case -96: {
                    this.handleRQ_HAS_ENTRY();
                    continue block17;
                }
                case -86: {
                    this.handleRQ_PUT_ENTRY();
                    continue block17;
                }
                case -84: {
                    this.handleRQ_SET_RATING();
                    continue block17;
                }
                case -83: {
                    this.handleRQ_SET_COMMENT();
                    continue block17;
                }
                case -55: {
                    this.handleRQ_READ_STREAM();
                    continue block17;
                }
                case -54: {
                    this.handleRQ_SEEK_STREAM();
                    continue block17;
                }
                case -53: {
                    this.handleRQ_CLOSE_STREAM();
                    continue block17;
                }
                case -56: {
                    this.handleRQ_OPEN_STREAM();
                    continue block17;
                }
                case -75: {
                    this.handleRQ_GET_CRATE_INFO();
                    continue block17;
                }
                case -64: {
                    this.handleRQ_GET_CRATE_ENTRIES();
                    continue block17;
                }
                case -74: {
                    this.handleRQ_GET_SUB_CRATES();
                    continue block17;
                }
                case -73: {
                    this.handleRQ_GET_SUB_CRATES_RECURSIVE();
                    continue block17;
                }
                case 99: {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("Disconnect request received.");
                    }
                    return;
                }
            }
            throw new StreamCorruptedException("Invalid request type: " + req);
        }
    }

    protected void handleRQ_HAS_ENTRY() throws IOException {
        int dataLen = this.in.readInt();
        this.in.readFully(this.buf, 0, dataLen);
        this.bais.reset();
        String path = this.bdis.readUTF();
        boolean found = false;
        try {
            Resource resource = this.server.getResource(this, path);
            if (resource != null) {
                found = this.lib.containsMediaEntry(resource);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        this.out.writeByte(found ? 0 : 2);
        this.out.flush();
    }

    protected void handleRQ_GET_ENTRY() throws IOException {
        int dataLen = this.in.readInt();
        this.in.readFully(this.buf, 0, dataLen);
        this.bais.reset();
        int flags = this.bdis.read();
        String path = this.bdis.readUTF();
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("handleRQ_GET_ENTRY: path=" + path);
        }
        MediaEntry entry = null;
        try {
            Resource resource = this.server.getResource(this, path);
            if (resource != null) {
                entry = this.lib.getMediaEntry(resource, flags);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        if (entry == null) {
            this.out.writeByte(2);
            this.out.flush();
            return;
        }
        this.baos.reset();
        entry.writeEntry((DataOutput)this.bdos, (Resource)null);
        this.bdos.flush();
        int len = this.baos.getCount();
        byte[] data = this.baos.getBuffer();
        this.out.writeByte(0);
        this.out.writeInt(len);
        this.out.write(data, 0, len);
        this.out.flush();
    }

    protected void handleRQ_GET_ENTRIES() throws IOException {
        int dataLen = this.in.readInt();
        this.in.readFully(this.buf, 0, dataLen);
        this.bais.reset();
        int flags = this.bdis.read();
        int num = this.bdis.readInt();
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("handleRQ_GET_ENTRIES: num=" + num);
        }
        if (num < 1) {
            num = 0;
        }
        this.baos.reset();
        this.bdos.writeInt(num);
        for (int i = 0; i < num; ++i) {
            String path = this.bdis.readUTF();
            MediaEntry entry = null;
            try {
                Resource resource = this.server.getResource(this, path);
                if (resource != null && (entry = this.lib.getMediaEntry(resource, flags)) != null) {
                    this.bdos.writeByte(0);
                    entry.writeEntry((DataOutput)this.bdos, (Resource)null);
                    continue;
                }
                this.bdos.writeByte(2);
                continue;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                this.bdos.writeByte(1);
            }
        }
        this.bdos.flush();
        int len = this.baos.getCount();
        byte[] data = this.baos.getBuffer();
        this.out.writeByte(0);
        this.out.writeInt(len);
        this.out.write(data, 0, len);
        this.out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleRQ_PUT_ENTRY() throws IOException {
        int dataLen = this.in.readInt();
        this.in.readFully(this.buf, 0, dataLen);
        this.bais.reset();
        String path = this.bdis.readUTF();
        boolean done = false;
        try {
            Resource resource;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("handleRQ_PUT_ENTRY: path=" + path);
            }
            DefaultMediaEntry entry = new DefaultMediaEntry();
            entry.readEntry((DataInput)this.bdis, this.ctx);
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("handleRQ_PUT_ENTRY: path=" + path + ", entry=" + entry);
            }
            if ((resource = this.server.getResource(this, path)) != null) {
                entry.setResource(resource);
                this.lib.putMediaEntry(resource, (MediaEntry)entry);
                done = true;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        finally {
            if (!done) {
                this.out.writeByte(1);
                this.out.flush();
                return;
            }
            this.out.writeByte(0);
            this.out.flush();
            this.flushLibraryChanges();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleRQ_SET_RATING() throws IOException {
        int dataLen = this.in.readInt();
        this.in.readFully(this.buf, 0, dataLen);
        this.bais.reset();
        String path = this.bdis.readUTF();
        double rating = this.bdis.readDouble();
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("handleRQ_SET_RATING: path=" + path + ", rating=" + rating);
        }
        boolean done = false;
        try {
            MediaEntry entry;
            Resource resource = this.server.getResource(this, path);
            if (resource != null && (entry = this.lib.getMediaEntry(resource)) != null && entry instanceof MutableMediaEntry) {
                MutableMediaEntry mme = (MutableMediaEntry)entry;
                this.lib.setUserRating(mme, rating);
                done = true;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        finally {
            if (!done) {
                this.out.writeByte(1);
                this.out.flush();
                return;
            }
            this.out.writeByte(0);
            this.out.flush();
            this.flushLibraryChanges();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleRQ_SET_COMMENT() throws IOException {
        int dataLen = this.in.readInt();
        this.in.readFully(this.buf, 0, dataLen);
        this.bais.reset();
        String path = this.bdis.readUTF();
        String comment = MediaUtil.readString((DataInput)this.bdis);
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("handleRQ_SET_COMMENT: path=" + path + ", comment=" + comment);
        }
        boolean done = false;
        try {
            MediaEntry entry;
            Resource resource = this.server.getResource(this, path);
            if (resource != null && (entry = this.lib.getMediaEntry(resource)) != null && entry instanceof MutableMediaEntry) {
                MutableMediaEntry mme = (MutableMediaEntry)entry;
                this.lib.setUserComment(mme, comment);
                done = true;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        finally {
            if (!done) {
                this.out.writeByte(1);
                this.out.flush();
                return;
            }
            this.out.writeByte(0);
            this.out.flush();
            this.flushLibraryChanges();
        }
    }

    protected void flushLibraryChanges() {
        try {
            this.lib.flush();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected void handleRQ_OPEN_STREAM() throws IOException {
        int dataLen = this.in.readInt();
        this.in.readFully(this.buf, 0, dataLen);
        this.bais.reset();
        byte streamType = this.bdis.readByte();
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("handleRQ_OPEN_STREAM: streamType=" + streamType);
        }
        switch (streamType) {
            case 1: {
                this.handleRQ_OPEN_STREAM_RAW();
                return;
            }
            case 2: {
                this.handleRQ_OPEN_STREAM_AUDIO();
                return;
            }
            case 3: {
                this.handleRQ_OPEN_STREAM_SEEKABLE();
                return;
            }
        }
        this.out.writeByte(1);
        this.out.flush();
    }

    protected void handleRQ_OPEN_STREAM_RAW() throws IOException {
        boolean seekable = this.bdis.readBoolean();
        String path = this.bdis.readUTF();
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("handleRQ_OPEN_STREAM_RAW: path=" + path);
        }
        try {
            Resource resource = this.server.getResource(this, path);
            if (resource != null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Creating raw input stream: resource=" + resource);
                }
                InputStream stream = this.lib.createInputStream(resource, seekable);
                MediaInputHandler handler = this.manager.putInputHandler(resource, stream);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Created raw input stream #" + handler.getId() + ": stream=" + stream);
                }
                this.baos.reset();
                this.bdos.writeInt(handler.getId());
                this.bdos.writeLong(-1L);
                this.bdos.flush();
                int len = this.baos.getCount();
                byte[] data = this.baos.getBuffer();
                this.out.writeByte(0);
                this.out.writeInt(len);
                this.out.write(data, 0, len);
                this.out.flush();
                return;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        this.out.writeByte(2);
        this.out.flush();
    }

    protected void handleRQ_OPEN_STREAM_AUDIO() throws IOException {
        byte formatType = this.bdis.readByte();
        switch (formatType) {
            case 1: {
                this.handleRQ_OPEN_STREAM_AUDIO_RAW();
                return;
            }
            case 2: {
                this.handleRQ_OPEN_STREAM_AUDIO_CUSTOM();
                return;
            }
        }
        this.out.writeByte(1);
        this.out.flush();
    }

    protected void handleRQ_OPEN_STREAM_AUDIO_RAW() throws IOException {
        boolean seekable = this.bdis.readBoolean();
        String path = this.bdis.readUTF();
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("handleRQ_OPEN_STREAM_AUDIO: path=" + path);
        }
        try {
            Resource resource = this.server.getResource(this, path);
            if (resource != null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Creating raw audio stream: resource=" + resource);
                }
                AudioInputStream stream = this.lib.createAudioInputStream(resource, seekable);
                MediaInputHandler handler = this.manager.putInputHandler(resource, stream);
                AudioFormat audioFormat = stream.getFormat();
                int frameSize = audioFormat.getFrameSize();
                long byteLength = -1L;
                long frameLength = stream.getFrameLength();
                if (frameLength > 0L && frameSize > 0) {
                    byteLength = frameLength * (long)frameSize;
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Created raw audio stream #" + handler.getId() + ": stream=" + stream + ", format=" + audioFormat);
                }
                this.baos.reset();
                this.bdos.writeInt(handler.getId());
                this.bdos.writeLong(byteLength);
                MediaUtil.writeAudioFormat((AudioFormat)audioFormat, (DataOutput)this.bdos);
                this.bdos.flush();
                int len = this.baos.getCount();
                byte[] data = this.baos.getBuffer();
                this.out.writeByte(0);
                this.out.writeInt(len);
                this.out.write(data, 0, len);
                this.out.flush();
                return;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        this.out.writeByte(2);
        this.out.flush();
    }

    protected void handleRQ_OPEN_STREAM_AUDIO_CUSTOM() throws IOException {
        boolean seekable = this.bdis.readBoolean();
        AudioFormat targetFormat = MediaUtil.readAudioFormat((DataInput)this.bdis);
        String path = this.bdis.readUTF();
        try {
            Resource resource = this.server.getResource(this, path);
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("handleRQ_OPEN_STREAM_AUDIO: resource=" + resource + ", targetFormat=" + targetFormat);
            }
            if (resource != null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Creating custom audio stream: resource=" + resource + ", format=" + targetFormat);
                }
                AudioInputStream stream = this.lib.createAudioInputStream(resource, targetFormat, seekable);
                MediaInputHandler handler = this.manager.putInputHandler(resource, stream);
                AudioFormat audioFormat = stream.getFormat();
                int frameSize = audioFormat.getFrameSize();
                long byteLength = -1L;
                long frameLength = stream.getFrameLength();
                if (frameLength > 0L && frameSize > 0) {
                    byteLength = frameLength * (long)frameSize;
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Created custom audio stream #" + handler.getId() + ": stream=" + stream + ", format=" + audioFormat);
                }
                this.baos.reset();
                this.bdos.writeInt(handler.getId());
                this.bdos.writeLong(byteLength);
                MediaUtil.writeAudioFormat((AudioFormat)audioFormat, (DataOutput)this.bdos);
                this.bdos.flush();
                int len = this.baos.getCount();
                byte[] data = this.baos.getBuffer();
                this.out.writeByte(0);
                this.out.writeInt(len);
                this.out.write(data, 0, len);
                this.out.flush();
                return;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        this.out.writeByte(2);
        this.out.flush();
    }

    protected void handleRQ_OPEN_STREAM_SEEKABLE() throws IOException {
        int origStreamId = this.bdis.readInt();
        long newPosition = this.bdis.readLong();
        logger.info("handleRQ_OPEN_STREAM_SEEKABLE: origStreamId=" + origStreamId + ", newPosition=" + newPosition);
        MediaInputHandler origHandler = this.manager.getInputHandler(origStreamId);
        if (origHandler != null) {
            try {
                Resource resource = origHandler.getResource();
                InputStream origStream = origHandler.getStream();
                if (origStream != null && origStream instanceof SeekableStream) {
                    InputStream stream = this.lib.createSeekableInputStream(origStream, newPosition);
                    MediaInputHandler handler = this.manager.putInputHandler(resource, stream);
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Created seekable input stream #" + handler.getId() + ": stream=" + stream);
                    }
                    this.baos.reset();
                    this.bdos.writeInt(handler.getId());
                    this.bdos.writeLong(-1L);
                    this.bdos.flush();
                    int len = this.baos.getCount();
                    byte[] data = this.baos.getBuffer();
                    this.out.writeByte(0);
                    this.out.writeInt(len);
                    this.out.write(data, 0, len);
                    this.out.flush();
                    return;
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        this.out.writeByte(2);
        this.out.flush();
    }

    protected void handleRQ_CLOSE_STREAM() throws IOException {
        int stream = this.in.readInt();
        MediaInputHandler handler = this.manager.removeInputHandler(stream);
        if (handler == null) {
            this.out.writeByte(2);
            this.out.flush();
            return;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Closing stream #" + stream + ": " + handler);
        }
        try {
            handler.close();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            this.out.writeByte(1);
            this.out.flush();
            return;
        }
        this.out.writeByte(0);
        this.out.flush();
    }

    protected void handleRQ_READ_STREAM() throws IOException {
        int n;
        int stream = this.in.readInt();
        int len = this.in.readInt();
        MediaInputHandler handler = this.manager.getInputHandler(stream);
        if (handler == null) {
            this.out.writeByte(2);
            this.out.flush();
            return;
        }
        if (len < 1) {
            this.out.writeByte(1);
            this.out.flush();
            return;
        }
        int num = Math.min(len, this.buf.length);
        try {
            n = handler.read(this.buf, 0, num);
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Stream #" + stream + ": len=" + n + " of " + len);
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            this.out.writeByte(1);
            this.out.flush();
            return;
        }
        this.out.writeByte(0);
        this.out.writeInt(n);
        if (n > 0) {
            this.out.write(this.buf, 0, n);
        }
        this.out.flush();
    }

    protected void handleRQ_SEEK_STREAM() throws IOException {
        int stream = this.in.readInt();
        long pos = this.in.readLong();
        MediaInputHandler handler = this.manager.getInputHandler(stream);
        if (handler == null) {
            this.out.writeByte(2);
            this.out.flush();
            return;
        }
        SeekableStream ss = handler.getSeekable();
        if (ss == null) {
            this.out.writeByte(1);
            this.out.flush();
            return;
        }
        try {
            ss.seek(pos);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            this.out.writeByte(1);
            this.out.flush();
            return;
        }
        this.out.writeByte(0);
        this.out.flush();
    }

    protected void handleRQ_GET_CRATE_INFO() throws IOException {
        String crateDescr;
        String crateId = this.in.readUTF();
        MediaCrate crate = null;
        try {
            crate = this.server.getMediaCrate(this, crateId);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            this.out.writeByte(1);
            this.out.flush();
            return;
        }
        if (crate == null) {
            this.out.writeByte(2);
            this.out.flush();
            return;
        }
        String crateName = crate.getName();
        if (crateName == null) {
            crateName = "";
        }
        if ((crateDescr = crate.getDescription()) == null) {
            crateDescr = "";
        }
        boolean crateReadOnly = crate.isReadOnly();
        this.out.writeByte(0);
        this.out.writeUTF(crateId);
        this.out.writeUTF(crateName);
        this.out.writeUTF(crateDescr);
        this.out.writeBoolean(crateReadOnly);
        this.out.flush();
    }

    protected void handleRQ_GET_SUB_CRATES_RECURSIVE() throws IOException {
        String crateId = this.in.readUTF();
        try {
            MediaCrate crate = this.server.getMediaCrate(this, crateId);
            if (crate != null) {
                this.out.writeByte(0);
                ArrayList tempList = new ArrayList();
                this.handleRQ_GET_SUB_CRATES_RECURSIVE(crate, tempList);
                this.out.flush();
                return;
            }
            this.out.writeByte(2);
            this.out.flush();
            return;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            this.out.writeByte(1);
            this.out.flush();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleRQ_GET_SUB_CRATES_RECURSIVE(MediaCrate crate, List tempList) throws IOException {
        MediaCrate entry;
        tempList.clear();
        MediaCrate mediaCrate = crate;
        synchronized (mediaCrate) {
            crate.getEntries((Collection)tempList);
        }
        int num = tempList.size();
        this.out.writeInt(num);
        if (num > 0) {
            for (int i = 0; i < num; ++i) {
                entry = (MediaCrateEntry)tempList.get(i);
                Resource resource = entry.getResource();
                String resourcePath = null;
                if (resource != null) {
                    if (resource instanceof FileResource) {
                        FileResource fileResource = (FileResource)resource;
                        File file = fileResource.getFile();
                        if (file != null) {
                            resourcePath = "file:" + file.getPath();
                        }
                    } else {
                        resourcePath = String.valueOf(resource);
                    }
                }
                if (resourcePath == null) {
                    resourcePath = "";
                }
                this.out.writeUTF(resourcePath);
            }
        }
        tempList.clear();
        entry = crate;
        synchronized (entry) {
            crate.getCrates((Collection)tempList);
        }
        num = tempList.size();
        this.out.writeInt(num);
        if (num > 0) {
            MediaCrate sub;
            for (int i = 0; i < num; ++i) {
                String subDescr;
                String subName;
                sub = (MediaCrate)tempList.get(i);
                String subId = sub.getId();
                if (subId == null) {
                    subId = "";
                }
                if ((subName = sub.getName()) == null) {
                    subName = "";
                }
                if ((subDescr = sub.getDescription()) == null) {
                    subDescr = "";
                }
                boolean subReadOnly = sub.isReadOnly();
                this.out.writeUTF(subId);
                this.out.writeUTF(subName);
                this.out.writeUTF(subDescr);
                this.out.writeBoolean(subReadOnly);
            }
            ArrayList subTempList = new ArrayList();
            for (int i = 0; i < num; ++i) {
                sub = (MediaCrate)tempList.get(i);
                this.handleRQ_GET_SUB_CRATES_RECURSIVE(sub, subTempList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleRQ_GET_SUB_CRATES() throws IOException {
        LinkedList subCrates;
        block10: {
            String crateId = this.in.readUTF();
            subCrates = null;
            try {
                MediaCrate crate = this.server.getMediaCrate(this, crateId);
                if (crate == null) break block10;
                subCrates = new LinkedList();
                MediaCrate mediaCrate = crate;
                synchronized (mediaCrate) {
                    crate.getCrates(subCrates);
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                this.out.writeByte(1);
                this.out.flush();
                return;
            }
        }
        if (subCrates == null) {
            this.out.writeByte(2);
            this.out.flush();
            return;
        }
        this.out.writeByte(0);
        int count = subCrates.size();
        this.out.writeInt(count);
        for (int i = 0; i < count; ++i) {
            String subDescr;
            String subName;
            MediaCrate sub = (MediaCrate)subCrates.get(i);
            String subId = sub.getId();
            if (subId == null) {
                subId = "";
            }
            if ((subName = sub.getName()) == null) {
                subName = "";
            }
            if ((subDescr = sub.getDescription()) == null) {
                subDescr = "";
            }
            boolean subReadOnly = sub.isReadOnly();
            this.out.writeUTF(subId);
            this.out.writeUTF(subName);
            this.out.writeUTF(subDescr);
            this.out.writeBoolean(subReadOnly);
        }
        this.out.flush();
    }

    protected void handleRQ_GET_CRATE_ENTRIES() throws IOException {
        String crateId = this.in.readUTF();
        LinkedList entries = null;
        try {
            MediaCrate crate = this.server.getMediaCrate(this, crateId);
            if (crate != null) {
                entries = new LinkedList();
                crate.getEntries(entries);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            this.out.writeByte(1);
            this.out.flush();
            return;
        }
        if (entries == null) {
            this.out.writeByte(2);
            this.out.flush();
            return;
        }
        this.out.writeByte(0);
        int count = entries.size();
        this.out.writeInt(count);
        for (int i = 0; i < count; ++i) {
            MediaCrateEntry entry = (MediaCrateEntry)entries.get(i);
            Resource resource = entry.getResource();
            String resourcePath = null;
            if (resource != null) {
                if (resource instanceof FileResource) {
                    FileResource fileResource = (FileResource)resource;
                    File file = fileResource.getFile();
                    if (file != null) {
                        resourcePath = "file:" + file.getPath();
                    }
                } else {
                    resourcePath = String.valueOf(resource);
                }
            }
            if (resourcePath == null) {
                resourcePath = "";
            }
            this.out.writeUTF(resourcePath);
        }
        this.out.flush();
    }

    protected class Async
    implements Runnable {
        protected Async() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("MediaLibraryHandler thread started: " + Thread.currentThread());
            }
            try {
                MediaClientHandler.this.process();
            }
            catch (EOFException e) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, e.getMessage(), e);
                }
            }
            catch (IOException e) {
                if (MediaClientHandler.this.loop) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            finally {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("MediaLibraryHandler thread stopping: " + Thread.currentThread());
                }
                try {
                    MediaClientHandler.this.socket.close();
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("MediaLibraryHandler thread stopped: " + Thread.currentThread());
                }
            }
        }
    }
}

