/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.server;

import com.spacekiller.util.media.AbstractMediaCrate;
import com.spacekiller.util.media.DirectoryMediaCrate;
import com.spacekiller.util.media.MediaCrate;
import com.spacekiller.util.media.MutableMediaCrate;
import com.spacekiller.util.media.library.CrateFileMediaCrate;
import com.spacekiller.util.media.server.MediaClientHandler;
import com.spacekiller.util.media.server.MediaServer;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class MediaCrateHandler {
    private final MediaServer server;
    private CrateFileMediaCrate rootCrate;
    private Map crateMap;
    private boolean crateMapLoaded;

    public MediaCrateHandler(MediaServer server, CrateFileMediaCrate rootCrate) {
        this.server = server;
        this.rootCrate = rootCrate;
        this.crateMap = new HashMap();
    }

    public MediaCrate getMediaCrate(MediaClientHandler handler, String crateId) throws Exception {
        this.lazyEnumerateCrates();
        return this.getMediaCrateImpl(handler, crateId);
    }

    protected MediaCrate getMediaCrateImpl(MediaClientHandler handler, String crateId) throws Exception {
        DirectoryMediaCrate dirParent;
        String dirParentPath;
        String subDirPath;
        File subDir;
        int x;
        MediaCrate crate = this.getCrate(crateId);
        if (crate != null) {
            return crate;
        }
        if (crateId == null || crateId.length() < 1) {
            return null;
        }
        MediaCrate parent = null;
        String parentId = crateId;
        while ((x = parentId.lastIndexOf(47)) >= 0 && (parent = this.getCrate(parentId = parentId.substring(0, x))) == null) {
        }
        if (parent == null) {
            return null;
        }
        if (parent instanceof DirectoryMediaCrate && (subDir = this.server.checkDirectoryAccess(handler, subDirPath = (dirParentPath = (dirParent = (DirectoryMediaCrate)parent).getPath()) + crateId.substring(parentId.length()))) != null) {
            String subDirName = subDir.getName();
            boolean recursive = true;
            return new DirectoryMediaCrate((AbstractMediaCrate)dirParent, crateId, subDirName, subDirPath, recursive);
        }
        return null;
    }

    protected synchronized MediaCrate getCrate(String id) {
        return (MediaCrate)this.crateMap.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lazyEnumerateCrates() {
        if (this.crateMapLoaded) {
            return;
        }
        MediaCrateHandler mediaCrateHandler = this;
        synchronized (mediaCrateHandler) {
            if (this.crateMapLoaded) {
                return;
            }
            this.enumerateCrates();
            this.crateMapLoaded = true;
        }
    }

    protected synchronized void enumerateCrates() {
        CrateFileMediaCrate rootCrate = this.rootCrate;
        if (rootCrate == null) {
            return;
        }
        ArrayList tempList = new ArrayList();
        this.enumerateSubCratesRecursive((MediaCrate)rootCrate, tempList);
        this.crateMap.put(null, rootCrate);
        this.crateMap.put("", rootCrate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void enumerateSubCratesRecursive(MediaCrate parent, ArrayList tempList) {
        String childId;
        MediaCrate child;
        int i;
        int oldCount = tempList.size();
        MediaCrate mediaCrate = parent;
        synchronized (mediaCrate) {
            parent.getCrates((Collection)tempList);
        }
        int newCount = tempList.size();
        boolean recursive = false;
        if (parent instanceof MutableMediaCrate) {
            recursive = true;
        }
        if (recursive) {
            for (i = oldCount; i < newCount; ++i) {
                child = (MediaCrate)tempList.get(i);
                if (child == null || (childId = child.getId()) == null) continue;
                this.enumerateSubCratesRecursive(child, tempList);
            }
        }
        for (i = oldCount; i < newCount; ++i) {
            child = (MediaCrate)tempList.get(i);
            if (child == null || (childId = child.getId()) == null) continue;
            this.crateMap.put(childId, child);
        }
    }
}

