/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.server;

import com.spacekiller.util.Resource;
import com.spacekiller.util.media.SeekableStream;
import java.io.IOException;
import java.io.InputStream;

public class MediaInputHandler {
    private final int id;
    private final Resource resource;
    private final InputStream stream;
    private final SeekableStream seekable;

    public MediaInputHandler(int id, Resource resource, InputStream stream, SeekableStream seekable) {
        this.id = id;
        this.resource = resource;
        this.stream = stream;
        this.seekable = seekable;
    }

    public String toString() {
        return super.toString() + "[id=" + this.id + ", resource=" + this.resource + ", stream=" + this.stream + "]";
    }

    public final int getId() {
        return this.id;
    }

    public final Resource getResource() {
        return this.resource;
    }

    public final InputStream getStream() {
        return this.stream;
    }

    public final SeekableStream getSeekable() {
        return this.seekable;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int ofs;
        int n = this.stream.read(b, off, len);
        if (n >= len) {
            return n;
        }
        if (n < 0) {
            return -1;
        }
        int end = off + len;
        for (ofs = off + n; ofs < end && (n = this.stream.read(b, ofs, end - ofs)) >= 1; ofs += n) {
        }
        return ofs - off;
    }

    public void close() throws IOException {
        this.stream.close();
    }
}

