/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.server;

import com.spacekiller.util.FileResource;
import com.spacekiller.util.Resource;
import com.spacekiller.util.URIResource;
import com.spacekiller.util.media.MediaContext;
import com.spacekiller.util.media.MediaCrate;
import com.spacekiller.util.media.MediaLibrary;
import com.spacekiller.util.media.library.CrateFileMediaCrate;
import com.spacekiller.util.media.library.remote.ProtocolConst;
import com.spacekiller.util.media.server.MediaClientHandler;
import com.spacekiller.util.media.server.MediaCrateHandler;
import com.spacekiller.util.media.server.MediaInputManager;
import com.spacekiller.util.media.server.MediaServerConfig;
import com.spacekiller.util.member.User;
import com.spacekiller.util.member.UserRegistry;
import com.spacekiller.util.net.AbstractServer;
import com.spacekiller.util.net.Handshake;
import com.spacekiller.util.net.ServerConfig;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MediaServer
extends AbstractServer
implements ProtocolConst {
    private static final Logger logger = Logger.getLogger(MediaServer.class.getName());
    private final MediaLibrary mediaLibrary;
    private final MediaContext mediaContext;
    private final UserRegistry userRegistry;
    private final MediaCrateHandler crateHandler;
    private final MediaInputManager inputManager;
    private int socketTimeout = 0;
    private boolean keepAlive = true;
    private boolean tcpNoDelay = true;
    private int threadPriority = 5;
    private boolean allowFileAccess;
    private boolean allowWideLinks;
    private boolean allowURIAccess;
    private Set mediaDirs;
    private Set canonicalDirs;

    public MediaServer(String serverName, MediaServerConfig serverConfig, UserRegistry userRegistry, MediaLibrary mediaLibrary, MediaContext mediaContext, CrateFileMediaCrate rootCrate) {
        super(serverName, (ServerConfig)serverConfig);
        this.userRegistry = userRegistry;
        this.mediaLibrary = mediaLibrary;
        this.mediaContext = mediaContext;
        this.allowFileAccess = serverConfig.isAllowFileAccess();
        this.allowWideLinks = serverConfig.isAllowWideLinks();
        this.allowURIAccess = serverConfig.isAllowURIAccess();
        this.mediaDirs = new HashSet();
        this.canonicalDirs = new HashSet();
        String[] mediaDirPaths = serverConfig.getMediaDirectoryPaths();
        if (mediaDirPaths != null) {
            int num = mediaDirPaths.length;
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Resolving " + num + " media directories for server: " + serverName);
            }
            for (int i = 0; i < num; ++i) {
                String mediaDirPath = mediaDirPaths[i];
                if (mediaDirPath == null || mediaDirPath.length() < 1) continue;
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Resolving media directory: " + mediaDirPath);
                }
                this.mediaDirs.add(mediaDirPath);
                try {
                    File mediaDir = new File(mediaDirPath);
                    String canonicalPath = mediaDir.getCanonicalPath();
                    if (canonicalPath.length() <= 0) continue;
                    this.canonicalDirs.add(canonicalPath);
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.fine("Media directory: " + mediaDirPath + " => " + canonicalPath);
                    continue;
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
        this.crateHandler = new MediaCrateHandler(this, rootCrate);
        this.inputManager = new MediaInputManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean handshake(Handshake handshake) throws Exception {
        Socket socket = handshake.getSocket();
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("handshake: " + socket);
        }
        String clientInfo = String.valueOf(socket.getRemoteSocketAddress());
        InputStream in = socket.getInputStream();
        DataInputStream dataIn = new DataInputStream(in);
        OutputStream out = socket.getOutputStream();
        DataOutputStream dataOut = new DataOutputStream(out);
        byte req = dataIn.readByte();
        if (req != 100) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Invalid connect request: " + req + " != " + 100);
            }
            return false;
        }
        int ver = dataIn.readInt();
        if (ver != 0) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Invalid protocol version: " + ver + " != " + 0);
            }
            return false;
        }
        String libName = dataIn.readUTF();
        logger.info("TODO: libName=" + libName);
        String userName = dataIn.readUTF();
        int pwLen = dataIn.readInt();
        if (pwLen < 0) {
            // empty if block
        }
        byte[] pw = new byte[pwLen];
        int passLen = pwLen / 2;
        char[] pass = new char[passLen];
        try {
            dataIn.readFully(pw);
            int off = 0;
            for (int i = 0; i < passLen; ++i) {
                char c = (char)((pw[off++] & 0xFF) << 4);
                pass[i] = c = (char)(c | pw[off++] & 0xFF);
            }
        }
        finally {
            Arrays.fill(pw, (byte)0);
        }
        String userPass = new String(pass);
        Arrays.fill(pass, '\u0000');
        Properties cred = new Properties();
        if (userName != null) {
            cred.setProperty("user", userName);
        }
        if (userPass != null) {
            cred.setProperty("pass", userPass);
        }
        User user = null;
        try {
            user = this.userRegistry.authenticate(cred);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        if (user == null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("handshake failed: socket=" + socket + ", userName=" + userName);
            }
            dataOut.writeByte(1);
            dataOut.flush();
            return false;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("handshake successful: socket=" + socket + ", userName=" + userName + ", user=" + user);
        }
        dataOut.writeByte(0);
        dataOut.flush();
        socket.setSoTimeout(this.socketTimeout);
        socket.setKeepAlive(this.keepAlive);
        socket.setTcpNoDelay(this.tcpNoDelay);
        String threadName = this.getName() + "-" + clientInfo;
        MediaClientHandler handler = new MediaClientHandler(this, socket, dataIn, dataOut, this.mediaLibrary, this.mediaContext, threadName, this.threadPriority, this.inputManager);
        handler.start();
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Client handler thread started for socket: " + socket);
        }
        return true;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public int getThreadPriority() {
        return this.threadPriority;
    }

    public void setThreadPriority(int threadPriority) {
        this.threadPriority = threadPriority;
    }

    protected Resource getResource(MediaClientHandler handler, String path) throws Exception {
        if (path.startsWith("file:")) {
            String filePath = path.substring(5);
            if (filePath.length() > 0) {
                File file = this.checkFileAccess(handler, filePath);
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("getResource: filePath=" + filePath + " => " + file);
                }
                if (file != null) {
                    return new FileResource(file);
                }
            }
            return null;
        }
        URI uri = this.checkURIAccess(handler, path);
        return uri == null ? null : new URIResource(uri);
    }

    protected String getMediaDir(String path) {
        int x;
        if (path == null || path.length() < 1) {
            return null;
        }
        while ((x = path.lastIndexOf(File.separatorChar)) >= 0) {
            if (!this.mediaDirs.contains(path = path.substring(0, x))) continue;
            return path;
        }
        return null;
    }

    protected String getCanonicalMediaDir(String path) {
        int x;
        if (path == null || path.length() < 1) {
            return null;
        }
        while ((x = path.lastIndexOf(File.separatorChar)) >= 0) {
            if (!this.canonicalDirs.contains(path = path.substring(0, x))) continue;
            return path;
        }
        return null;
    }

    protected File checkFileAccess(MediaClientHandler handler, String path) throws Exception {
        String canonicalDir;
        String canonicalPath;
        if (!this.allowFileAccess) {
            return null;
        }
        File file = new File(path);
        String absolutePath = file.getAbsolutePath();
        String mediaDir = this.getMediaDir(absolutePath);
        if (mediaDir == null) {
            logger.warning("Media directory not found for absolute path: " + absolutePath);
            return null;
        }
        if (!this.allowWideLinks && !(canonicalPath = file.getCanonicalPath()).equals(absolutePath) && (canonicalDir = this.getCanonicalMediaDir(canonicalPath)) == null) {
            logger.warning("Media directory not found for canonical path: " + canonicalPath);
            return null;
        }
        return file;
    }

    protected File checkDirectoryAccess(MediaClientHandler handler, String path) throws Exception {
        return this.checkFileAccess(handler, path);
    }

    protected URI checkURIAccess(MediaClientHandler handler, String path) throws Exception {
        if (!this.allowURIAccess) {
            return null;
        }
        URI uri = new URI(path);
        logger.warning("TODO checkURIAccess: " + path + " => " + uri);
        throw new UnsupportedOperationException("TODO checkURIAccess: " + path + " => " + uri);
    }

    protected MediaCrate getMediaCrate(MediaClientHandler handler, String crateId) throws Exception {
        return this.crateHandler.getMediaCrate(handler, crateId);
    }
}

