/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.server;

import com.spacekiller.util.net.AbstractServerConfig;
import java.io.Serializable;

public class MediaServerConfig
extends AbstractServerConfig
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 39469387469734L;
    private String serverName;
    private String userRegistryName;
    private String mediaCrateFilePath;
    private String[] mediaDirectoryPaths;
    private boolean allowFileAccess = true;
    private boolean allowWideLinks = false;
    private boolean allowURIAccess = false;
    private int maxStreamsPerClient = -1;

    public String toString() {
        return String.valueOf(this.serverName);
    }

    public MediaServerConfig cloneMediaServerConfig() throws CloneNotSupportedException {
        MediaServerConfig clone = (MediaServerConfig)super.cloneAbstractServerConfig();
        String[] mediaDirClones = null;
        String[] mediaDirs = this.mediaDirectoryPaths;
        if (mediaDirs != null) {
            mediaDirClones = new String[mediaDirs.length];
            System.arraycopy(mediaDirs, 0, mediaDirClones, 0, mediaDirs.length);
        }
        clone.mediaDirectoryPaths = mediaDirClones;
        return clone;
    }

    public String getUserRegistryName() {
        return this.userRegistryName;
    }

    public void setUserRegistryName(String userRegistryName) {
        this.userRegistryName = userRegistryName;
    }

    public boolean isAllowWideLinks() {
        return this.allowWideLinks;
    }

    public void setAllowWideLinks(boolean allowWideLinks) {
        this.allowWideLinks = allowWideLinks;
    }

    public String[] getMediaDirectoryPaths() {
        return this.mediaDirectoryPaths;
    }

    public void setMediaDirectoryPaths(String[] mediaDirectoryPaths) {
        this.mediaDirectoryPaths = mediaDirectoryPaths;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public int getMaxStreamsPerClient() {
        return this.maxStreamsPerClient;
    }

    public void setMaxStreamsPerClient(int maxStreamsPerClient) {
        this.maxStreamsPerClient = maxStreamsPerClient;
    }

    public boolean isAllowFileAccess() {
        return this.allowFileAccess;
    }

    public void setAllowFileAccess(boolean allowFileAccess) {
        this.allowFileAccess = allowFileAccess;
    }

    public boolean isAllowURIAccess() {
        return this.allowURIAccess;
    }

    public void setAllowURIAccess(boolean allowURIAccess) {
        this.allowURIAccess = allowURIAccess;
    }

    public String getMediaCrateFilePath() {
        return this.mediaCrateFilePath;
    }

    public void setMediaCrateFilePath(String mediaCrateFilePath) {
        this.mediaCrateFilePath = mediaCrateFilePath;
    }
}

