/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.server;

import com.spacekiller.util.media.server.MediaServerConfig;
import com.spacekiller.util.member.UserRegistryManager;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MediaServerConfigPanel
extends JPanel {
    private static final long serialVersionUID = -4065173094134445109L;
    private static final Logger logger = Logger.getLogger(MediaServerConfigPanel.class.getName());
    private UserRegistryManager userRegistryManager;
    private MediaServerConfig mediaServerConfig;
    private DefaultListModel mediaDirListModel;
    private boolean refreshing;
    private JTextField textFieldServerPort;
    private JComboBox comboBoxUserRegistry;
    private JButton btnRemoveDir;
    private JCheckBox chckbxWideLinks;
    private JButton btnAddDir;
    private JTextField textFieldServerName;
    private JList listMediaDirs;
    private JTextField textFieldCrateFile;
    private JButton btnBrowseCrateFile;

    public MediaServerConfigPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JPanel panel = new JPanel();
        GridBagConstraints gbc_panel = new GridBagConstraints();
        gbc_panel.weighty = 1.0;
        gbc_panel.weightx = 1.0;
        gbc_panel.fill = 1;
        gbc_panel.gridx = 0;
        gbc_panel.gridy = 0;
        this.add((Component)panel, gbc_panel);
        GridBagLayout gbl_panel = new GridBagLayout();
        gbl_panel.columnWidths = new int[]{0, 0, 0};
        gbl_panel.rowHeights = new int[]{0, 0, 0, 0, 0, 0, 0};
        gbl_panel.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_panel.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        panel.setLayout(gbl_panel);
        JLabel lblServerName = new JLabel("Server Name:");
        GridBagConstraints gbc_lblServerName = new GridBagConstraints();
        gbc_lblServerName.anchor = 17;
        gbc_lblServerName.insets = new Insets(0, 0, 5, 5);
        gbc_lblServerName.gridx = 0;
        gbc_lblServerName.gridy = 0;
        panel.add((Component)lblServerName, gbc_lblServerName);
        this.textFieldServerName = new JTextField();
        GridBagConstraints gbc_textFieldServerName = new GridBagConstraints();
        gbc_textFieldServerName.insets = new Insets(0, 4, 5, 0);
        gbc_textFieldServerName.fill = 2;
        gbc_textFieldServerName.gridx = 1;
        gbc_textFieldServerName.gridy = 0;
        panel.add((Component)this.textFieldServerName, gbc_textFieldServerName);
        this.textFieldServerName.setColumns(10);
        JLabel lblServerPort = new JLabel("Server Port:");
        GridBagConstraints gbc_lblServerPort = new GridBagConstraints();
        gbc_lblServerPort.anchor = 17;
        gbc_lblServerPort.insets = new Insets(4, 0, 5, 5);
        gbc_lblServerPort.gridx = 0;
        gbc_lblServerPort.gridy = 1;
        panel.add((Component)lblServerPort, gbc_lblServerPort);
        this.textFieldServerPort = new JTextField();
        GridBagConstraints gbc_textFieldServerPort = new GridBagConstraints();
        gbc_textFieldServerPort.insets = new Insets(4, 4, 5, 0);
        gbc_textFieldServerPort.fill = 2;
        gbc_textFieldServerPort.gridx = 1;
        gbc_textFieldServerPort.gridy = 1;
        panel.add((Component)this.textFieldServerPort, gbc_textFieldServerPort);
        this.textFieldServerPort.setColumns(10);
        JLabel lblUserRegistry = new JLabel("User Registry:");
        GridBagConstraints gbc_lblUserRegistry = new GridBagConstraints();
        gbc_lblUserRegistry.anchor = 17;
        gbc_lblUserRegistry.insets = new Insets(4, 0, 5, 5);
        gbc_lblUserRegistry.gridx = 0;
        gbc_lblUserRegistry.gridy = 2;
        panel.add((Component)lblUserRegistry, gbc_lblUserRegistry);
        this.comboBoxUserRegistry = new JComboBox();
        this.comboBoxUserRegistry.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!MediaServerConfigPanel.this.refreshing) {
                    MediaServerConfigPanel.this.apply();
                }
            }
        });
        GridBagConstraints gbc_comboBoxUserRegistry = new GridBagConstraints();
        gbc_comboBoxUserRegistry.insets = new Insets(4, 4, 5, 0);
        gbc_comboBoxUserRegistry.fill = 2;
        gbc_comboBoxUserRegistry.gridx = 1;
        gbc_comboBoxUserRegistry.gridy = 2;
        panel.add((Component)this.comboBoxUserRegistry, gbc_comboBoxUserRegistry);
        JLabel lblMediaCrateFile = new JLabel("Media Crate File:");
        GridBagConstraints gbc_lblMediaCrateFile = new GridBagConstraints();
        gbc_lblMediaCrateFile.anchor = 17;
        gbc_lblMediaCrateFile.insets = new Insets(4, 0, 5, 5);
        gbc_lblMediaCrateFile.gridx = 0;
        gbc_lblMediaCrateFile.gridy = 3;
        panel.add((Component)lblMediaCrateFile, gbc_lblMediaCrateFile);
        JPanel panel_2 = new JPanel();
        GridBagConstraints gbc_panel_2 = new GridBagConstraints();
        gbc_panel_2.insets = new Insets(4, 4, 5, 0);
        gbc_panel_2.fill = 1;
        gbc_panel_2.gridx = 1;
        gbc_panel_2.gridy = 3;
        panel.add((Component)panel_2, gbc_panel_2);
        GridBagLayout gbl_panel_2 = new GridBagLayout();
        gbl_panel_2.columnWidths = new int[]{0, 0, 0};
        gbl_panel_2.rowHeights = new int[]{0, 0};
        gbl_panel_2.columnWeights = new double[]{1.0, 0.0, Double.MIN_VALUE};
        gbl_panel_2.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panel_2.setLayout(gbl_panel_2);
        this.textFieldCrateFile = new JTextField();
        GridBagConstraints gbc_textFieldCrateFile = new GridBagConstraints();
        gbc_textFieldCrateFile.fill = 1;
        gbc_textFieldCrateFile.gridx = 0;
        gbc_textFieldCrateFile.gridy = 0;
        panel_2.add((Component)this.textFieldCrateFile, gbc_textFieldCrateFile);
        this.textFieldCrateFile.setColumns(10);
        this.btnBrowseCrateFile = new JButton("");
        this.btnBrowseCrateFile.setMargin(new Insets(0, 0, 0, 0));
        this.btnBrowseCrateFile.setIcon(new ImageIcon(MediaServerConfigPanel.class.getResource("/com/spacekiller/util/media/server/icons/crate-file_icon16.png")));
        this.btnBrowseCrateFile.setToolTipText("Browse media crate file...");
        this.btnBrowseCrateFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MediaServerConfigPanel.this.actionBrowseMediaCrateFile();
            }
        });
        GridBagConstraints gbc_btnBrowseCrateFile = new GridBagConstraints();
        gbc_btnBrowseCrateFile.gridx = 1;
        gbc_btnBrowseCrateFile.gridy = 0;
        panel_2.add((Component)this.btnBrowseCrateFile, gbc_btnBrowseCrateFile);
        JLabel lblMediaDirectories = new JLabel("Media Directories:");
        GridBagConstraints gbc_lblMediaDirectories = new GridBagConstraints();
        gbc_lblMediaDirectories.insets = new Insets(4, 0, 5, 5);
        gbc_lblMediaDirectories.gridx = 0;
        gbc_lblMediaDirectories.gridy = 4;
        panel.add((Component)lblMediaDirectories, gbc_lblMediaDirectories);
        this.chckbxWideLinks = new JCheckBox("Allow Wide Links");
        this.chckbxWideLinks.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!MediaServerConfigPanel.this.refreshing) {
                    MediaServerConfigPanel.this.apply();
                }
            }
        });
        this.chckbxWideLinks.setToolTipText("Allow wide symbolic links");
        GridBagConstraints gbc_chckbxWideLinks = new GridBagConstraints();
        gbc_chckbxWideLinks.anchor = 17;
        gbc_chckbxWideLinks.insets = new Insets(4, 4, 5, 0);
        gbc_chckbxWideLinks.gridx = 1;
        gbc_chckbxWideLinks.gridy = 4;
        panel.add((Component)this.chckbxWideLinks, gbc_chckbxWideLinks);
        JPanel panelMediaDirs = new JPanel();
        GridBagConstraints gbc_panelMediaDirs = new GridBagConstraints();
        gbc_panelMediaDirs.gridwidth = 2;
        gbc_panelMediaDirs.weighty = 1.0;
        gbc_panelMediaDirs.weightx = 1.0;
        gbc_panelMediaDirs.fill = 1;
        gbc_panelMediaDirs.gridx = 0;
        gbc_panelMediaDirs.gridy = 5;
        panel.add((Component)panelMediaDirs, gbc_panelMediaDirs);
        GridBagLayout gbl_panelMediaDirs = new GridBagLayout();
        gbl_panelMediaDirs.columnWidths = new int[]{0, 0};
        gbl_panelMediaDirs.rowHeights = new int[]{0, 0, 0};
        gbl_panelMediaDirs.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panelMediaDirs.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        panelMediaDirs.setLayout(gbl_panelMediaDirs);
        JScrollPane scrollPane = new JScrollPane();
        GridBagConstraints gbc_scrollPane = new GridBagConstraints();
        gbc_scrollPane.insets = new Insets(0, 0, 5, 0);
        gbc_scrollPane.weighty = 1.0;
        gbc_scrollPane.weightx = 1.0;
        gbc_scrollPane.fill = 1;
        gbc_scrollPane.gridx = 0;
        gbc_scrollPane.gridy = 0;
        panelMediaDirs.add((Component)scrollPane, gbc_scrollPane);
        this.listMediaDirs = new JList();
        this.listMediaDirs.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                MediaServerConfigPanel.this.checkEnable();
            }
        });
        this.listMediaDirs.setOpaque(false);
        scrollPane.setViewportView(this.listMediaDirs);
        JPanel panel_1 = new JPanel();
        GridBagConstraints gbc_panel_1 = new GridBagConstraints();
        gbc_panel_1.fill = 2;
        gbc_panel_1.anchor = 17;
        gbc_panel_1.gridx = 0;
        gbc_panel_1.gridy = 1;
        panelMediaDirs.add((Component)panel_1, gbc_panel_1);
        GridBagLayout gbl_panel_1 = new GridBagLayout();
        gbl_panel_1.columnWidths = new int[]{0, 0, 0};
        gbl_panel_1.rowHeights = new int[]{0, 0};
        gbl_panel_1.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_panel_1.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panel_1.setLayout(gbl_panel_1);
        this.btnAddDir = new JButton("Add");
        this.btnAddDir.setMargin(new Insets(2, 4, 2, 4));
        this.btnAddDir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MediaServerConfigPanel.this.actionAddMediaDir();
            }
        });
        GridBagConstraints gbc_btnAddDir = new GridBagConstraints();
        gbc_btnAddDir.fill = 2;
        gbc_btnAddDir.insets = new Insets(0, 0, 0, 5);
        gbc_btnAddDir.gridx = 0;
        gbc_btnAddDir.gridy = 0;
        panel_1.add((Component)this.btnAddDir, gbc_btnAddDir);
        this.btnRemoveDir = new JButton("Remove");
        this.btnRemoveDir.setMargin(new Insets(2, 4, 2, 4));
        this.btnRemoveDir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MediaServerConfigPanel.this.actionRemoveMediaDir();
            }
        });
        GridBagConstraints gbc_btnRemoveDir = new GridBagConstraints();
        gbc_btnRemoveDir.fill = 2;
        gbc_btnRemoveDir.gridx = 1;
        gbc_btnRemoveDir.gridy = 0;
        panel_1.add((Component)this.btnRemoveDir, gbc_btnRemoveDir);
        this.initMediaServerPanel();
    }

    protected void initMediaServerPanel() {
        this.mediaDirListModel = new DefaultListModel();
        this.getListMediaDirs().setModel(this.mediaDirListModel);
        DocumentListener documentHandler = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (!MediaServerConfigPanel.this.refreshing) {
                    MediaServerConfigPanel.this.apply();
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (!MediaServerConfigPanel.this.refreshing) {
                    MediaServerConfigPanel.this.apply();
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                if (!MediaServerConfigPanel.this.refreshing) {
                    MediaServerConfigPanel.this.apply();
                }
            }
        };
        this.getTextFieldServerName().getDocument().addDocumentListener(documentHandler);
        this.getTextFieldServerPort().getDocument().addDocumentListener(documentHandler);
        this.getTextFieldCrateFile().getDocument().addDocumentListener(documentHandler);
    }

    protected JTextField getTextFieldServerPort() {
        return this.textFieldServerPort;
    }

    protected JComboBox getComboBoxUserRegistry() {
        return this.comboBoxUserRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void refresh() {
        try {
            this.refreshing = true;
            String serverName = null;
            SocketAddress socketAddress = null;
            String userRegistryName = null;
            String mediaCrateFilePath = null;
            boolean allowWideLinks = false;
            String[] mediaDirectoryPaths = null;
            MediaServerConfig config = this.getMediaServerConfig();
            if (config != null) {
                serverName = config.getServerName();
                socketAddress = config.getSocketAddress();
                userRegistryName = config.getUserRegistryName();
                mediaCrateFilePath = config.getMediaCrateFilePath();
                allowWideLinks = config.isAllowWideLinks();
                mediaDirectoryPaths = config.getMediaDirectoryPaths();
            }
            if (serverName == null) {
                serverName = "";
            }
            this.getTextFieldServerName().setText(serverName);
            int serverPort = -1;
            if (socketAddress != null && socketAddress instanceof InetSocketAddress) {
                InetSocketAddress inetSocket = (InetSocketAddress)socketAddress;
                serverPort = inetSocket.getPort();
            }
            if (serverPort <= 0) {
                serverPort = 8748;
            }
            this.getTextFieldServerPort().setText(Integer.toString(serverPort));
            this.comboBoxUserRegistry.removeAllItems();
            if (userRegistryName == null) {
                userRegistryName = "default";
            }
            try {
                UserRegistryManager urm = this.getUserRegistryManager();
                if (urm != null) {
                    int selRegistry = -1;
                    String[] regNames = urm.getUserRegistryNames();
                    for (int i = 0; i < regNames.length; ++i) {
                        String regName = regNames[i];
                        if (userRegistryName.equals(regName)) {
                            selRegistry = this.comboBoxUserRegistry.getItemCount();
                        }
                        this.comboBoxUserRegistry.addItem(regName);
                    }
                    this.comboBoxUserRegistry.setSelectedIndex(selRegistry);
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            if (mediaCrateFilePath == null) {
                mediaCrateFilePath = "";
            }
            this.textFieldCrateFile.setText(mediaCrateFilePath);
            this.getChckbxWideLinks().setSelected(allowWideLinks);
            this.mediaDirListModel.removeAllElements();
            if (mediaDirectoryPaths != null) {
                int num = mediaDirectoryPaths.length;
                for (int i = 0; i < num; ++i) {
                    this.mediaDirListModel.addElement(mediaDirectoryPaths[i]);
                }
            }
            this.checkEnable();
        }
        finally {
            this.refreshing = false;
        }
    }

    protected synchronized void apply() {
        MediaServerConfig config = this.getMediaServerConfig();
        if (config == null) {
            return;
        }
        String serverName = this.getTextFieldServerName().getText();
        config.setServerName(serverName);
        try {
            int port = Integer.parseInt(this.getTextFieldServerPort().getText().trim());
            InetSocketAddress socketAddr = port < 1 ? null : new InetSocketAddress(port);
            config.setSocketAddress(socketAddr);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        String userRegistryName = null;
        Object userReg = this.getComboBoxUserRegistry().getSelectedItem();
        if (userReg != null) {
            userRegistryName = String.valueOf(userReg);
        }
        config.setUserRegistryName(userRegistryName);
        String mediaCrateFilePath = this.textFieldCrateFile.getText().trim();
        config.setMediaCrateFilePath(mediaCrateFilePath);
        config.setAllowWideLinks(this.getChckbxWideLinks().isSelected());
        int dirCount = this.mediaDirListModel.getSize();
        String[] mediaDirectoryPaths = new String[dirCount];
        for (int i = 0; i < dirCount; ++i) {
            mediaDirectoryPaths[i] = (String)this.mediaDirListModel.getElementAt(i);
        }
        config.setMediaDirectoryPaths(mediaDirectoryPaths);
    }

    public UserRegistryManager getUserRegistryManager() {
        return this.userRegistryManager;
    }

    public void setUserRegistryManager(UserRegistryManager userRegistryManager) {
        this.userRegistryManager = userRegistryManager;
        this.refresh();
    }

    public MediaServerConfig getMediaServerConfig() {
        return this.mediaServerConfig;
    }

    public void setMediaServerConfig(MediaServerConfig mediaServerConfig) {
        this.mediaServerConfig = mediaServerConfig;
        this.refresh();
    }

    protected JButton getBtnRemoveDir() {
        return this.btnRemoveDir;
    }

    protected JCheckBox getChckbxWideLinks() {
        return this.chckbxWideLinks;
    }

    protected JButton getBtnAddDir() {
        return this.btnAddDir;
    }

    protected JTextField getTextFieldServerName() {
        return this.textFieldServerName;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.checkEnable();
    }

    protected void checkEnable() {
        boolean enabled = this.isEnabled();
        MediaServerConfig config = this.getMediaServerConfig();
        this.textFieldServerName.setEnabled(enabled && config != null);
        this.textFieldServerPort.setEnabled(enabled && config != null);
        this.comboBoxUserRegistry.setEnabled(enabled && config != null);
        this.textFieldCrateFile.setEnabled(enabled && config != null);
        this.btnBrowseCrateFile.setEnabled(enabled && config != null);
        this.chckbxWideLinks.setEnabled(enabled && config != null);
        this.listMediaDirs.setEnabled(enabled && config != null);
        this.btnAddDir.setEnabled(enabled && config != null);
        this.btnRemoveDir.setEnabled(enabled && config != null && this.listMediaDirs.getSelectedIndex() >= 0);
    }

    protected JList getListMediaDirs() {
        return this.listMediaDirs;
    }

    protected void actionAddMediaDir() {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        chooser.setMultiSelectionEnabled(false);
        int rc = chooser.showOpenDialog(this);
        if (rc != 0) {
            return;
        }
        File dir = chooser.getSelectedFile();
        if (dir == null) {
            return;
        }
        String path = dir.getPath();
        if (path != null && path.length() > 0) {
            int index = this.mediaDirListModel.getSize();
            this.mediaDirListModel.addElement(path);
            this.listMediaDirs.setSelectedIndex(index);
            this.apply();
        }
    }

    protected void actionRemoveMediaDir() {
        int index = this.listMediaDirs.getSelectedIndex();
        if (index < 0) {
            return;
        }
        this.mediaDirListModel.removeElementAt(index);
        this.apply();
    }

    protected JTextField getTextFieldCrateFile() {
        return this.textFieldCrateFile;
    }

    protected JButton getBtnBrowseCrateFile() {
        return this.btnBrowseCrateFile;
    }

    protected void actionBrowseMediaCrateFile() {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(false);
        int rc = chooser.showOpenDialog(this);
        if (rc != 0) {
            return;
        }
        File file = chooser.getSelectedFile();
        if (file == null) {
            return;
        }
        this.textFieldCrateFile.setText(file.getPath());
    }
}

