/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.server;

import com.spacekiller.util.Platform;
import com.spacekiller.util.Plugin;
import com.spacekiller.util.media.server.MediaServerServiceProvider;
import com.spacekiller.util.member.UserRegistryManager;
import com.spacekiller.util.member.plugin.MemberPlugin;
import com.spacekiller.util.service.ServiceManager;
import com.spacekiller.util.service.ServiceProvider;
import com.spacekiller.util.service.plugin.ServicePlugin;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MediaServerPlugin
extends Plugin {
    private static final Logger logger = Logger.getLogger(MediaServerPlugin.class.getName());
    public static final String MEDIA_SERVER_PLUGIN_ID = "com.spacekiller.util.media.server.plugin";
    private static final String MEDIA_SERVER_SERVICES_KEY = "media-server";
    private MediaServerServiceProvider mediaServerServiceProvider;

    public static MediaServerPlugin getInstance() throws Exception {
        return (MediaServerPlugin)Platform.getInstance().getPlugin(MEDIA_SERVER_PLUGIN_ID);
    }

    protected void startup() {
        super.startup();
        try {
            ServiceManager serviceManager = this.lookupServiceManager();
            MediaServerServiceProvider sp = this.getMediaServerServiceProvider();
            if (sp != null) {
                serviceManager.registerServiceProvider((ServiceProvider)sp);
                sp.startupMediaServerServiceProvider();
            }
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected void shutdown() {
        super.shutdown();
        try {
            ServiceManager serviceManager = this.lookupServiceManager();
            MediaServerServiceProvider sp = this.mediaServerServiceProvider;
            if (sp != null) {
                serviceManager.unregisterServiceProvider((ServiceProvider)sp);
                sp.shutdownMediaServerServiceProvider();
            }
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected ServiceManager lookupServiceManager() throws Exception {
        return ServicePlugin.getInstance().getServiceManager();
    }

    protected UserRegistryManager lookupUserRegistryManager() throws Exception {
        UserRegistryManager userRegistryManager = MemberPlugin.getInstance().getUserRegistryManager();
        return userRegistryManager;
    }

    protected synchronized MediaServerServiceProvider createMediaServerServiceProvider() throws Exception {
        UserRegistryManager userRegistryManager = this.lookupUserRegistryManager();
        String preferencesKey = MEDIA_SERVER_SERVICES_KEY;
        MediaServerServiceProvider sp = new MediaServerServiceProvider(userRegistryManager, preferencesKey);
        return sp;
    }

    protected synchronized MediaServerServiceProvider getMediaServerServiceProvider() throws Exception {
        if (this.mediaServerServiceProvider == null) {
            this.setMediaServerServiceProvider(this.createMediaServerServiceProvider());
        }
        return this.mediaServerServiceProvider;
    }

    protected synchronized void setMediaServerServiceProvider(MediaServerServiceProvider mediaServerServiceProvider) {
        this.mediaServerServiceProvider = mediaServerServiceProvider;
    }
}

