/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.server;

import com.spacekiller.util.media.server.MediaServerConfig;
import com.spacekiller.util.media.server.MediaServerConfigPanel;
import com.spacekiller.util.media.server.MediaServerService;
import com.spacekiller.util.media.server.MediaServerServiceProvider;
import com.spacekiller.util.member.UserRegistryManager;
import com.spacekiller.util.service.Service;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MediaServerPreferencesPanel
extends JPanel {
    private static final long serialVersionUID = 1861671287221581800L;
    private static final Logger logger = Logger.getLogger(MediaServerPreferencesPanel.class.getName());
    private UserRegistryManager userRegistryManager;
    private MediaServerServiceProvider mediaServerServiceProvider;
    private List configList;
    private Map config2ServiceMap;
    private DefaultListModel serverListModel;
    private JButton btnRemove;
    private JList listServers;
    private MediaServerConfigPanel mediaServerConfigPanel;

    public MediaServerPreferencesPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JPanel panel = new JPanel();
        GridBagConstraints gbc_panel = new GridBagConstraints();
        gbc_panel.weighty = 1.0;
        gbc_panel.weightx = 1.0;
        gbc_panel.fill = 1;
        gbc_panel.gridx = 0;
        gbc_panel.gridy = 0;
        this.add((Component)panel, gbc_panel);
        GridBagLayout gbl_panel = new GridBagLayout();
        gbl_panel.columnWidths = new int[]{0, 0, 0};
        gbl_panel.rowHeights = new int[]{0, 0};
        gbl_panel.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_panel.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panel.setLayout(gbl_panel);
        JPanel panel_2 = new JPanel();
        panel_2.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Media Servers", 4, 2, null, new Color(51, 51, 51)));
        GridBagConstraints gbc_panel_2 = new GridBagConstraints();
        gbc_panel_2.insets = new Insets(4, 4, 4, 5);
        gbc_panel_2.fill = 1;
        gbc_panel_2.gridx = 0;
        gbc_panel_2.gridy = 0;
        panel.add((Component)panel_2, gbc_panel_2);
        GridBagLayout gbl_panel_2 = new GridBagLayout();
        gbl_panel_2.columnWidths = new int[]{0, 0};
        gbl_panel_2.rowHeights = new int[]{0, 0, 0};
        gbl_panel_2.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panel_2.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        panel_2.setLayout(gbl_panel_2);
        JScrollPane scrollPane = new JScrollPane();
        GridBagConstraints gbc_scrollPane = new GridBagConstraints();
        gbc_scrollPane.weighty = 1.0;
        gbc_scrollPane.weightx = 1.0;
        gbc_scrollPane.insets = new Insets(4, 4, 4, 4);
        gbc_scrollPane.fill = 1;
        gbc_scrollPane.gridx = 0;
        gbc_scrollPane.gridy = 0;
        panel_2.add((Component)scrollPane, gbc_scrollPane);
        this.listServers = new JList();
        this.listServers.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                MediaServerPreferencesPanel.this.handleServerSelected();
            }
        });
        this.listServers.setSelectionMode(0);
        this.listServers.setOpaque(false);
        scrollPane.setViewportView(this.listServers);
        JPanel panel_3 = new JPanel();
        GridBagConstraints gbc_panel_3 = new GridBagConstraints();
        gbc_panel_3.insets = new Insets(0, 4, 4, 4);
        gbc_panel_3.fill = 1;
        gbc_panel_3.gridx = 0;
        gbc_panel_3.gridy = 1;
        panel_2.add((Component)panel_3, gbc_panel_3);
        GridBagLayout gbl_panel_3 = new GridBagLayout();
        gbl_panel_3.columnWidths = new int[]{0, 0, 0};
        gbl_panel_3.rowHeights = new int[]{0, 0};
        gbl_panel_3.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_panel_3.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panel_3.setLayout(gbl_panel_3);
        JButton btnAdd = new JButton("Add");
        btnAdd.setMargin(new Insets(2, 4, 2, 4));
        btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MediaServerPreferencesPanel.this.actionAddServer();
            }
        });
        GridBagConstraints gbc_btnAdd = new GridBagConstraints();
        gbc_btnAdd.insets = new Insets(0, 0, 0, 5);
        gbc_btnAdd.gridx = 0;
        gbc_btnAdd.gridy = 0;
        panel_3.add((Component)btnAdd, gbc_btnAdd);
        this.btnRemove = new JButton("Remove");
        this.btnRemove.setMargin(new Insets(2, 4, 2, 4));
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MediaServerPreferencesPanel.this.actionRemoveServer();
            }
        });
        GridBagConstraints gbc_btnRemove = new GridBagConstraints();
        gbc_btnRemove.gridx = 1;
        gbc_btnRemove.gridy = 0;
        panel_3.add((Component)this.btnRemove, gbc_btnRemove);
        JPanel panel_1 = new JPanel();
        panel_1.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Media Server Configuration", 4, 2, null, null));
        GridBagConstraints gbc_panel_1 = new GridBagConstraints();
        gbc_panel_1.weighty = 1.0;
        gbc_panel_1.insets = new Insets(4, 0, 4, 4);
        gbc_panel_1.weightx = 1.0;
        gbc_panel_1.fill = 1;
        gbc_panel_1.gridx = 1;
        gbc_panel_1.gridy = 0;
        panel.add((Component)panel_1, gbc_panel_1);
        GridBagLayout gbl_panel_1 = new GridBagLayout();
        gbl_panel_1.columnWidths = new int[]{0, 0};
        gbl_panel_1.rowHeights = new int[]{0, 0};
        gbl_panel_1.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panel_1.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panel_1.setLayout(gbl_panel_1);
        this.mediaServerConfigPanel = new MediaServerConfigPanel();
        GridBagConstraints gbc_mediaServerConfigPanel = new GridBagConstraints();
        gbc_mediaServerConfigPanel.insets = new Insets(4, 4, 4, 4);
        gbc_mediaServerConfigPanel.weighty = 1.0;
        gbc_mediaServerConfigPanel.weightx = 1.0;
        gbc_mediaServerConfigPanel.fill = 1;
        gbc_mediaServerConfigPanel.gridx = 0;
        gbc_mediaServerConfigPanel.gridy = 0;
        panel_1.add((Component)this.mediaServerConfigPanel, gbc_mediaServerConfigPanel);
        this.initMediaServerPreferencesPanel();
    }

    private void initMediaServerPreferencesPanel() {
        this.configList = new ArrayList();
        this.config2ServiceMap = new HashMap();
        this.serverListModel = new DefaultListModel();
        this.getListServers().setModel(this.serverListModel);
        this.refresh();
    }

    protected JButton getBtnRemove() {
        return this.btnRemove;
    }

    protected JList getListServers() {
        return this.listServers;
    }

    protected MediaServerConfigPanel getMediaServerConfigPanel() {
        return this.mediaServerConfigPanel;
    }

    protected synchronized void refresh() {
        this.serverListModel.clear();
        int num = this.configList.size();
        for (int i = 0; i < num; ++i) {
            this.serverListModel.addElement(this.configList.get(i));
        }
        this.handleServerSelected();
    }

    protected void handleServerSelected() {
        try {
            MediaServerConfig config = null;
            Object obj = this.getListServers().getSelectedValue();
            if (obj != null && obj instanceof MediaServerConfig) {
                config = (MediaServerConfig)obj;
            }
            this.getMediaServerConfigPanel().setMediaServerConfig(config);
            this.getBtnRemove().setEnabled(config != null);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected void actionAddServer() {
        try {
            String serverName = "New Media Server";
            MediaServerConfig config = new MediaServerConfig();
            config.setServerName(serverName);
            int index = this.configList.size();
            this.configList.add(config);
            this.refresh();
            this.getListServers().setSelectedIndex(index);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected void actionRemoveServer() {
        try {
            int index = this.getListServers().getSelectedIndex();
            if (index < 0) {
                return;
            }
            MediaServerConfig config = (MediaServerConfig)this.serverListModel.getElementAt(index);
            if (config == null) {
                return;
            }
            this.configList.remove(config);
            this.refresh();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected UserRegistryManager getUserRegistryManager() {
        return this.userRegistryManager;
    }

    public void setUserRegistryManager(UserRegistryManager userRegistryManager) {
        this.userRegistryManager = userRegistryManager;
        this.getMediaServerConfigPanel().setUserRegistryManager(userRegistryManager);
    }

    protected MediaServerServiceProvider getMediaServerServiceProvider() {
        return this.mediaServerServiceProvider;
    }

    public synchronized void setMediaServerServiceProvider(MediaServerServiceProvider mediaServerServiceProvider) {
        this.mediaServerServiceProvider = mediaServerServiceProvider;
        this.configList.clear();
        this.config2ServiceMap.clear();
        if (mediaServerServiceProvider != null) {
            Iterator iter = mediaServerServiceProvider.getServices();
            while (iter.hasNext()) {
                Service service = (Service)iter.next();
                if (service == null || !(service instanceof MediaServerService)) continue;
                MediaServerService mss = (MediaServerService)service;
                try {
                    MediaServerConfig config = mediaServerServiceProvider.getMediaServerConfig(mss);
                    if (config == null) continue;
                    this.configList.add(config);
                    this.config2ServiceMap.put(config, mss);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
        this.refresh();
    }

    protected synchronized void applyMediaServerPreferences() throws Exception {
        MediaServerServiceProvider provider = this.getMediaServerServiceProvider();
        if (provider == null) {
            throw new NullPointerException("MediaServerServiceProvider");
        }
        HashSet<MediaServerService> newServices = new HashSet<MediaServerService>();
        int newCount = this.configList.size();
        for (int i = 0; i < newCount; ++i) {
            MediaServerConfig config = (MediaServerConfig)this.configList.get(i);
            MediaServerService service = (MediaServerService)((Object)this.config2ServiceMap.get(config));
            if (service == null) {
                service = provider.createMediaServerService("New Media Server #" + i);
                if (service == null) continue;
                this.config2ServiceMap.put(config, service);
            }
            provider.setMediaServerConfig(service, config);
            newServices.add(service);
        }
        for (Map.Entry me : this.config2ServiceMap.entrySet()) {
            MediaServerConfig config = (MediaServerConfig)me.getKey();
            MediaServerService service = (MediaServerService)((Object)me.getValue());
            if (config == null || service == null || newServices.contains((Object)service)) continue;
            provider.deleteMediaServerService(service);
        }
    }
}

