/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.server;

import com.spacekiller.util.media.MediaContext;
import com.spacekiller.util.media.MediaLibrary;
import com.spacekiller.util.media.library.CrateFileMediaCrate;
import com.spacekiller.util.media.server.MediaServer;
import com.spacekiller.util.media.server.MediaServerConfig;
import com.spacekiller.util.media.server.MediaServerServiceProvider;
import com.spacekiller.util.member.UserRegistry;
import com.spacekiller.util.service.AbstractService;
import java.awt.Component;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MediaServerService
extends AbstractService {
    private static final Logger logger = Logger.getLogger(MediaServerService.class.getName());
    private final MediaServerServiceProvider provider;
    private MediaServerConfig mediaServerConfig;
    private MediaServer mediaServer;

    public MediaServerService(MediaServerServiceProvider provider, String name) {
        this.provider = provider;
        this.setName(name);
        this.mediaServerConfig = new MediaServerConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        MediaServer server = null;
        MediaServerService mediaServerService = this;
        synchronized (mediaServerService) {
            int status = this.getStatus();
            if (status == 1) {
                return;
            }
            if (status != 0) {
                throw new IllegalStateException("Start/Stop is already in progress!");
            }
            MediaServerConfig serverConfig = this.getMediaServerConfig();
            if (serverConfig == null) {
                return;
            }
            String serverName = serverConfig.getServerName();
            UserRegistry userRegistry = this.provider.lookupUserRegistry(serverConfig);
            if (userRegistry == null) {
                throw new IllegalStateException("UserRegistry not available!");
            }
            MediaLibrary mediaLibrary = this.provider.lookupMediaLibrary(serverConfig);
            if (mediaLibrary == null) {
                throw new IllegalStateException("MediaLibrary not available!");
            }
            MediaContext mediaContext = mediaLibrary.getContext();
            if (mediaContext == null) {
                throw new IllegalStateException("MediaContext not available!");
            }
            String mediaCrateFilePath = serverConfig.getMediaCrateFilePath();
            if (mediaCrateFilePath == null || mediaCrateFilePath.length() < 1) {
                throw new IllegalArgumentException("Media crate file not specified!");
            }
            File rootCrateFile = new File(mediaCrateFilePath);
            String rootId = null;
            Component parentComponent = null;
            CrateFileMediaCrate rootCrate = new CrateFileMediaCrate(rootId, parentComponent, mediaLibrary, rootCrateFile);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Starting MediaServer: serverName=" + serverName + ", userRegistry=" + userRegistry + ", mediaLibrary=" + mediaLibrary);
            }
            server = new MediaServer(serverName, serverConfig, userRegistry, mediaLibrary, mediaContext, rootCrate);
            this.setStatus(2);
        }
        boolean success = false;
        try {
            if (server != null) {
                server.start();
            }
            success = true;
        }
        finally {
            MediaServerService mediaServerService2 = this;
            synchronized (mediaServerService2) {
                if (success) {
                    this.mediaServer = server;
                    this.setStatus(1);
                } else {
                    this.setStatus(0);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        MediaServer server = null;
        MediaServerService mediaServerService = this;
        synchronized (mediaServerService) {
            int status = this.getStatus();
            if (status == 0) {
                return;
            }
            if (status != 1) {
                throw new IllegalStateException("Start/Stop is already in progress!");
            }
            this.setStatus(3);
            server = this.mediaServer;
        }
        boolean success = false;
        try {
            if (server != null) {
                server.stop();
            }
            success = true;
        }
        finally {
            MediaServerService mediaServerService2 = this;
            synchronized (mediaServerService2) {
                if (success) {
                    this.setStatus(0);
                    this.mediaServer = null;
                } else {
                    this.setStatus(1);
                }
            }
        }
    }

    protected MediaServerConfig getMediaServerConfig() {
        return this.mediaServerConfig;
    }

    protected synchronized void setMediaServerConfig(MediaServerConfig mediaServerConfig) throws Exception {
        this.mediaServerConfig = mediaServerConfig;
        if (mediaServerConfig != null) {
            this.setName(mediaServerConfig.getServerName());
        }
        this.fireServiceUpdated();
    }

    protected synchronized MediaServer getMediaServer() {
        return this.mediaServer;
    }

    protected synchronized void setMediaServer(MediaServer mediaServer) {
        this.mediaServer = mediaServer;
    }
}

