/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.server;

import com.spacekiller.util.Platform;
import com.spacekiller.util.Preferences;
import com.spacekiller.util.PreferencesRegistry;
import com.spacekiller.util.media.MediaLibrary;
import com.spacekiller.util.media.manager.MediaManagerPlugin;
import com.spacekiller.util.media.server.MediaServerConfig;
import com.spacekiller.util.media.server.MediaServerService;
import com.spacekiller.util.member.UserRegistry;
import com.spacekiller.util.member.UserRegistryManager;
import com.spacekiller.util.service.AbstractServiceProvider;
import com.spacekiller.util.service.Service;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MediaServerServiceProvider
extends AbstractServiceProvider {
    private static final Logger logger = Logger.getLogger(MediaServerServiceProvider.class.getName());
    private static final String KEY_SERVICES = "services";
    private final UserRegistryManager userRegistryManager;
    private final String preferencesKey;

    public MediaServerServiceProvider(UserRegistryManager userRegistryManager, String preferencesKey) {
        this.userRegistryManager = userRegistryManager;
        this.preferencesKey = preferencesKey;
        this.initMediaServerServiceProvider();
    }

    protected final UserRegistryManager getUserRegistryManager() {
        return this.userRegistryManager;
    }

    protected void initMediaServerServiceProvider() {
        try {
            Platform plat = Platform.getInstance();
            PreferencesRegistry reg = plat.getPreferencesRegistry();
            Preferences prefs = reg.getPreferences(this.preferencesKey);
            if (prefs == null) {
                prefs = reg.createPreferences(this.preferencesKey);
            }
            ArrayList serviceNames = new ArrayList();
            Object obj = prefs.getObject(KEY_SERVICES);
            if (obj != null && obj instanceof List) {
                List list = (List)obj;
                serviceNames.addAll(list);
            }
            Iterator i = serviceNames.iterator();
            while (i.hasNext()) {
                String name = String.valueOf(i.next());
                this.loadMediaServerService(name);
            }
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected synchronized void saveMediaServerServiceProvider() throws Exception {
        Platform plat = Platform.getInstance();
        PreferencesRegistry reg = plat.getPreferencesRegistry();
        Preferences prefs = reg.getPreferences(this.preferencesKey);
        if (prefs == null) {
            prefs = reg.createPreferences(this.preferencesKey);
        }
        ArrayList<String> list = new ArrayList<String>();
        Iterator i = this.getServices();
        while (i.hasNext()) {
            String name;
            Service s = (Service)i.next();
            if (s == null || (name = s.getName()) == null || name.length() < 1) continue;
            list.add(name);
        }
        prefs.setObject(KEY_SERVICES, list);
        reg.savePreferences(prefs);
    }

    protected void startupMediaServerServiceProvider() throws Exception {
        Iterator i = this.getServices();
        while (i.hasNext()) {
            int mode;
            Service s = (Service)i.next();
            if (s == null || (mode = s.getStartupMode()) != 1) continue;
            try {
                s.start();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    protected void shutdownMediaServerServiceProvider() throws Exception {
        Iterator i = this.getServices();
        while (i.hasNext()) {
            Service s = (Service)i.next();
            if (s == null) continue;
            try {
                s.stop();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    protected MediaServerService loadMediaServerService(String name) throws Exception {
        Preferences prefs = this.getServicePreferences(name);
        if (prefs == null) {
            throw new Exception("Preferences not found for service: " + name);
        }
        MediaServerService service = new MediaServerService(this, name);
        this.loadServicePreferences((Service)service);
        this.addService((Service)service);
        return service;
    }

    protected void saveServicePreferences(Service service, Preferences prefs) throws Exception {
        MediaServerService mss = (MediaServerService)service;
        super.saveServicePreferences(service, prefs);
        MediaServerConfig config = mss.getMediaServerConfig();
        prefs.setObject("mediaServerConfig", (Object)config);
    }

    protected void loadServicePreferences(Service service, Preferences prefs) throws Exception {
        MediaServerService mss = (MediaServerService)service;
        super.loadServicePreferences(service, prefs);
        MediaServerConfig config = null;
        Object configObj = prefs.getObject("mediaServerConfig");
        if (configObj != null && configObj instanceof MediaServerConfig) {
            config = (MediaServerConfig)configObj;
        }
        mss.setMediaServerConfig(config);
    }

    public synchronized MediaServerService createMediaServerService(String name) throws Exception {
        MediaServerService service = new MediaServerService(this, name);
        service.setMediaServerConfig(new MediaServerConfig());
        this.addService((Service)service);
        this.saveMediaServerServiceProvider();
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteMediaServerService(MediaServerService service) throws Exception {
        service.stop();
        MediaServerServiceProvider mediaServerServiceProvider = this;
        synchronized (mediaServerServiceProvider) {
            this.removeService((Service)service);
            this.saveMediaServerServiceProvider();
        }
    }

    public MediaServerConfig getMediaServerConfig(MediaServerService service) throws Exception {
        MediaServerConfig config = service.getMediaServerConfig();
        if (config != null) {
            return config.cloneMediaServerConfig();
        }
        return null;
    }

    public synchronized void setMediaServerConfig(MediaServerService service, MediaServerConfig config) throws Exception {
        service.setMediaServerConfig(config);
        this.saveMediaServerServiceProvider();
    }

    protected UserRegistry lookupUserRegistry(MediaServerConfig mediaServerConfig) throws Exception {
        UserRegistry userRegistry;
        if (this.userRegistryManager == null) {
            throw new NullPointerException("userRegistryManager");
        }
        String userRegistryName = mediaServerConfig.getUserRegistryName();
        if (userRegistryName == null) {
            userRegistryName = "default";
        }
        if ((userRegistry = this.userRegistryManager.getUserRegistry(userRegistryName)) == null) {
            throw new Exception("UserRegistry not found: " + userRegistryName);
        }
        return userRegistry;
    }

    protected MediaLibrary lookupMediaLibrary(MediaServerConfig mediaServerConfig) throws Exception {
        MediaManagerPlugin mmp = MediaManagerPlugin.getInstance();
        return mmp.getMediaLibrary();
    }
}

