/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.timecode.common;

import com.waxmonster.timecode.AbstractTimecodeFormat;
import com.waxmonster.timecode.TimecodeDecoder;
import com.waxmonster.timecode.TimecodeFormat;
import com.waxmonster.timecode.common.LfsrTimecodeDefinition;
import com.waxmonster.timecode.common.TimecodeDecoderFactory;
import com.waxmonster.timecode.impl.LfsrTimecodeDecoderFactory;

public abstract class LfsrTimecodeFormat
extends AbstractTimecodeFormat {
    private final LfsrTimecodeDefinition definition;
    private TimecodeDecoderFactory factory;

    public LfsrTimecodeFormat(LfsrTimecodeDefinition definition) {
        this(definition, LfsrTimecodeFormat.getDefaultTimecodeDecoderFactory());
    }

    public LfsrTimecodeFormat(LfsrTimecodeDefinition definition, TimecodeDecoderFactory factory) {
        this.definition = definition;
        this.factory = factory;
        this.setName(definition.getName());
        this.setTitle(definition.getTitle());
    }

    protected static TimecodeDecoderFactory getDefaultTimecodeDecoderFactory() {
        return LfsrTimecodeDecoderFactory.getInstance();
    }

    public final LfsrTimecodeDefinition getDefinition() {
        return this.definition;
    }

    public TimecodeDecoderFactory getFactory() {
        return this.factory;
    }

    protected void setFactory(TimecodeDecoderFactory factory) {
        this.factory = factory;
    }

    public boolean isScratchModeSupported(int scratchMode) {
        return this.factory.isScratchModeSupported((TimecodeFormat)this, scratchMode);
    }

    public boolean isMidiDecoderSupported() {
        return false;
    }

    public boolean isAudioDecoderSupported() {
        return true;
    }

    public TimecodeDecoder createDecoder(float inputRate, int inputBufFrames, float outputRate, int outputBufFrames, double[] outputBuffer) throws IllegalArgumentException {
        return this.factory.createDecoder((TimecodeFormat)this, inputRate, inputBufFrames, outputRate, outputBufFrames, outputBuffer);
    }
}

