/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.timecode.common;

import com.waxmonster.timecode.TimecodeFormat;
import com.waxmonster.timecode.common.LfsrTimecodeDefinition;
import com.waxmonster.timecode.common.LfsrTimecodeFormat;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;

public class TimecodeFormatListCellRenderer
extends DefaultListCellRenderer {
    private static final long serialVersionUID = 7038412543547434092L;

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Component result = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        if (value != null && value instanceof TimecodeFormat) {
            LfsrTimecodeFormat lfsrFormat;
            LfsrTimecodeDefinition lfsrDef;
            TimecodeFormat format = (TimecodeFormat)value;
            String title = format.getTitle();
            if ((title == null || title.length() < 1) && (title = format.getName()) == null && (title = String.valueOf(format)) == null) {
                title = "";
            }
            this.setText(title);
            String tip = format.getTooltip();
            if (tip == null) {
                tip = title;
            }
            if (format instanceof LfsrTimecodeFormat && (lfsrDef = (lfsrFormat = (LfsrTimecodeFormat)format).getDefinition()) != null) {
                int hertz = lfsrDef.getResolution();
                int bits = lfsrDef.getBits();
                tip = tip + " (" + hertz + " Hz. ";
                tip = bits > 0 ? tip + String.valueOf(bits) + " bits" : tip + "relative";
                tip = tip + ")";
            }
            if (tip != null) {
                this.setToolTipText(tip);
            }
        }
        return result;
    }
}

