/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.timecode.impl;

import com.waxmonster.timecode.common.AbstractTimecodeDecoder;
import com.waxmonster.timecode.common.TimecodeShader;

public abstract class BaseTimecodeDecoder
extends AbstractTimecodeDecoder {
    protected volatile TimecodeShader shader;
    protected double outputRate;
    protected double normVel;
    protected final double[] arr;

    public BaseTimecodeDecoder(double outputRate, double[] outputBuffer) {
        this.outputRate = outputRate;
        this.normVel = 1000.0 / outputRate;
        this.arr = outputBuffer;
    }

    protected void prepareShader(TimecodeShader shader) {
        shader.setSampleRate(this.outputRate);
        shader.setSampleBuffer(this.arr);
    }

    public double getOutputRate() {
        return this.outputRate;
    }

    public TimecodeShader getShader() {
        return this.shader;
    }

    protected void setShader(TimecodeShader shader) {
        this.shader = shader;
    }

    protected void checkInternalVelocity(TimecodeShader internalShader) {
        double oldVel = internalShader.getVelocity();
        double oldRel = Math.abs(oldVel / this.normVel);
        if (oldRel < 0.3) {
            internalShader.setVelocity(this.normVel);
        }
    }

    public void produce(long time, int frames) {
        this.shader.produce(time, frames);
    }
}

