/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.timecode.impl;

public class Lfsr {
    private final int fwdShft;
    private final int revMask;
    private final int fwdTaps;
    private final int revTaps;

    public Lfsr(int bits, int taps) {
        if (bits < 1) {
            bits = 1;
            taps = 0;
        }
        this.fwdShft = bits - 1;
        this.fwdTaps = taps | 1;
        this.revMask = (1 << bits) - 1;
        this.revTaps = taps >> 1 | 1 << this.fwdShft;
    }

    public int fwd(int tc) {
        return tc >> 1 | Lfsr.lfsr(tc, this.fwdTaps) << this.fwdShft;
    }

    public int rev(int tc) {
        return tc << 1 & this.revMask | Lfsr.lfsr(tc, this.revTaps);
    }

    public static int lfsr(int code, int taps) {
        int xrs = 0;
        for (int taken = code & taps; taken != 0; taken >>= 1) {
            xrs += taken & 1;
        }
        return xrs & 1;
    }
}

