/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.timecode.impl;

public class LfsrChannel {
    public static final int UNKNOWN = 0;
    public static final int POSITIVE = 1;
    public static final int NEGATIVE = -1;
    public double threshold;
    public double alpha;
    public double zero;
    public double ticker;
    public boolean crossed;
    public int state;
    public double value;
    public double totalPositive;
    public double totalNegative;
    public double countPositive;
    public double countNegative;
    public double minPositive = 1000000.0;
    public double minNegative = 1000000.0;
    public double maxPositive = 0.0;
    public double maxNegative = 0.0;
    public double minZero;
    public double maxZero;

    public LfsrChannel(double threshold, double alpha) {
        this.threshold = threshold;
        this.alpha = alpha;
        this.state = 0;
    }

    public void process(double v) {
        if (v > this.zero + this.threshold && this.state != 1) {
            if (this.state == -1 && this.ticker > 0.0) {
                if (this.totalNegative > 0.0) {
                    if (this.ticker > this.maxNegative) {
                        this.maxNegative = this.ticker;
                    }
                    if (this.ticker < this.minNegative) {
                        this.minNegative = this.ticker;
                    }
                }
                this.totalNegative += this.ticker;
                this.countNegative += 1.0;
            }
            this.state = 1;
            this.crossed = true;
            this.ticker = 0.0;
        } else if (v < this.zero - this.threshold && this.state != -1) {
            if (this.state == 1 && this.ticker > 0.0) {
                if (this.totalPositive > 0.0) {
                    if (this.ticker > this.maxPositive) {
                        this.maxPositive = this.ticker;
                    }
                    if (this.ticker < this.minPositive) {
                        this.minPositive = this.ticker;
                    }
                }
                this.totalPositive += this.ticker;
                this.countPositive += 1.0;
            }
            this.state = -1;
            this.crossed = true;
            this.ticker = 0.0;
        } else {
            this.crossed = false;
            this.ticker += 1.0;
        }
        this.zero += this.alpha * (v - this.zero);
        if (this.zero < this.minZero) {
            this.minZero = this.zero;
        } else if (this.zero > this.maxZero) {
            this.maxZero = this.zero;
        }
        this.value = v;
    }

    public String toString() {
        double avgPositive = this.countPositive > 0.0 ? this.totalPositive / this.countPositive : 0.0;
        double avgNegative = this.countNegative > 0.0 ? this.totalNegative / this.countNegative : 0.0;
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString() + "[threshold=" + (double)Math.round(this.threshold * 1000.0) / 1000.0 + ", alpha=" + (double)Math.round(this.alpha * 1000.0) / 1000.0);
        sb.append(", zero=" + (double)Math.round(this.zero * 1000.0) / 1000.0 + ", ticker=" + this.ticker + ", crossed=" + this.crossed + ", state=" + this.state + ", value=" + this.value);
        sb.append(", minPositive=" + (double)Math.round(this.minPositive * 1000.0) / 1000.0);
        sb.append(", avgPositive=" + (double)Math.round(avgPositive * 1000.0) / 1000.0);
        sb.append(", maxPositive=" + (double)Math.round(this.maxPositive * 1000.0) / 1000.0);
        sb.append(", minNegative=" + (double)Math.round(this.minNegative * 1000.0) / 1000.0);
        sb.append(", avgNegative=" + (double)Math.round(avgNegative * 1000.0) / 1000.0);
        sb.append(", maxNegative=" + (double)Math.round(this.maxNegative * 1000.0) / 1000.0);
        sb.append(", minZero=" + (double)Math.round(this.minZero * 1000.0) / 1000.0);
        sb.append(", maxZero=" + (double)Math.round(this.maxZero * 1000.0) / 1000.0);
        return sb.toString();
    }
}

