/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.timecode.impl;

import com.waxmonster.timecode.common.LfsrTimecodeDefinition;
import com.waxmonster.timecode.common.TimecodeTable;
import com.waxmonster.timecode.impl.Lfsr;

public class LfsrTable
implements TimecodeTable {
    private static final int HASH_BITS = 16;
    private static final int HASH_MASK = 65535;
    private final LfsrTimecodeDefinition definition;
    private final int bits;
    private final int taps;
    private final Lfsr lfsr;
    private int[] slot;
    private int[] next;
    private int[] table;

    public LfsrTable(LfsrTimecodeDefinition definition, boolean test) throws IllegalArgumentException {
        this.definition = definition;
        this.bits = definition.getBits();
        this.taps = definition.getTaps();
        this.lfsr = new Lfsr(this.bits, this.taps);
        this.initTimecodeTable();
        if (test) {
            this.test();
        }
    }

    public final LfsrTimecodeDefinition getDefinition() {
        return this.definition;
    }

    public final Lfsr getLfsr() {
        return this.lfsr;
    }

    @Override
    public int lookup(int tc) {
        int hash = tc & 0xFFFF;
        int index = this.table[hash];
        while (index != -1) {
            if (this.slot[index] == tc) {
                return index;
            }
            index = this.next[index];
        }
        return -1;
    }

    @Override
    public int timecode(int i) {
        return this.slot[i];
    }

    @Override
    public int length() {
        return this.slot.length;
    }

    protected void initTimecodeTable() throws IllegalArgumentException {
        int i;
        int nslots = this.definition.getLength();
        int hashes = 65536;
        this.slot = new int[nslots];
        this.next = new int[nslots];
        for (i = 0; i < nslots; ++i) {
            this.slot[i] = -1;
            this.next[i] = -1;
        }
        this.table = new int[hashes];
        for (i = 0; i < hashes; ++i) {
            this.table[i] = -1;
        }
        if (this.bits < 1) {
            return;
        }
        int tc = this.definition.getSeed();
        int i2 = 0;
        while (i2 < nslots) {
            if (this.lookup(tc) != -1) {
                throw new IllegalArgumentException("Timecode has wrapped: index=" + i2 + ", code=" + tc);
            }
            int hash = tc & 0xFFFF;
            this.slot[i2] = tc;
            this.next[i2] = this.table[hash];
            this.table[hash] = i2++;
            int nc = this.lfsr.fwd(tc);
            if (this.lfsr.rev(nc) != tc) {
                throw new IllegalArgumentException("Timecode reverse failed: index=" + i2 + ", code=" + tc + ", next=" + nc);
            }
            tc = nc;
        }
    }

    public String toString() {
        return super.toString() + "[slots=" + this.slot.length + ", hashes=" + this.table.length + ", definition=" + this.definition + "]";
    }

    protected void test() throws IllegalArgumentException {
        if (this.bits < 1) {
            return;
        }
        int nslots = this.slot.length;
        int tc = this.definition.getSeed();
        for (int i = 0; i < nslots; ++i) {
            int nc;
            int index = this.lookup(tc);
            if (index != i) {
                throw new IllegalArgumentException("Timecode lookup failed: index=" + index + " != " + i + ", code=" + tc);
            }
            tc = nc = this.lfsr.fwd(tc);
        }
    }
}

