/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.timecode.impl;

import com.waxmonster.timecode.TimecodeDecoder;
import com.waxmonster.timecode.TimecodeFormat;
import com.waxmonster.timecode.common.LfsrTimecodeDefinition;
import com.waxmonster.timecode.common.LfsrTimecodeFormat;
import com.waxmonster.timecode.common.TimecodeDecoderFactory;
import com.waxmonster.timecode.common.TimecodeShader;
import com.waxmonster.timecode.impl.LfsrTablePool;
import com.waxmonster.timecode.impl.LfsrTimecodeDecoderV02;
import com.waxmonster.timecode.impl.TimecodeShaderSupport;

public class LfsrTimecodeDecoderFactory
implements TimecodeDecoderFactory {
    private static LfsrTimecodeDecoderFactory instance;
    private final LfsrTablePool lfsrTablePool;

    protected LfsrTimecodeDecoderFactory() {
        this(false);
    }

    protected LfsrTimecodeDecoderFactory(boolean test) {
        this.lfsrTablePool = new LfsrTablePool(test);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LfsrTimecodeDecoderFactory getInstance() {
        if (instance != null) return instance;
        Class<LfsrTimecodeDecoderFactory> clazz = LfsrTimecodeDecoderFactory.class;
        synchronized (LfsrTimecodeDecoderFactory.class) {
            if (instance != null) return instance;
            instance = new LfsrTimecodeDecoderFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public boolean isScratchModeSupported(TimecodeFormat format, int scratchMode) {
        if (format != null && format instanceof LfsrTimecodeFormat) {
            LfsrTimecodeFormat lfsrFormat = (LfsrTimecodeFormat)format;
            LfsrTimecodeDefinition lfsrDef = lfsrFormat.getDefinition();
            if (lfsrDef == null) {
                return false;
            }
            int bits = lfsrDef.getBits();
            if (bits < 1 && scratchMode != 0 && scratchMode != 1) {
                return false;
            }
            return LfsrTimecodeDecoderV02.isScratchModeSupported(scratchMode);
        }
        return false;
    }

    @Override
    public TimecodeDecoder createDecoder(TimecodeFormat format, float inputRate, int inputBufFrames, float outputRate, int outputBufFrames, double[] outputBuffer) {
        if (format != null && format instanceof LfsrTimecodeFormat) {
            LfsrTimecodeFormat lfsrFormat = (LfsrTimecodeFormat)format;
            int eventQueueSize = inputBufFrames * 2;
            TimecodeShader shader = TimecodeShaderSupport.getInstance().createTimecodeShader();
            shader.setEventQueueSize(eventQueueSize);
            shader.setSampleRate(outputRate);
            return new LfsrTimecodeDecoderV02(this.lfsrTablePool, lfsrFormat, inputRate, shader, outputRate, outputBuffer);
        }
        throw new IllegalArgumentException("Unsupported TimecodeFormat: " + format);
    }
}

