/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.timecode.impl;

import com.spacekiller.util.sound.SampleBuffer;
import com.waxmonster.timecode.TimecodeFormat;
import com.waxmonster.timecode.common.LfsrTimecodeDefinition;
import com.waxmonster.timecode.common.LfsrTimecodeFormat;
import com.waxmonster.timecode.common.TimecodeShader;
import com.waxmonster.timecode.impl.BaseTimecodeDecoder;
import com.waxmonster.timecode.impl.Lfsr;
import com.waxmonster.timecode.impl.LfsrChannel;
import com.waxmonster.timecode.impl.LfsrTable;
import com.waxmonster.timecode.impl.LfsrTablePool;
import com.waxmonster.timecode.impl.TimecodeShaderBase;

public class LfsrTimecodeDecoderV02
extends BaseTimecodeDecoder {
    public static final int UNKNOWN = 0;
    public static final int FORWARD = 1;
    public static final int BACKWARD = -1;
    private static final double ZERO_RC = 0.001;
    private static final int REF_PEAKS_AVG = 48;
    private static final double DEFAULT_CORRECTION_MILLIS = 250.0;
    private static final double DEFAULT_NEEDLE_SKIP_MILLIS = 160.0;
    private static final double DEFAULT_NEEDLE_MOVE_MILLIS = 10.0;
    protected double inputRate;
    protected int mode;
    protected ScratchMode sm;
    protected InternalMode internalMode;
    protected RelativeMode relativeMode;
    protected AbsoluteMode absoluteMode;
    protected SplatterMode splatterMode;
    protected UltimateMode ultimateMode;
    protected InternalShader internalShader;
    protected TimecodeShader vinylShader;
    protected final LfsrChannel left;
    protected final LfsrChannel right;
    protected final LfsrTablePool pool;
    protected boolean formatChanged;
    protected LfsrTimecodeFormat newFormat;
    protected LfsrTable newTable;
    protected LfsrTimecodeFormat format;
    protected LfsrTable table;
    protected Lfsr lfsr;
    protected int bits;
    protected int bm;
    protected int hi;
    protected LfsrChannel primary;
    protected LfsrChannel secondary;
    protected boolean switchPhase;
    protected int polarity;
    protected int direction;
    protected long directionChanges;
    protected int validCounter;
    protected int timecodeTicker;
    protected double refLevel = 1.0;
    protected int timecode;
    protected int bitstream;
    protected int abs;
    protected long validBitCount;
    protected long invalidBitCount;
    protected double pos;
    protected double millisPerTick;
    protected double millisPerBit;
    protected long npf;
    protected double correctionMillis;
    protected int correctionFrames;
    protected double needleSkipMillis;
    protected double nsp;
    protected double nsn;
    protected double needleMoveMillis;
    protected double nmp;
    protected double nmn;

    protected LfsrTimecodeDecoderV02(LfsrTablePool pool, LfsrTimecodeFormat format, float inputRate, TimecodeShader shader, float outputRate, double[] outputBuffer) {
        super(outputRate, outputBuffer);
        double zeroAlpha;
        this.pool = pool;
        this.inputRate = inputRate;
        double dt = 1.0 / (double)inputRate;
        double zeroThreshold = zeroAlpha = dt / (0.001 + dt);
        this.left = new LfsrChannel(zeroThreshold, zeroAlpha);
        this.right = new LfsrChannel(zeroThreshold, zeroAlpha);
        this.npf = (long)(1.0E9 / (double)inputRate);
        this.setNewFormat(format);
        this.applyFormat();
        this.setCorrectionMillis(250.0);
        this.setNeedleSkipMillis(160.0);
        this.setNeedleMoveMillis(10.0);
        this.vinylShader = shader;
        this.prepareShader(this.vinylShader);
        this.internalMode = new InternalMode();
        this.internalShader = new InternalShader();
        this.prepareShader(this.internalShader);
        this.internalShader.setVelocity(this.normVel);
        this.relativeMode = new RelativeMode();
        this.absoluteMode = new AbsoluteMode();
        this.splatterMode = new SplatterMode();
        this.ultimateMode = new UltimateMode();
        this.setShader(shader);
        this.mode = -1;
        this.setMode(1);
    }

    public String toString() {
        return super.toString() + "[format=" + (Object)((Object)this.format) + "]";
    }

    public static boolean isScratchModeSupported(int mode) {
        switch (mode) {
            case 0: {
                return true;
            }
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
            case 3: {
                return true;
            }
            case 4: {
                return true;
            }
        }
        return false;
    }

    public boolean isAudioDecoder() {
        return true;
    }

    public boolean isMidiDecoder() {
        return false;
    }

    public boolean isModeSupported(int mode) {
        return LfsrTimecodeDecoderV02.isScratchModeSupported(mode);
    }

    public int getMode() {
        return this.mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMode(int mode) {
        if (!this.isModeSupported(mode)) {
            return;
        }
        LfsrTimecodeDecoderV02 lfsrTimecodeDecoderV02 = this;
        synchronized (lfsrTimecodeDecoderV02) {
            TimecodeShader newShader;
            ScratchMode newMode;
            if (this.mode == mode) {
                return;
            }
            this.mode = mode;
            switch (mode) {
                case 1: {
                    newMode = this.relativeMode;
                    newShader = this.vinylShader;
                    break;
                }
                case 2: {
                    this.absoluteMode.reset();
                    newMode = this.absoluteMode;
                    newShader = this.vinylShader;
                    break;
                }
                case 3: {
                    this.splatterMode.reset();
                    newMode = this.splatterMode;
                    newShader = this.vinylShader;
                    break;
                }
                case 4: {
                    this.ultimateMode.reset();
                    newMode = this.ultimateMode;
                    newShader = this.vinylShader;
                    break;
                }
                default: {
                    newMode = this.internalMode;
                    newShader = this.internalShader;
                }
            }
            TimecodeShader oldShader = this.shader;
            if (newShader != oldShader && oldShader != null) {
                double oldPos = oldShader.getPosition();
                double oldVel = oldShader.getVelocity();
                newShader.setPosition(oldPos);
                newShader.setVelocity(oldVel);
            }
            if (newShader == this.internalShader) {
                this.checkInternalVelocity(newShader);
            }
            this.sm = newMode;
            this.setShader(newShader);
        }
    }

    public TimecodeFormat getFormat() {
        return this.format;
    }

    public LfsrTimecodeFormat getNewFormat() {
        return this.newFormat;
    }

    public void setNewFormat(LfsrTimecodeFormat format) throws IllegalArgumentException {
        LfsrTable tab;
        if (format == this.newFormat) {
            return;
        }
        this.newTable = tab = this.pool.getLfsrTable(format.getDefinition());
        this.newFormat = format;
        this.formatChanged = true;
    }

    protected void applyFormat() {
        LfsrTimecodeFormat form = this.newFormat;
        LfsrTable tab = this.newTable;
        LfsrTimecodeDefinition def = form.getDefinition();
        this.table = tab;
        this.lfsr = tab.getLfsr();
        this.bits = def.getBits();
        this.bm = this.bits < 1 ? 0 : (1 << this.bits) - 1;
        int n = this.hi = this.bits < 1 ? 0 : 1 << this.bits - 1;
        if (def.isSwitchPrimary()) {
            this.primary = this.left;
            this.secondary = this.right;
        } else {
            this.primary = this.right;
            this.secondary = this.left;
        }
        this.polarity = def.isSwitchPolarity() ? -1 : 1;
        this.switchPhase = def.isSwitchPhase();
        this.validCounter = 0;
        this.millisPerBit = 1000.0 / (double)def.getResolution();
        this.millisPerTick = 1000.0 / (double)def.getResolution() / 4.0;
        this.format = form;
    }

    public void handle(long time, int status, int data1, int data2) {
        throw new UnsupportedOperationException("MIDI timecode not supported: " + this);
    }

    public void decode(long time, double[] buf, int off, int len) {
        if (this.formatChanged) {
            this.formatChanged = false;
            this.applyFormat();
        }
        int end = off + len;
        while (off < end) {
            this.sm.process(time, buf[off++], buf[off++]);
            time += this.npf;
        }
    }

    public void decode(long time, SampleBuffer buf, int off, int len) {
        if (this.formatChanged) {
            this.formatChanged = false;
            this.applyFormat();
        }
        int end = off + len;
        while (off < end) {
            this.sm.process(time, buf.getDouble(off++), buf.getDouble(off++));
            time += this.npf;
        }
    }

    protected void bit(double b) {
        this.refLevel -= this.refLevel / 48.0;
        this.refLevel += b / 48.0;
        this.timecodeTicker = 0;
        switch (this.direction) {
            case 1: {
                this.bitstream >>= 1;
                if (b > this.refLevel) {
                    this.bitstream |= this.hi;
                }
                this.timecode = this.lfsr.fwd(this.timecode);
                if (this.timecode != this.bitstream) break;
                ++this.validCounter;
                ++this.validBitCount;
                return;
            }
            case -1: {
                this.bitstream <<= 1;
                this.bitstream &= this.bm;
                if (b > this.refLevel) {
                    this.bitstream |= 1;
                }
                this.timecode = this.lfsr.rev(this.timecode);
                if (this.timecode != this.bitstream) break;
                ++this.validCounter;
                ++this.validBitCount;
                return;
            }
        }
        this.timecode = this.bitstream;
        this.validCounter = 0;
        ++this.invalidBitCount;
    }

    public void close() {
        this.newFormat = null;
        this.newTable = null;
        this.format = null;
        this.table = null;
        this.lfsr = null;
        this.bits = -1;
    }

    public double getPosition() {
        return this.pos;
    }

    protected void setPosition(double pos) {
        this.pos = pos;
    }

    public double getCorrectionMillis() {
        return this.correctionMillis;
    }

    public void setCorrectionMillis(double correctionMillis) {
        this.correctionMillis = correctionMillis;
        long numFrames = (long)(correctionMillis * this.inputRate / 1000.0);
        if (numFrames < 1L) {
            numFrames = 1L;
        } else if (numFrames > Integer.MAX_VALUE) {
            numFrames = Integer.MAX_VALUE;
        }
        this.correctionFrames = (int)numFrames;
    }

    public double getNeedleSkipMillis() {
        return this.needleSkipMillis;
    }

    public void setNeedleSkipMillis(double needleSkipMillis) {
        if (needleSkipMillis < 1.0) {
            throw new IllegalArgumentException("Invalid needleSkipMillis: " + needleSkipMillis);
        }
        this.needleSkipMillis = needleSkipMillis;
        this.nsp = needleSkipMillis;
        this.nsn = -needleSkipMillis;
    }

    public double getNeedleMoveMillis() {
        return this.needleMoveMillis;
    }

    public void setNeedleMoveMillis(double needleMoveMillis) {
        if (needleMoveMillis < 1.0) {
            throw new IllegalArgumentException("Invalid needleMoveMillis: " + needleMoveMillis);
        }
        this.needleMoveMillis = needleMoveMillis;
        this.nmp = needleMoveMillis;
        this.nmn = -needleMoveMillis;
    }

    protected class UltimateMode
    extends SplatterMode {
        protected double vr;
        protected double hr;

        public UltimateMode() {
            this.reset();
        }

        @Override
        protected void skip(long time, double d) {
            System.out.println("ultimate skip: d=" + d);
            double a = d % this.vr;
            if (d > 0.0) {
                long r = (long)(d / this.vr);
                if (a > this.hr) {
                    a -= this.vr;
                    --r;
                }
                this.del -= (double)r * this.vr;
            } else {
                long r = (long)(-d / this.vr);
                if (a < -this.hr) {
                    a += this.vr;
                    --r;
                }
                this.del += (double)r * this.vr;
            }
            super.skip(time, a);
        }

        @Override
        protected void reset() {
            super.reset();
            this.vr = LfsrTimecodeDecoderV02.this.rotationMillis;
            this.hr = this.vr / 2.0;
        }
    }

    protected class SplatterMode
    extends AbsoluteMode {
        protected double del;

        public SplatterMode() {
            this.reset();
        }

        @Override
        protected void move(long time, double p) {
            if (this.del != this.del) {
                this.del = LfsrTimecodeDecoderV02.this.pos - p;
            } else {
                super.move(time, p + this.del);
            }
        }

        @Override
        protected void reset() {
            super.reset();
            this.del = Double.NaN;
        }
    }

    protected class AbsoluteMode
    extends RelativeMode {
        protected int rcn;
        protected double rcv;

        public AbsoluteMode() {
            this.reset();
        }

        @Override
        public void process(long time, double x, double y) {
            super.process(time, x, y);
            if (LfsrTimecodeDecoderV02.this.secondary.crossed && LfsrTimecodeDecoderV02.this.primary.state == LfsrTimecodeDecoderV02.this.polarity) {
                LfsrTimecodeDecoderV02.this.bit(Math.abs(LfsrTimecodeDecoderV02.this.primary.value - LfsrTimecodeDecoderV02.this.primary.zero));
                if (LfsrTimecodeDecoderV02.this.timecodeTicker == 0 && LfsrTimecodeDecoderV02.this.validCounter >= LfsrTimecodeDecoderV02.this.bits) {
                    int k = LfsrTimecodeDecoderV02.this.table.lookup(LfsrTimecodeDecoderV02.this.timecode);
                    if (k != -1) {
                        switch (LfsrTimecodeDecoderV02.this.direction) {
                            case 1: {
                                if (k != LfsrTimecodeDecoderV02.this.abs + 1) break;
                                this.move(time, (double)k * LfsrTimecodeDecoderV02.this.millisPerBit);
                                break;
                            }
                            case -1: {
                                if (k != LfsrTimecodeDecoderV02.this.abs - 1) break;
                                this.move(time, (double)k * LfsrTimecodeDecoderV02.this.millisPerBit);
                            }
                        }
                        LfsrTimecodeDecoderV02.this.abs = k;
                    } else {
                        LfsrTimecodeDecoderV02.this.abs = -1;
                    }
                } else {
                    LfsrTimecodeDecoderV02.this.abs = -1;
                }
            }
            ++LfsrTimecodeDecoderV02.this.timecodeTicker;
            if (this.rcn > 0) {
                LfsrTimecodeDecoderV02.this.pos += this.rcv;
                --this.rcn;
            }
        }

        protected void move(long time, double p) {
            double d = p - LfsrTimecodeDecoderV02.this.pos;
            if (d > LfsrTimecodeDecoderV02.this.nsp || d < LfsrTimecodeDecoderV02.this.nsn) {
                this.skip(time, d);
                return;
            }
            if (d > LfsrTimecodeDecoderV02.this.nmp || d < LfsrTimecodeDecoderV02.this.nmn || this.rcn > 0) {
                if (d > 1.0 || d < -1.0) {
                    this.rcn = LfsrTimecodeDecoderV02.this.correctionFrames;
                    this.rcv = d / (double)this.rcn;
                } else {
                    this.rcn = 0;
                }
            }
        }

        protected void skip(long time, double d) {
            System.out.println("absolute skip: d=" + d);
            LfsrTimecodeDecoderV02.this.pos += d;
            this.rcn = 0;
            LfsrTimecodeDecoderV02.this.shader.move(time, Double.NaN);
        }

        protected void reset() {
            this.rcn = 0;
        }
    }

    protected class RelativeMode
    implements ScratchMode {
        @Override
        public void process(long time, double x, double y) {
            LfsrTimecodeDecoderV02.this.left.process(x);
            LfsrTimecodeDecoderV02.this.right.process(y);
            if (LfsrTimecodeDecoderV02.this.primary.crossed) {
                int dir;
                int n = dir = LfsrTimecodeDecoderV02.this.primary.state == LfsrTimecodeDecoderV02.this.secondary.state ^ LfsrTimecodeDecoderV02.this.switchPhase ? -1 : 1;
                if (dir != LfsrTimecodeDecoderV02.this.direction) {
                    if (LfsrTimecodeDecoderV02.this.direction != 0) {
                        ++LfsrTimecodeDecoderV02.this.directionChanges;
                    }
                    LfsrTimecodeDecoderV02.this.direction = dir;
                }
            } else if (LfsrTimecodeDecoderV02.this.secondary.crossed) {
                int dir;
                int n = dir = LfsrTimecodeDecoderV02.this.primary.state == LfsrTimecodeDecoderV02.this.secondary.state ^ LfsrTimecodeDecoderV02.this.switchPhase ? 1 : -1;
                if (dir != LfsrTimecodeDecoderV02.this.direction) {
                    if (LfsrTimecodeDecoderV02.this.direction != 0) {
                        ++LfsrTimecodeDecoderV02.this.directionChanges;
                    }
                    LfsrTimecodeDecoderV02.this.direction = dir;
                }
            }
            if (LfsrTimecodeDecoderV02.this.primary.crossed || LfsrTimecodeDecoderV02.this.secondary.crossed) {
                switch (LfsrTimecodeDecoderV02.this.direction) {
                    case 1: {
                        LfsrTimecodeDecoderV02.this.pos += LfsrTimecodeDecoderV02.this.millisPerTick;
                        LfsrTimecodeDecoderV02.this.shader.move(time, LfsrTimecodeDecoderV02.this.pos);
                        break;
                    }
                    case -1: {
                        LfsrTimecodeDecoderV02.this.pos -= LfsrTimecodeDecoderV02.this.millisPerTick;
                        LfsrTimecodeDecoderV02.this.shader.move(time, LfsrTimecodeDecoderV02.this.pos);
                    }
                }
            }
        }
    }

    protected class InternalShader
    extends TimecodeShaderBase {
        protected double vel;

        @Override
        public void produce(long time, int frames) {
            for (int i = 0; i < frames; ++i) {
                this.buf[i] = LfsrTimecodeDecoderV02.this.pos;
                LfsrTimecodeDecoderV02.this.pos += this.vel;
            }
        }

        @Override
        public double getPosition() {
            return LfsrTimecodeDecoderV02.this.pos;
        }

        @Override
        public void setPosition(double pos) {
            LfsrTimecodeDecoderV02.this.setPosition(pos);
        }

        @Override
        public double getVelocity() {
            return this.vel;
        }

        @Override
        public void setVelocity(double vel) {
            this.vel = vel;
        }
    }

    protected class InternalMode
    implements ScratchMode {
        @Override
        public void process(long time, double x, double y) {
        }
    }

    protected static interface ScratchMode {
        public void process(long var1, double var3, double var5);
    }
}

