/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.timecode.impl;

import com.waxmonster.timecode.common.TimecodeShader;

public abstract class TimecodeShaderBase
implements TimecodeShader {
    protected double sampleRate;
    protected double nps;
    protected double[] buf;
    protected int queueSize;
    protected long[] evt;
    protected double[] evp;
    protected volatile int tail;

    @Override
    public double getSampleRate() {
        return this.sampleRate;
    }

    @Override
    public void setSampleRate(double sampleRate) {
        if (sampleRate < 1.0) {
            throw new IllegalArgumentException("Invalid sample rate: " + sampleRate);
        }
        this.sampleRate = sampleRate;
        this.nps = 1.0E9 / sampleRate;
    }

    @Override
    public double[] getSampleBuffer() {
        return this.buf;
    }

    @Override
    public void setSampleBuffer(double[] buf) {
        this.buf = buf;
    }

    @Override
    public int getEventQueueSize() {
        return this.queueSize;
    }

    @Override
    public void setEventQueueSize(int eventQueueSize) {
        if (eventQueueSize < 1) {
            throw new IllegalArgumentException("Invalid event queue size: " + eventQueueSize);
        }
        this.queueSize = eventQueueSize;
        this.evt = new long[eventQueueSize];
        this.evp = new double[eventQueueSize];
    }

    @Override
    public void move(long time, double pos) {
        int idx = this.tail;
        this.evt[idx] = time;
        this.evp[idx] = pos;
        this.tail = (idx + 1) % this.queueSize;
    }
}

