/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.timecode.impl;

import com.waxmonster.timecode.impl.TimecodeShaderBase;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TimecodeShaderV07
extends TimecodeShaderBase {
    private static final Logger logger = Logger.getLogger(TimecodeShaderV07.class.getName());
    protected int idx;
    protected long rt;
    protected double rp;
    protected double rv;
    protected double sp;
    protected double fcm;
    protected double fcs;
    protected double pos;
    protected double vel;
    protected double sdt;
    protected boolean sdi;
    protected double sdm;
    protected double sds;
    protected double sda;
    protected boolean skip;
    protected double mul;
    protected double div;

    public TimecodeShaderV07() {
        this.setSmoothnessFactor(7.0);
        this.setForecastMillis(20.0);
        this.setSlowdownThreshold(4.0E7);
        this.setSlowdownMillis(2.0);
    }

    public double getSmoothnessFactor() {
        return this.mul;
    }

    public void setSmoothnessFactor(double factor) {
        if (factor < 1.0) {
            throw new IllegalArgumentException("Invalid smoothness factor: " + factor);
        }
        this.mul = factor;
        this.div = this.mul + 1.0;
    }

    public double getForecastMillis() {
        return this.fcm;
    }

    public void setForecastMillis(double ms) {
        if (ms < 1.0) {
            throw new IllegalArgumentException("Invalid forecast millis: " + ms);
        }
        this.fcm = ms;
        this.computeForecastSamples();
    }

    public double getSlowdownThreshold() {
        return this.sdt;
    }

    public void setSlowdownThreshold(double nanos) {
        this.sdt = nanos;
    }

    public double getSlowdownMillis() {
        return this.sdm;
    }

    public void setSlowdownMillis(double ms) {
        if (ms < 1.0) {
            throw new IllegalArgumentException("Invalid slowdown millis: " + ms);
        }
        this.sdm = ms;
        this.computeSlowdownSamples();
    }

    @Override
    public void setSampleRate(double sampleRate) {
        super.setSampleRate(sampleRate);
        this.computeForecastSamples();
        this.computeSlowdownSamples();
    }

    protected void computeForecastSamples() {
        this.fcs = this.fcm * this.sampleRate / 1000.0;
    }

    protected void computeSlowdownSamples() {
        this.sds = this.sdm * this.sampleRate / 1000.0;
    }

    @Override
    public double getPosition() {
        return this.pos;
    }

    @Override
    public void setPosition(double pos) {
        this.pos = pos;
    }

    @Override
    public double getVelocity() {
        return this.vel;
    }

    @Override
    public void setVelocity(double vel) {
        this.vel = vel;
    }

    @Override
    public void produce(long time, int frames) {
        double ep;
        long et;
        int tail = this.tail;
        if (this.idx == tail) {
            et = Long.MAX_VALUE;
            ep = 0.0;
        } else {
            et = this.evt[this.idx];
            ep = this.evp[this.idx];
        }
        long st = time;
        for (int i = 0; i < frames; ++i) {
            double dv;
            double dp;
            this.buf[i] = this.pos;
            if (st < et) {
                if (this.rv != 0.0 && (this.sdi || (double)(st - this.rt) > this.sdt)) {
                    if (!this.sdi) {
                        this.sdi = true;
                        this.sda = -this.rv / this.sds;
                    }
                    this.rv += this.sda;
                    if (this.sda < 0.0 == this.rv < 0.0) {
                        this.sdi = false;
                        this.rv = this.sda > 0.0 ? -0.0 : 0.0;
                    }
                }
                dp = this.sp + this.fcs * this.rv - (this.pos + this.fcs * this.vel);
                dv = dp / this.fcs;
                this.vel += dv / this.fcs;
                this.pos += this.vel;
                this.sp += this.rv;
            } else {
                long nt;
                this.idx = (this.idx + 1) % this.queueSize;
                while (this.idx != tail && ep == ep && st >= (nt = this.evt[this.idx])) {
                    et = nt;
                    ep = this.evp[this.idx];
                    this.idx = (this.idx + 1) % this.queueSize;
                }
                if (ep != ep) {
                    System.out.println("shader skip: et=" + et);
                    this.skip = true;
                    this.pos += this.vel;
                    if (this.idx == tail) {
                        et = Long.MAX_VALUE;
                        continue;
                    }
                    et = this.evt[this.idx];
                    ep = this.evp[this.idx];
                    continue;
                }
                if (this.skip) {
                    this.skip = false;
                    System.out.println("shader skipping: et=" + et + ", ep=" + ep);
                    this.pos = ep;
                } else {
                    dp = ep - this.rp;
                    long dt = et - this.rt;
                    dv = dp * 1000000.0 / (double)dt;
                    if (dv > 5.0 || dv < -5.0) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("FIXME: dp=" + dp + ", dt=" + dt + ", dv=" + dv);
                        }
                    } else {
                        this.rv = (this.rv * this.mul + dp * this.nps / (double)dt) / this.div;
                    }
                    this.pos += this.vel;
                }
                this.sp = ep;
                this.rt = et;
                this.rp = ep;
                if (this.idx == tail) {
                    et = Long.MAX_VALUE;
                } else {
                    et = this.evt[this.idx];
                    ep = this.evp[this.idx];
                }
            }
            st = (long)((double)st + this.nps);
        }
    }
}

