/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.service.plugin;

import com.spacekiller.util.Tools;
import com.spacekiller.util.service.Service;
import com.spacekiller.util.service.ServiceAdapter;
import com.spacekiller.util.service.ServiceListener;
import com.spacekiller.util.service.ServiceManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class ServicesPanel
extends JPanel {
    private static final long serialVersionUID = 1516878457571864618L;
    private static final String MODE_MANUAL = "Manual";
    private static final String MODE_AUTO = "Automatic";
    private static final String MODE_DISABLED = "Disabled";
    private ServiceManager serviceManager;
    private ServiceHandler serviceHandler = new ServiceHandler();
    private Refresher refresher = new Refresher();
    private Icon iconStarted;
    private Icon iconStarting;
    private Icon iconStopped;
    private Icon iconStopping;
    private List services;
    private Service configService;
    private JToolBar jToolBar = null;
    private JButton jButtonRefresh = null;
    private JButton jButtonStart = null;
    private JButton jButtonStop = null;
    private JPanel jPanel = null;
    private JButton jButtonRestart = null;
    private JPanel jPanel1 = null;
    private JScrollPane jScrollPane = null;
    private JTable jTable = null;
    private JButton jButtonConfig = null;
    private JPanel jPanel2 = null;
    private JDialog jDialogConfig = null;
    private JPanel jContentPane = null;
    private JLabel jLabel = null;
    private JTextField jTextFieldServiceName = null;
    private JLabel jLabel1 = null;
    private JLabel jLabel2 = null;
    private JComboBox jComboBoxStartupMode = null;
    private JPanel jPanel3 = null;
    private JPanel jPanel4 = null;
    private JButton jButtonConfigSave = null;
    private JButton jButtonConfigCancel = null;
    private JTextField jTextFieldDescr = null;
    private static final Logger logger = Logger.getLogger(ServicesPanel.class.getName());

    public ServicesPanel() {
        this.initialize();
        this.initServicesPanel();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.weighty = 1.0;
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.gridy = 1;
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.gridx = 0;
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(400, 215));
        this.add((Component)this.getJToolBar(), gridBagConstraints1);
        this.add((Component)this.getJPanel1(), gridBagConstraints3);
    }

    protected ServiceManager getServiceManager() {
        return this.serviceManager;
    }

    protected synchronized void setServiceManager(ServiceManager newServiceManager) {
        if (this.serviceManager == newServiceManager) {
            return;
        }
        if (this.serviceManager != null) {
            this.serviceManager.removeServiceListener((ServiceListener)this.serviceHandler);
        }
        this.serviceManager = newServiceManager;
        if (this.serviceManager != null) {
            this.serviceManager.addServiceListener((ServiceListener)this.serviceHandler);
        }
        this.refresh();
    }

    private JToolBar getJToolBar() {
        if (this.jToolBar == null) {
            this.jToolBar = new JToolBar();
            this.jToolBar.setFloatable(false);
            this.jToolBar.setOpaque(false);
            this.jToolBar.add(this.getJButtonRefresh());
            this.jToolBar.add(this.getJPanel2());
            this.jToolBar.add(this.getJButtonConfig());
            this.jToolBar.add(this.getJPanel());
            this.jToolBar.add(this.getJButtonStart());
            this.jToolBar.add(this.getJButtonRestart());
            this.jToolBar.add(this.getJButtonStop());
        }
        return this.jToolBar;
    }

    private JButton getJButtonRefresh() {
        if (this.jButtonRefresh == null) {
            this.jButtonRefresh = new JButton();
            this.jButtonRefresh.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/service/plugin/icons/refresh_nav.gif")));
            this.jButtonRefresh.setToolTipText("Refresh");
            this.jButtonRefresh.setMargin(new Insets(2, 2, 2, 2));
            this.jButtonRefresh.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ServicesPanel.this.refresh();
                }
            });
        }
        return this.jButtonRefresh;
    }

    private JButton getJButtonStart() {
        if (this.jButtonStart == null) {
            this.jButtonStart = new JButton();
            this.jButtonStart.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/service/plugin/icons/run_exc.gif")));
            this.jButtonStart.setToolTipText("Start service");
            this.jButtonStart.setMargin(new Insets(2, 2, 2, 2));
            this.jButtonStart.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ServicesPanel.this.actionStart();
                }
            });
        }
        return this.jButtonStart;
    }

    private JButton getJButtonStop() {
        if (this.jButtonStop == null) {
            this.jButtonStop = new JButton();
            this.jButtonStop.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/service/plugin/icons/stop_task.gif")));
            this.jButtonStop.setToolTipText("Stop service");
            this.jButtonStop.setMargin(new Insets(2, 2, 2, 2));
            this.jButtonStop.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ServicesPanel.this.actionStop();
                }
            });
        }
        return this.jButtonStop;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setOpaque(false);
            this.jPanel.setPreferredSize(new Dimension(8, 8));
            this.jPanel.setMaximumSize(new Dimension(8, 8));
            this.jPanel.setMinimumSize(new Dimension(8, 8));
        }
        return this.jPanel;
    }

    private JButton getJButtonRestart() {
        if (this.jButtonRestart == null) {
            this.jButtonRestart = new JButton();
            this.jButtonRestart.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/service/plugin/icons/refresh_ui.gif")));
            this.jButtonRestart.setToolTipText("Restart service");
            this.jButtonRestart.setMargin(new Insets(2, 2, 2, 2));
            this.jButtonRestart.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ServicesPanel.this.actionRestart();
                }
            });
        }
        return this.jButtonRestart;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.gridx = 0;
            this.jPanel1 = new JPanel();
            this.jPanel1.setLayout(new GridBagLayout());
            this.jPanel1.add((Component)this.getJScrollPane(), gridBagConstraints2);
        }
        return this.jPanel1;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJTable());
        }
        return this.jScrollPane;
    }

    private JTable getJTable() {
        if (this.jTable == null) {
            this.jTable = new JTable();
        }
        return this.jTable;
    }

    public synchronized void refresh() {
        Service sel = this.getSelectedService();
        int selIndex = -1;
        ServicesTableModel model = new ServicesTableModel();
        model.addColumn("name");
        model.addColumn("status");
        model.addColumn("startup");
        model.addColumn("descr");
        ArrayList<Service> list = new ArrayList<Service>();
        if (this.serviceManager != null) {
            int n = this.serviceManager.getServiceCount();
            for (int i = 0; i < n; ++i) {
                Service s = this.serviceManager.getServiceAt(i);
                if (s == null) continue;
                list.add(s);
                String name = String.valueOf(s.getName());
                String status = this.getStatusString(s.getStatus());
                String startupMode = this.getStartupModeString(s.getStartupMode());
                String descr = String.valueOf(s.getDescription());
                Object[] row = new Object[]{name, status, startupMode, descr};
                model.addRow(row);
                if (s != sel) continue;
                selIndex = i;
            }
        }
        this.services = list;
        this.getJTable().setModel(model);
        if (selIndex >= 0) {
            this.getJTable().getSelectionModel().setSelectionInterval(selIndex, selIndex);
        }
        this.checkEnable();
    }

    protected void actionStart() {
        final Service service = this.getSelectedService();
        if (service == null) {
            return;
        }
        Runnable run = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    service.start();
                }
                catch (Throwable e) {
                    ServicesPanel.this.handleException(e);
                }
                finally {
                    ServicesPanel.this.refresh();
                }
            }
        };
        new Thread(run).start();
    }

    protected void actionRestart() {
        final Service service = this.getSelectedService();
        if (service == null) {
            return;
        }
        Runnable run = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    service.restart();
                }
                catch (Throwable e) {
                    ServicesPanel.this.handleException(e);
                }
                finally {
                    ServicesPanel.this.refresh();
                }
            }
        };
        new Thread(run).start();
    }

    protected void actionStop() {
        final Service service = this.getSelectedService();
        if (service == null) {
            return;
        }
        Runnable run = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    service.stop();
                }
                catch (Throwable e) {
                    ServicesPanel.this.handleException(e);
                }
                finally {
                    ServicesPanel.this.refresh();
                }
            }
        };
        new Thread(run).start();
    }

    protected Service getSelectedService() {
        Service service = null;
        int row = this.getJTable().getSelectedRow();
        if (row >= 0 && row < this.services.size()) {
            service = (Service)this.services.get(row);
        }
        return service;
    }

    protected void initServicesPanel() {
        FontMetrics fm;
        this.services = new ArrayList();
        DefaultTableColumnModel cm = new DefaultTableColumnModel();
        ServicesTableCellRenderer renderer = new ServicesTableCellRenderer();
        TableColumn col = new TableColumn(0);
        col.setHeaderValue("Service");
        col.setPreferredWidth(200);
        col.setCellRenderer(renderer);
        cm.addColumn(col);
        col = new TableColumn(1);
        col.setHeaderValue("Status");
        col.setPreferredWidth(70);
        col.setMinWidth(70);
        col.setCellRenderer(renderer);
        cm.addColumn(col);
        col = new TableColumn(2);
        col.setHeaderValue("Startup");
        col.setPreferredWidth(70);
        col.setMinWidth(70);
        col.setCellRenderer(renderer);
        cm.addColumn(col);
        col = new TableColumn(3);
        col.setHeaderValue("Description");
        col.setPreferredWidth(300);
        col.setCellRenderer(renderer);
        cm.addColumn(col);
        this.getJTable().setAutoResizeMode(0);
        this.getJTable().setAutoCreateColumnsFromModel(false);
        this.getJTable().setColumnModel(cm);
        this.getJTable().getSelectionModel().setSelectionMode(0);
        this.getJTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ServicesPanel.this.checkEnable();
            }
        });
        this.getJTable().setRowSelectionAllowed(true);
        this.getJTable().setColumnSelectionAllowed(false);
        Font font = renderer.getFont();
        if (font != null && (fm = this.getFontMetrics(font)) != null) {
            int rowHeight = fm.getHeight() + this.getJTable().getRowMargin();
            this.getJTable().setRowHeight(rowHeight);
        }
        try {
            this.iconStarted = new ImageIcon(this.getClass().getResource("/com/spacekiller/util/service/plugin/icons/green-ball.gif"));
            this.iconStarting = new ImageIcon(this.getClass().getResource("/com/spacekiller/util/service/plugin/icons/green-ball.gif"));
            this.iconStopped = new ImageIcon(this.getClass().getResource("/com/spacekiller/util/service/plugin/icons/gray-ball.gif"));
            this.iconStopping = new ImageIcon(this.getClass().getResource("/com/spacekiller/util/service/plugin/icons/red-ball.gif"));
        }
        catch (Exception e) {
            this.handleException(e);
        }
        this.refresh();
        this.getJComboBoxStartupMode().addItem(MODE_MANUAL);
        this.getJComboBoxStartupMode().addItem(MODE_AUTO);
        this.getJComboBoxStartupMode().addItem(MODE_DISABLED);
    }

    protected String getStatusString(int status) {
        switch (status) {
            case 1: {
                return "started";
            }
            case 2: {
                return "starting...";
            }
            case 0: {
                return "stopped";
            }
            case 3: {
                return "stopping...";
            }
        }
        return "" + status;
    }

    protected String getStartupModeString(int mode) {
        switch (mode) {
            case 1: {
                return "automatic";
            }
            case 0: {
                return "manual";
            }
            case -1: {
                return "disabled";
            }
        }
        return "" + mode;
    }

    protected void checkEnable() {
        boolean enableConfig = false;
        boolean enableStart = false;
        boolean enableRestart = false;
        boolean enableStop = false;
        Service s = this.getSelectedService();
        if (s != null) {
            enableConfig = true;
            int status = s.getStatus();
            switch (status) {
                case 1: {
                    enableRestart = true;
                    enableStop = true;
                    break;
                }
                case 0: {
                    enableStart = true;
                }
            }
        }
        this.getJButtonConfig().setEnabled(enableConfig);
        this.getJButtonStart().setEnabled(enableStart);
        this.getJButtonRestart().setEnabled(enableRestart);
        this.getJButtonStop().setEnabled(enableStop);
    }

    protected void handleException(Throwable e) {
        logger.log(Level.SEVERE, e.getMessage(), e);
    }

    private JButton getJButtonConfig() {
        if (this.jButtonConfig == null) {
            this.jButtonConfig = new JButton();
            this.jButtonConfig.setToolTipText("Service configuration...");
            this.jButtonConfig.setMargin(new Insets(2, 2, 2, 2));
            this.jButtonConfig.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/service/plugin/icons/preferences_view.gif")));
            this.jButtonConfig.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ServicesPanel.this.actionConfig();
                }
            });
        }
        return this.jButtonConfig;
    }

    private JPanel getJPanel2() {
        if (this.jPanel2 == null) {
            this.jPanel2 = new JPanel();
            this.jPanel2.setMaximumSize(new Dimension(8, 8));
            this.jPanel2.setOpaque(false);
            this.jPanel2.setPreferredSize(new Dimension(8, 8));
            this.jPanel2.setMinimumSize(new Dimension(8, 8));
        }
        return this.jPanel2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void actionConfig() {
        Service srv = this.getSelectedService();
        if (srv == null) {
            return;
        }
        try {
            this.configService = srv;
            this.getJTextFieldServiceName().setText("" + srv.getName());
            this.getJTextFieldDescr().setText("" + srv.getDescription());
            String mode = MODE_MANUAL;
            int startMode = srv.getStartupMode();
            switch (startMode) {
                case 0: {
                    mode = MODE_MANUAL;
                    break;
                }
                case 1: {
                    mode = MODE_AUTO;
                    break;
                }
                case -1: {
                    mode = MODE_DISABLED;
                }
            }
            this.getJComboBoxStartupMode().setSelectedItem(mode);
            JDialog dialog = this.getJDialogConfig();
            dialog.setModal(true);
            dialog.pack();
            Tools.centerWindow((Component)this, (Window)dialog);
            dialog.setVisible(true);
        }
        finally {
            this.configService = null;
        }
    }

    protected void actionConfigSave() {
        Service srv = this.configService;
        if (srv == null) {
            return;
        }
        int startupMode = 0;
        Object mode = this.getJComboBoxStartupMode().getSelectedItem();
        if (mode == MODE_MANUAL) {
            startupMode = 0;
        }
        if (mode == MODE_AUTO) {
            startupMode = 1;
        }
        if (mode == MODE_DISABLED) {
            startupMode = -1;
        }
        if (srv.getStartupMode() != startupMode) {
            srv.setStartupMode(startupMode);
        }
        this.refresh();
    }

    private JDialog getJDialogConfig() {
        if (this.jDialogConfig == null) {
            this.jDialogConfig = new JDialog();
            this.jDialogConfig.setSize(new Dimension(365, 284));
            this.jDialogConfig.setContentPane(this.getJPanel3());
            this.jDialogConfig.setTitle("Service Configuration");
        }
        return this.jDialogConfig;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.fill = 2;
            gridBagConstraints11.gridy = 1;
            gridBagConstraints11.weightx = 1.0;
            gridBagConstraints11.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints11.gridx = 1;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.fill = 2;
            gridBagConstraints7.gridy = 2;
            gridBagConstraints7.weightx = 1.0;
            gridBagConstraints7.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints7.gridx = 1;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints6.anchor = 17;
            gridBagConstraints6.gridy = 1;
            this.jLabel2 = new JLabel();
            this.jLabel2.setText("Description:");
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints5.anchor = 17;
            gridBagConstraints5.gridy = 2;
            this.jLabel1 = new JLabel();
            this.jLabel1.setText("Startup mode:");
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.gridy = 0;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints4.gridx = 1;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridy = 0;
            this.jLabel = new JLabel();
            this.jLabel.setText("Service name:");
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.jLabel, gridBagConstraints);
            this.jContentPane.add((Component)this.getJTextFieldServiceName(), gridBagConstraints4);
            this.jContentPane.add((Component)this.jLabel1, gridBagConstraints5);
            this.jContentPane.add((Component)this.jLabel2, gridBagConstraints6);
            this.jContentPane.add((Component)this.getJComboBoxStartupMode(), gridBagConstraints7);
            this.jContentPane.add((Component)this.getJTextFieldDescr(), gridBagConstraints11);
        }
        return this.jContentPane;
    }

    private JTextField getJTextFieldServiceName() {
        if (this.jTextFieldServiceName == null) {
            this.jTextFieldServiceName = new JTextField();
            this.jTextFieldServiceName.setEditable(false);
            this.jTextFieldServiceName.setOpaque(false);
        }
        return this.jTextFieldServiceName;
    }

    private JComboBox getJComboBoxStartupMode() {
        if (this.jComboBoxStartupMode == null) {
            this.jComboBoxStartupMode = new JComboBox();
        }
        return this.jComboBoxStartupMode;
    }

    private JPanel getJPanel3() {
        if (this.jPanel3 == null) {
            GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
            gridBagConstraints14.gridx = 0;
            gridBagConstraints14.anchor = 13;
            gridBagConstraints14.gridy = 1;
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 0;
            gridBagConstraints8.weightx = 1.0;
            gridBagConstraints8.weighty = 1.0;
            gridBagConstraints8.fill = 1;
            gridBagConstraints8.gridy = 0;
            this.jPanel3 = new JPanel();
            this.jPanel3.setLayout(new GridBagLayout());
            this.jPanel3.add((Component)this.getJContentPane(), gridBagConstraints8);
            this.jPanel3.add((Component)this.getJPanel4(), gridBagConstraints14);
        }
        return this.jPanel3;
    }

    private JPanel getJPanel4() {
        if (this.jPanel4 == null) {
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.gridx = 1;
            gridBagConstraints10.gridy = 0;
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.gridx = 0;
            gridBagConstraints9.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints9.gridy = 0;
            this.jPanel4 = new JPanel();
            this.jPanel4.setLayout(new GridBagLayout());
            this.jPanel4.add((Component)this.getJButtonConfigSave(), gridBagConstraints9);
            this.jPanel4.add((Component)this.getJButtonConfigCancel(), gridBagConstraints10);
        }
        return this.jPanel4;
    }

    private JButton getJButtonConfigSave() {
        if (this.jButtonConfigSave == null) {
            this.jButtonConfigSave = new JButton();
            this.jButtonConfigSave.setText("Save");
            this.jButtonConfigSave.setMargin(new Insets(2, 4, 2, 4));
            this.jButtonConfigSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ServicesPanel.this.actionConfigSave();
                    ServicesPanel.this.getJDialogConfig().dispose();
                }
            });
        }
        return this.jButtonConfigSave;
    }

    private JButton getJButtonConfigCancel() {
        if (this.jButtonConfigCancel == null) {
            this.jButtonConfigCancel = new JButton();
            this.jButtonConfigCancel.setMargin(new Insets(2, 4, 2, 4));
            this.jButtonConfigCancel.setText("Cancel");
            this.jButtonConfigCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ServicesPanel.this.getJDialogConfig().dispose();
                }
            });
        }
        return this.jButtonConfigCancel;
    }

    private JTextField getJTextFieldDescr() {
        if (this.jTextFieldDescr == null) {
            this.jTextFieldDescr = new JTextField();
            this.jTextFieldDescr.setOpaque(false);
            this.jTextFieldDescr.setEditable(false);
        }
        return this.jTextFieldDescr;
    }

    protected class ServicesTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -7356502754147202115L;

        protected ServicesTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            String text = this.getText();
            Icon icon = null;
            if (column == 0) {
                icon = ServicesPanel.this.iconStopped;
                try {
                    Service s = (Service)ServicesPanel.this.services.get(row);
                    if (s != null) {
                        text = String.valueOf(s.getName());
                        int status = s.getStatus();
                        switch (status) {
                            case 1: {
                                icon = ServicesPanel.this.iconStarted;
                                break;
                            }
                            case 2: {
                                icon = ServicesPanel.this.iconStarting;
                                break;
                            }
                            case 0: {
                                icon = ServicesPanel.this.iconStopped;
                                break;
                            }
                            case 3: {
                                icon = ServicesPanel.this.iconStopping;
                            }
                        }
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            this.setText(text);
            this.setIcon(icon);
            return comp;
        }
    }

    public static class ServicesTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = -1786139380255801859L;

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }

    protected class ServiceHandler
    extends ServiceAdapter {
        protected ServiceHandler() {
        }

        public void serviceAdded(Service service) {
            SwingUtilities.invokeLater(ServicesPanel.this.refresher);
        }

        public void serviceRemoved(Service service) {
            SwingUtilities.invokeLater(ServicesPanel.this.refresher);
        }

        public void serviceStarted(Service service) {
            SwingUtilities.invokeLater(ServicesPanel.this.refresher);
        }

        public void serviceStarting(Service service) {
            SwingUtilities.invokeLater(ServicesPanel.this.refresher);
        }

        public void serviceStopped(Service service) {
            SwingUtilities.invokeLater(ServicesPanel.this.refresher);
        }

        public void serviceStopping(Service service) {
            SwingUtilities.invokeLater(ServicesPanel.this.refresher);
        }

        public void serviceUpdated(Service service) {
            SwingUtilities.invokeLater(ServicesPanel.this.refresher);
        }
    }

    protected class Refresher
    implements Runnable {
        protected Refresher() {
        }

        @Override
        public void run() {
            ServicesPanel.this.refresh();
        }
    }
}

