/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.midi.impl;

import com.waxmonster.midi.MidiContext;
import com.waxmonster.midi.MidiEngine;
import com.waxmonster.midi.MidiException;
import com.waxmonster.midi.MidiInputPort;
import com.waxmonster.midi.MidiOutputPort;
import com.waxmonster.midi.MidiProcessor;
import com.waxmonster.midi.MidiSyncGroup;
import com.waxmonster.midi.impl.MidiContextImpl;
import com.waxmonster.midi.impl.MidiEngineConfig;
import com.waxmonster.midi.impl.MidiEngineException;
import com.waxmonster.midi.impl.MidiProcessorProxy;
import com.waxmonster.midi.impl.Wrapper;
import com.waxmonster.midi.impl.WrapperInputPort;
import com.waxmonster.midi.impl.WrapperOutputPort;
import com.waxmonster.studio.Studio;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractMidiEngine
implements MidiEngine {
    private static final Logger logger = Logger.getLogger(AbstractMidiEngine.class.getName());
    protected final MidiEngineConfig config;

    public AbstractMidiEngine(MidiEngineConfig config) {
        this.config = config;
    }

    protected MidiContextImpl getMidiContextImpl(MidiContext context) {
        if (context != null && context instanceof MidiContextImpl) {
            return (MidiContextImpl)context;
        }
        throw new IllegalArgumentException("Invalid MidiContext: " + context);
    }

    protected MidiContextImpl createMidiContextImpl(Studio studio) {
        return new MidiContextImpl(studio, this);
    }

    protected Wrapper[] prepareMidiSyncGroup(MidiSyncGroup engineGroup, MidiContextImpl context) throws MidiException {
        Wrapper wrapper;
        int i;
        MidiEngine engine = engineGroup.getMidiEngine();
        if (engine != this) {
            throw new MidiException("Invalid MidiSyncGroup: group=" + engineGroup + ", engine=" + engine + " != " + this);
        }
        Wrapper engineWrapper = context.getGroupWrapper(engineGroup);
        if (engineWrapper.isPrepared()) {
            throw new MidiException("MidiSyncGroup is already prepared: " + engineGroup);
        }
        this.resolveWrapperRecursive(engineWrapper, context);
        Wrapper[] wrappers = context.getGroupWrappers();
        for (i = 0; i < wrappers.length; ++i) {
            MidiSyncGroup wrapperGroup;
            MidiEngine wrapperGroupEngine;
            wrapper = wrappers[i];
            MidiEngine wrapperEngine = wrapper.getMidiEngine();
            if (wrapperEngine == null || (wrapperGroupEngine = (wrapperGroup = wrapper.getGroup()).getMidiEngine()) != null && wrapperGroupEngine != this || wrapper.isPrepared()) continue;
            int outputCount = wrapper.getOutputPortCount();
            MidiProcessor[] targets = new MidiProcessor[outputCount];
            for (int k = 0; k < outputCount; ++k) {
                WrapperOutputPort outputPort = wrapper.getOutputPortAt(k);
                MidiOutputPort midiOutPort = outputPort.getMidiOutputPort();
                MidiProcessorProxy proxy = new MidiProcessorProxy(midiOutPort);
                targets[k] = proxy;
                outputPort.setOutputProxy(proxy);
            }
            wrapperGroup.setTargetMidiProcessors(targets);
            int inputCount = wrapper.getInputPortCount();
            for (int k = 0; k < inputCount; ++k) {
                WrapperInputPort inputPort = wrapper.getInputPortAt(k);
                MidiInputPort midiInPort = inputPort.getMidiInputPort();
                MidiProcessor proc = wrapperGroup.createMidiProcessor(midiInPort);
                inputPort.setInputProcessor(proc);
            }
            wrapper.setPrepared(true);
        }
        for (i = 0; i < wrappers.length; ++i) {
            MidiEngine groupEngine;
            MidiSyncGroup asg;
            wrapper = wrappers[i];
            if (wrapper.isPrepared() || (asg = wrapper.getGroup()) == engineGroup || (groupEngine = asg.getMidiEngine()) == this || groupEngine == null) continue;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Preparing MidiSyncGroup: group=" + asg + ", engine=" + groupEngine);
            }
            groupEngine.prepare(asg, (MidiContext)context);
            if (!wrapper.isPrepared()) {
                throw new MidiEngineException(wrapper, "Failed to prepare MidiEngine: group=" + asg + ", engine=" + groupEngine);
            }
            if (!logger.isLoggable(Level.FINE)) continue;
            logger.fine("MidiSyncGroup prepared: group=" + asg + ", engine=" + groupEngine);
        }
        if (context.getOwnerEngine() == this) {
            context.dumpMidiContext();
        }
        return wrappers;
    }

    protected void startMidiEngines(MidiContextImpl context) throws MidiException {
        Wrapper wrapper;
        int i;
        Wrapper[] wrappers = context.getGroupWrappers();
        for (i = 0; i < wrappers.length; ++i) {
            wrapper = wrappers[i];
            int outputCount = wrapper.getOutputPortCount();
            for (int k = 0; k < outputCount; ++k) {
                WrapperOutputPort outputPort = wrapper.getOutputPortAt(k);
                WrapperInputPort[] targetPorts = outputPort.getTargetPorts();
                LinkedList<MidiProcessor> targets = new LinkedList<MidiProcessor>();
                for (int j = 0; j < targetPorts.length; ++j) {
                    WrapperInputPort targetPort = targetPorts[j];
                    MidiProcessor targetProc = targetPort.getInputProcessor();
                    if (targetProc == null) continue;
                    targets.add(targetProc);
                }
                MidiProcessorProxy proxy = outputPort.getOutputProxy();
                proxy.setTargets(targets.toArray(new MidiProcessor[targets.size()]));
            }
        }
        for (i = 0; i < wrappers.length; ++i) {
            MidiSyncGroup asg;
            MidiEngine groupEngine;
            wrapper = wrappers[i];
            if (wrapper.isStarted() || (groupEngine = (asg = wrapper.getGroup()).getMidiEngine()) == this || groupEngine == null) continue;
            if (!wrapper.isPrepared()) {
                throw new MidiException("MidiSyncGroup is not prepared: " + asg);
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Starting MIDI engine: " + groupEngine);
            }
            try {
                groupEngine.start();
                if (!wrapper.isStarted()) {
                    throw new MidiException("Failed to start engine: group=" + asg + ", engine=" + groupEngine);
                }
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.fine("MIDI engine started: " + groupEngine);
                continue;
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                if (!(groupEngine instanceof AbstractMidiEngine)) continue;
                AbstractMidiEngine ame = (AbstractMidiEngine)groupEngine;
                try {
                    ame.handleEngineError(e);
                    continue;
                }
                catch (Throwable x) {
                    logger.log(Level.SEVERE, x.getMessage(), x);
                }
            }
        }
    }

    protected void shutdownMidiProcessors(MidiContextImpl context) throws MidiException {
        if (context == null) {
            return;
        }
        LinkedList<MidiProcessor> procList = new LinkedList<MidiProcessor>();
        HashSet<MidiProcessor> procSet = new HashSet<MidiProcessor>();
        Wrapper[] wrappers = context.getGroupWrappers();
        for (int i = 0; i < wrappers.length; ++i) {
            Wrapper wrapper = wrappers[i];
            MidiEngine engine = wrapper.getMidiEngine();
            if (engine != this) continue;
            int inputCount = wrapper.getInputPortCount();
            for (int k = 0; k < inputCount; ++k) {
                WrapperInputPort inputPort = wrapper.getInputPortAt(k);
                MidiProcessor inputProc = inputPort.getInputProcessor();
                if (inputProc == null) continue;
                if (procSet.add(inputProc)) {
                    procList.add(inputProc);
                }
                inputPort.setInputProcessor(null);
            }
        }
        for (MidiProcessor midiProc : procList) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("shutdownMidiProcessor: " + midiProc);
            }
            try {
                midiProc.shutdown();
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    private final void resolveWrapperRecursive(Wrapper wrapper, MidiContextImpl context) throws MidiException {
        MidiSyncGroup group = wrapper.getGroup();
        MidiEngine engine = wrapper.getMidiEngine();
        if (engine == null) {
            throw new MidiException("No MIDI engine available for group: " + group);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("resolveWrapperRecursive: wrapper=" + wrapper + ", engine=" + engine);
        }
        HashSet<MidiSyncGroup> doneGroups = new HashSet<MidiSyncGroup>();
        doneGroups.add(group);
        this.resolveResponsibleEngineRecursive(wrapper, context, engine, doneGroups);
    }

    private final void resolveResponsibleEngineRecursive(Wrapper wrapper, MidiContextImpl context, MidiEngine possibleEngine, Set doneGroups) throws MidiException {
        MidiSyncGroup group = wrapper.getGroup();
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("resolveResponsibleEngineRecursive: group=" + group + ", engine=" + wrapper.getMidiEngine() + ", possibleEngine=" + possibleEngine);
        }
        int connectedInputs = 0;
        int inputCount = wrapper.getInputPortCount();
        for (int i = 0; i < inputCount; ++i) {
            WrapperInputPort inputPort = wrapper.getInputPortAt(i);
            WrapperOutputPort sourcePort = inputPort.getSourcePort();
            if (sourcePort == null) continue;
            ++connectedInputs;
            Wrapper sourceWrapper = sourcePort.getWrapper();
            MidiSyncGroup sourceGroup = sourceWrapper.getGroup();
            if (sourceGroup == group || !doneGroups.add(sourceGroup)) continue;
            this.resolveResponsibleEngineRecursive(sourceWrapper, context, possibleEngine, doneGroups);
        }
        MidiEngine engine = wrapper.getMidiEngine();
        if (engine == null) {
            engine = possibleEngine;
        }
        int outputCount = wrapper.getOutputPortCount();
        for (int i = 0; i < outputCount; ++i) {
            WrapperOutputPort outputPort = wrapper.getOutputPortAt(i);
            WrapperInputPort[] targetPorts = outputPort.getTargetPorts();
            for (int k = 0; k < targetPorts.length; ++k) {
                WrapperInputPort targetPort = targetPorts[k];
                Wrapper targetWrapper = targetPort.getWrapper();
                MidiSyncGroup targetGroup = targetWrapper.getGroup();
                MidiEngine targetEngine = targetWrapper.getMidiEngine();
                if (targetEngine == null) {
                    targetWrapper.setMidiEngine(engine);
                    targetEngine = engine;
                }
                if (!doneGroups.add(targetGroup)) continue;
                this.resolveResponsibleEngineRecursive(targetWrapper, context, targetEngine, doneGroups);
            }
        }
        if (wrapper.getMidiEngine() == null && connectedInputs < 1) {
            wrapper.setMidiEngine(possibleEngine);
        }
    }

    protected void handleEngineError(Throwable error) {
    }
}

