/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.midi.impl;

import com.waxmonster.midi.MidiContext;
import com.waxmonster.midi.MidiInputPort;
import com.waxmonster.midi.MidiOutputPort;
import com.waxmonster.midi.MidiPort;
import com.waxmonster.midi.MidiProcessor;
import com.waxmonster.midi.MidiSupport;
import com.waxmonster.midi.MidiSyncGroup;
import com.waxmonster.midi.impl.AbstractMidiEngine;
import com.waxmonster.midi.impl.MidiProcessorProxy;
import com.waxmonster.midi.impl.Wrapper;
import com.waxmonster.midi.impl.WrapperInputPort;
import com.waxmonster.midi.impl.WrapperOutputPort;
import com.waxmonster.studio.Connection;
import com.waxmonster.studio.Device;
import com.waxmonster.studio.Port;
import com.waxmonster.studio.Studio;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MidiContextImpl
implements MidiContext {
    private static final Logger logger = Logger.getLogger(MidiContextImpl.class.getName());
    private final Studio studio;
    private final AbstractMidiEngine ownerEngine;
    private Map wrapperMap;
    private List wrapperList;

    public MidiContextImpl(Studio studio, AbstractMidiEngine ownerEngine) {
        this.studio = studio;
        this.ownerEngine = ownerEngine;
        this.wrapperMap = new HashMap();
        this.wrapperList = new LinkedList();
    }

    public String toString() {
        return super.toString() + "[studio=" + this.studio + ", ownerEngine=" + this.ownerEngine + "]";
    }

    public final Studio getStudio() {
        return this.studio;
    }

    public final AbstractMidiEngine getOwnerEngine() {
        return this.ownerEngine;
    }

    public void dumpMidiContext() {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("MIDI context: " + this);
            if (logger.isLoggable(Level.FINE)) {
                Wrapper[] wrappers = this.getGroupWrappers();
                logger.fine("MidiSyncGroup(s): " + wrappers.length);
                for (int i = 0; i < wrappers.length; ++i) {
                    Wrapper wrapper = wrappers[i];
                    logger.fine(" - MidiSyncGroup #" + i + ": group=" + wrapper.getGroup() + ", engine=" + wrapper.getMidiEngine());
                    if (!logger.isLoggable(Level.FINER)) continue;
                    int inputCount = wrapper.getInputPortCount();
                    for (int k = 0; k < inputCount; ++k) {
                        WrapperInputPort port = wrapper.getInputPortAt(k);
                        MidiProcessor proc = port.getInputProcessor();
                        logger.finer("   - Input #" + k + ": processor=" + proc + ", port=" + port.getMidiInputPort());
                    }
                    int outputCount = wrapper.getOutputPortCount();
                    for (int k = 0; k < outputCount; ++k) {
                        WrapperOutputPort port = wrapper.getOutputPortAt(k);
                        MidiProcessorProxy proxy = port.getOutputProxy();
                        logger.finer("   - Output #" + k + ": port=" + port.getMidiOutputPort() + ", proxy=" + proxy);
                    }
                }
            }
        }
    }

    public synchronized Wrapper getGroupWrapper(MidiSyncGroup group) {
        int i;
        Wrapper wrapper = (Wrapper)this.wrapperMap.get(group);
        if (wrapper != null) {
            return wrapper;
        }
        MidiSyncGroup[] groups = this.getMidiSyncGroupsRecursive(group);
        Wrapper[] wrappers = new Wrapper[groups.length];
        for (i = 0; i < groups.length; ++i) {
            MidiSyncGroup asg = groups[i];
            Wrapper sgw = (Wrapper)this.wrapperMap.get(asg);
            if (sgw == null) {
                sgw = new Wrapper(asg);
                this.wrapperMap.put(asg, sgw);
                this.wrapperList.add(sgw);
            }
            wrappers[i] = sgw;
        }
        for (i = 0; i < wrappers.length; ++i) {
            Wrapper sgw = wrappers[i];
            int inputCount = sgw.getInputPortCount();
            for (int k = 0; k < inputCount; ++k) {
                Wrapper sourceWrapper;
                MidiSyncGroup sourceGroup;
                WrapperInputPort inputPort = sgw.getInputPortAt(k);
                MidiInputPort midiInputPort = inputPort.getMidiInputPort();
                MidiOutputPort sourceMidiPort = midiInputPort.getSourcePort();
                if (sourceMidiPort == null || (sourceGroup = this.getMidiSyncGroup((MidiPort)sourceMidiPort)) == null || (sourceWrapper = (Wrapper)this.wrapperMap.get(sourceGroup)) == null) continue;
                WrapperOutputPort sourcePort = sourceWrapper.getOutputPort(sourceMidiPort);
                inputPort.setSourcePort(sourcePort);
            }
            int outputCount = sgw.getOutputPortCount();
            for (int k = 0; k < outputCount; ++k) {
                WrapperOutputPort outputPort = sgw.getOutputPortAt(k);
                MidiOutputPort midiOutputPort = outputPort.getMidiOutputPort();
                MidiInputPort[] targetMidiPorts = this.getTargetMidiInputPorts(midiOutputPort);
                ArrayList<WrapperInputPort> targetPortList = new ArrayList<WrapperInputPort>();
                for (int p = 0; p < targetMidiPorts.length; ++p) {
                    WrapperInputPort targetPort;
                    Wrapper destWrapper;
                    MidiInputPort destPort = targetMidiPorts[p];
                    MidiSyncGroup destGroup = this.getMidiSyncGroup((MidiPort)destPort);
                    if (destGroup == null || (destWrapper = (Wrapper)this.wrapperMap.get(destGroup)) == null || (targetPort = destWrapper.getInputPort(destPort)) == null) continue;
                    targetPortList.add(targetPort);
                }
                WrapperInputPort[] targetPortArray = targetPortList.toArray(new WrapperInputPort[targetPortList.size()]);
                outputPort.setTargetPorts(targetPortArray);
            }
        }
        return (Wrapper)this.wrapperMap.get(group);
    }

    public synchronized Wrapper[] getGroupWrappers() {
        return this.wrapperList.toArray(new Wrapper[this.wrapperList.size()]);
    }

    private final MidiSyncGroup getMidiSyncGroup(MidiPort midiPort) {
        Device device = midiPort.getDevice();
        if (device == null) {
            return null;
        }
        if (!device.isEnabled()) {
            return null;
        }
        MidiSupport support = midiPort.getMidiSupport();
        if (support == null) {
            return null;
        }
        return support.getMidiSyncGroup(midiPort);
    }

    private final MidiInputPort[] getTargetMidiInputPorts(MidiOutputPort port) {
        LinkedList<MidiInputPort> targetPorts = new LinkedList<MidiInputPort>();
        Connection[] conns = port.getConnections();
        for (int k = 0; k < conns.length; ++k) {
            Port partner = conns[k].getPartner((Port)port);
            if (partner == null || !(partner instanceof MidiInputPort)) continue;
            MidiInputPort destPort = (MidiInputPort)partner;
            targetPorts.add(destPort);
        }
        return targetPorts.toArray(new MidiInputPort[targetPorts.size()]);
    }

    private final MidiSyncGroup[] getMidiSyncGroupsRecursive(MidiSyncGroup group) {
        HashSet<MidiSyncGroup> groupSet = new HashSet<MidiSyncGroup>();
        groupSet.add(group);
        LinkedList<MidiSyncGroup> groupList = new LinkedList<MidiSyncGroup>();
        groupList.add(group);
        int groupIndex = 0;
        this.getMidiSyncGroupsRecursive(group, groupSet, groupList, groupIndex);
        return groupList.toArray(new MidiSyncGroup[groupList.size()]);
    }

    private final int getMidiSyncGroupsRecursive(MidiSyncGroup group, Set groupSet, List groupList, int groupIndex) {
        int insertCount = 0;
        int inputCount = group.getInputPortCount();
        for (int i = 0; i < inputCount; ++i) {
            MidiSyncGroup sourceGroup;
            MidiOutputPort sourcePort;
            Device dev;
            MidiInputPort port = group.getInputPortAt(i);
            if (port == null || (dev = port.getDevice()) == null || !dev.isEnabled() || (sourcePort = port.getSourcePort()) == null || (sourceGroup = this.getMidiSyncGroup((MidiPort)sourcePort)) == null || !groupSet.add(sourceGroup)) continue;
            groupList.add(groupIndex, sourceGroup);
            int added = 1 + this.getMidiSyncGroupsRecursive(sourceGroup, groupSet, groupList, groupIndex);
            insertCount += added;
            groupIndex += added;
        }
        int insertIndex = groupIndex + 1;
        int outputCount = group.getOutputPortCount();
        for (int i = 0; i < outputCount; ++i) {
            Device dev;
            MidiOutputPort port = group.getOutputPortAt(i);
            if (port == null || (dev = port.getDevice()) == null || !dev.isEnabled()) continue;
            MidiInputPort[] targetPorts = this.getTargetMidiInputPorts(port);
            for (int k = 0; k < targetPorts.length; ++k) {
                MidiInputPort destPort = targetPorts[k];
                MidiSyncGroup destGroup = this.getMidiSyncGroup((MidiPort)destPort);
                if (destGroup == null || !groupSet.add(destGroup)) continue;
                groupList.add(insertIndex, destGroup);
                int added = 1 + this.getMidiSyncGroupsRecursive(destGroup, groupSet, groupList, insertIndex);
                insertCount += added;
                insertIndex += added;
            }
        }
        return insertCount;
    }
}

