/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.midi.impl;

import com.waxmonster.midi.MidiOutputPort;
import com.waxmonster.midi.MidiProcessor;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;

public class MidiProcessorProxy
implements MidiProcessor {
    public static final MidiProcessor[] NONE = new MidiProcessor[0];
    private final MidiOutputPort port;
    private MidiProcessor[] targets;

    public MidiProcessorProxy(MidiOutputPort port) {
        this.port = port;
        this.targets = NONE;
    }

    public void process(long time, int status) {
        MidiProcessor[] pr = this.targets;
        int n = pr.length;
        int i = 0;
        while (i < n) {
            pr[i++].process(time, status);
        }
    }

    public void process(long time, int status, int data1) {
        MidiProcessor[] pr = this.targets;
        int n = pr.length;
        int i = 0;
        while (i < n) {
            pr[i++].process(time, status, data1);
        }
    }

    public void process(long time, int status, int data1, int data2) {
        MidiProcessor[] pr = this.targets;
        int n = pr.length;
        int i = 0;
        while (i < n) {
            pr[i++].process(time, status, data1, data2);
        }
    }

    public void process(long time, ShortMessage mc) {
        MidiProcessor[] pr = this.targets;
        int n = pr.length;
        int i = 0;
        while (i < n) {
            pr[i++].process(time, mc);
        }
    }

    public void process(long time, SysexMessage sm) {
        MidiProcessor[] pr = this.targets;
        int n = pr.length;
        int i = 0;
        while (i < n) {
            pr[i++].process(time, sm);
        }
    }

    public void shutdown() {
    }

    protected final MidiOutputPort getPort() {
        return this.port;
    }

    protected MidiProcessor[] getTargets() {
        return this.targets;
    }

    protected void setTargets(MidiProcessor[] targets) {
        if (targets == null) {
            targets = NONE;
        }
        this.targets = targets;
    }
}

