/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.midi.impl;

import com.waxmonster.midi.MidiEngine;
import com.waxmonster.midi.MidiInputPort;
import com.waxmonster.midi.MidiOutputPort;
import com.waxmonster.midi.MidiSyncGroup;
import com.waxmonster.midi.impl.WrapperInputPort;
import com.waxmonster.midi.impl.WrapperOutputPort;

public class Wrapper {
    private final MidiSyncGroup group;
    private boolean prepared;
    private boolean started;
    private MidiEngine midiEngine;
    private WrapperInputPort[] inputPorts;
    private WrapperOutputPort[] outputPorts;

    protected Wrapper(MidiSyncGroup midiSyncGroup) {
        this.group = midiSyncGroup;
        this.midiEngine = midiSyncGroup.getMidiEngine();
        this.prepared = false;
        this.started = false;
        int inputCount = midiSyncGroup.getInputPortCount();
        this.inputPorts = new WrapperInputPort[inputCount];
        for (int i = 0; i < inputCount; ++i) {
            MidiInputPort port = midiSyncGroup.getInputPortAt(i);
            this.inputPorts[i] = new WrapperInputPort(this, port);
        }
        int outputCount = midiSyncGroup.getOutputPortCount();
        this.outputPorts = new WrapperOutputPort[outputCount];
        for (int i = 0; i < outputCount; ++i) {
            MidiOutputPort port = midiSyncGroup.getOutputPortAt(i);
            this.outputPorts[i] = new WrapperOutputPort(this, port);
        }
    }

    public final MidiSyncGroup getGroup() {
        return this.group;
    }

    public boolean isPrepared() {
        return this.prepared;
    }

    public void setPrepared(boolean prepared) {
        this.prepared = prepared;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void setStarted(boolean started) {
        this.started = started;
    }

    public int getInputPortCount() {
        return this.inputPorts.length;
    }

    public WrapperInputPort getInputPortAt(int index) {
        return this.inputPorts[index];
    }

    public WrapperInputPort getInputPort(MidiInputPort midiPort) {
        for (int i = 0; i < this.inputPorts.length; ++i) {
            if (this.inputPorts[i].getMidiPort() != midiPort) continue;
            return this.inputPorts[i];
        }
        return null;
    }

    public int getOutputPortCount() {
        return this.outputPorts.length;
    }

    public WrapperOutputPort getOutputPortAt(int index) {
        return this.outputPorts[index];
    }

    public WrapperOutputPort getOutputPort(MidiOutputPort midiPort) {
        for (int i = 0; i < this.outputPorts.length; ++i) {
            if (this.outputPorts[i].getMidiPort() != midiPort) continue;
            return this.outputPorts[i];
        }
        return null;
    }

    public MidiEngine getMidiEngine() {
        return this.midiEngine;
    }

    public void setMidiEngine(MidiEngine midiEngine) {
        this.midiEngine = midiEngine;
    }
}

