/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.view;

import com.waxmonster.view.View;
import com.waxmonster.view.ViewLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class GridBagViewLayout
implements ViewLayout {
    private List entries = new ArrayList();
    private JPanel dummyPanel;
    private GridBagLayout gridBagLayout = new GridBagLayout();

    public GridBagViewLayout() {
        this.dummyPanel = new JPanel();
        this.dummyPanel.setLayout(this.gridBagLayout);
    }

    @Override
    public void addView(View view, Object constraints) {
        GridBagConstraints gbc = (GridBagConstraints)constraints;
        JPanel dummyComp = new JPanel();
        this.dummyPanel.add((Component)dummyComp, constraints);
        this.entries.add(new Entry(view, gbc, dummyComp));
    }

    @Override
    public void removeView(View view) {
        Iterator i = this.entries.iterator();
        while (i.hasNext()) {
            Entry entry = (Entry)i.next();
            if (entry.view != view) continue;
            this.dummyPanel.remove(entry.dummyComp);
            i.remove();
            return;
        }
    }

    @Override
    public void removeAllViews() {
        this.entries.clear();
        this.dummyPanel.removeAll();
    }

    @Override
    public Dimension preferredLayoutSize() {
        this.adjustPreferredSize();
        return this.gridBagLayout.preferredLayoutSize(this.dummyPanel);
    }

    @Override
    public void layoutViews(Dimension size) {
        this.adjustPreferredSize();
        this.dummyPanel.setSize(size);
        this.dummyPanel.doLayout();
        for (Entry entry : this.entries) {
            Rectangle rect = entry.dummyComp.getBounds();
            entry.view.setBounds(rect);
        }
    }

    private void adjustPreferredSize() {
        for (Entry entry : this.entries) {
            Dimension dim = entry.view.getPreferredSize();
            if (dim == null) continue;
            entry.dummyComp.setMinimumSize(dim);
            entry.dummyComp.setPreferredSize(dim);
        }
    }

    protected static class Entry {
        View view;
        GridBagConstraints gbc;
        JComponent dummyComp;

        public Entry(View view, GridBagConstraints gbc, JComponent dummyComp) {
            this.view = view;
            this.gbc = gbc;
            this.dummyComp = dummyComp;
        }
    }
}

