/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.view;

import com.waxmonster.view.FontCache;
import com.waxmonster.view.FontChar;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.ImageCapabilities;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.VolatileImage;

public class ImageFontCache
implements FontCache {
    private static final int DEFAULT_INIT_RANGE = 256;
    private Font font;
    private FontMetrics metrics;
    private int height;
    private int ascent;
    private Color background;
    private Color foreground;
    private int transparency;
    private CharImpl[] chars;
    protected AlphaComposite alphaSrc;
    ImageCapabilities capsAccelerated;

    public ImageFontCache(FontMetrics metrics, Color background, Color foreground, int transparency) {
        this.metrics = metrics;
        this.font = metrics.getFont();
        this.height = metrics.getHeight();
        this.ascent = metrics.getMaxAscent();
        this.background = background;
        this.foreground = foreground;
        this.transparency = transparency;
        int num = 256;
        this.chars = new CharImpl[num];
        boolean accelerated = true;
        this.capsAccelerated = new ImageCapabilities(accelerated);
        this.alphaSrc = AlphaComposite.getInstance(2);
    }

    @Override
    public FontChar getChar(char c) {
        if (c < this.chars.length) {
            CharImpl fc = this.chars[c];
            if (fc == null) {
                int w = this.metrics.charWidth(c);
                this.chars[c] = fc = new CharImpl(c, w, this.height);
            }
            return fc;
        }
        return null;
    }

    protected void paintChar(char c, Graphics2D g, int x, int y, int w, int h) {
        if (this.background != null) {
            g.setColor(this.background);
            g.fillRect(x, y, w, h);
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setColor(this.foreground);
        g.setFont(this.font);
        g.drawString(String.valueOf(c), x, y + this.ascent);
    }

    public Color getBackground() {
        return this.background;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public Font getFont() {
        return this.font;
    }

    public FontMetrics getMetrics() {
        return this.metrics;
    }

    protected class CharImpl
    implements FontChar {
        final char c;
        final int w;
        final int h;
        BufferedImage bi;
        VolatileImage vi;
        Graphics2D vg;

        public CharImpl(char c, int w, int h) {
            this.c = c;
            this.w = w;
            this.h = h;
        }

        @Override
        public int getWidth() {
            return this.w;
        }

        @Override
        public int getHeight() {
            return this.h;
        }

        @Override
        public void draw(Graphics2D g, int x, int y) {
            GraphicsConfiguration gc = g.getDeviceConfiguration();
            if (this.bi == null) {
                this.bi = gc.createCompatibleImage(this.w, this.h, ImageFontCache.this.transparency);
                Graphics2D ig = (Graphics2D)this.bi.getGraphics();
                ImageFontCache.this.paintChar(this.c, ig, 0, 0, this.w, this.h);
                ig.dispose();
            }
            if (this.vi == null) {
                g.drawImage((Image)this.bi, x, y, null);
            } else {
                do {
                    switch (this.vi.validate(gc)) {
                        case 1: {
                            this.restore();
                            break;
                        }
                        case 2: {
                            this.setupVolatileImage(gc);
                            if (this.vi != null) break;
                            return;
                        }
                    }
                    g.drawImage(this.vi, x, y, null);
                } while (this.vi.contentsLost());
            }
        }

        protected boolean setupVolatileImage(GraphicsConfiguration config) {
            VolatileImage vi = null;
            try {
                vi = config.createCompatibleVolatileImage(this.w, this.h, ImageFontCache.this.capsAccelerated, ImageFontCache.this.transparency);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            if (vi == null && (vi = config.createCompatibleVolatileImage(this.w, this.h)) == null) {
                this.vi = null;
                return false;
            }
            this.vi = vi;
            if (this.vg != null) {
                this.vg.dispose();
            }
            this.vg = vi.createGraphics();
            this.vg.setComposite(ImageFontCache.this.alphaSrc);
            this.restore();
            return true;
        }

        protected void restore() {
            this.vg.drawImage((Image)this.bi, 0, 0, null);
        }
    }
}

