/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.view;

import com.waxmonster.view.AbstractView;
import com.waxmonster.view.FontCache;
import com.waxmonster.view.FontChar;
import java.awt.Graphics2D;

public class TextView
extends AbstractView {
    private FontCache font;
    private CharSequence text;

    public TextView() {
    }

    public TextView(FontCache font, CharSequence text) {
        this();
        this.font = font;
        this.text = text;
    }

    @Override
    public void flush() {
    }

    @Override
    public void paint(Graphics2D g) {
        CharSequence cs = this.text;
        if (cs == null) {
            return;
        }
        FontCache f = this.font;
        if (f == null) {
            return;
        }
        int n = cs.length();
        int x = 0;
        int y = 0;
        for (int i = 0; i < n; ++i) {
            FontChar c = f.getChar(cs.charAt(i));
            if (c == null) continue;
            c.draw(g, x, y);
            x += c.getWidth();
        }
    }

    public FontCache getFont() {
        return this.font;
    }

    public void setFont(FontCache font) {
        this.font = font;
    }

    public CharSequence getText() {
        return this.text;
    }

    public void setText(CharSequence text) {
        this.text = text;
    }

    public int textWidth() {
        CharSequence cs = this.text;
        if (cs == null) {
            return 0;
        }
        FontCache f = this.font;
        if (f == null) {
            return 0;
        }
        int n = cs.length();
        int w = 0;
        for (int i = 0; i < n; ++i) {
            FontChar c = f.getChar(cs.charAt(i));
            if (c == null) continue;
            w += c.getWidth();
        }
        return w;
    }

    public String toString() {
        return super.toString() + "[text=" + this.text + "]";
    }
}

