/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.view;

import com.waxmonster.view.AbstractView;
import com.waxmonster.view.View;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.ImageCapabilities;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.image.VolatileImage;

public class TileView
extends AbstractView {
    private Paint background;
    private View[] views;
    private int tileWidth;
    private int tileHeight;
    private int maxTileCacheCount;
    private int tileCacheCount;
    private Tile firstTile;
    private Tile lastTile;
    private int createTileCounter;
    private int reuseTileCounter;
    private int repaintTileCounter;
    private int recycleTileCounter;
    private int contentLostCounter;
    private int restoreImageCounter;
    private int incompatibleImageCounter;

    public TileView(int tileWidth, int tileHeight, int maxTileCacheCount, Paint background) {
        this.tileWidth = tileWidth;
        this.tileHeight = tileHeight;
        this.maxTileCacheCount = maxTileCacheCount;
        this.background = background;
        this.firstTile = null;
        this.lastTile = null;
        this.tileCacheCount = 0;
        this.views = new View[0];
    }

    public int getViewCount() {
        return this.views.length;
    }

    public View getViewAt(int index) {
        return this.views[index];
    }

    public void addView(View v) {
        if (v == null) {
            return;
        }
        View[] arr = new View[this.views.length + 1];
        System.arraycopy(this.views, 0, arr, 0, this.views.length);
        arr[this.views.length] = v;
        this.views = arr;
    }

    public void insertViewAt(View v, int index) {
        if (v == null) {
            return;
        }
        View[] arr = new View[this.views.length + 1];
        System.arraycopy(this.views, 0, arr, 0, index);
        System.arraycopy(this.views, index, arr, index + 1, this.views.length - index);
        arr[index] = v;
        this.views = arr;
    }

    public void removeView(View v) {
        for (int i = 0; i < this.views.length; ++i) {
            if (this.views[i] != v) continue;
            this.removeViewAt(i);
            return;
        }
    }

    public void removeViewAt(int index) {
        if (index < 0 || index >= this.views.length) {
            throw new IndexOutOfBoundsException("index=" + index);
        }
        View[] arr = new View[this.views.length - 1];
        System.arraycopy(this.views, 0, arr, 0, index);
        System.arraycopy(this.views, index + 1, arr, index, this.views.length - index - 1);
        this.views = arr;
    }

    public void replaceAllViews(View[] newViews) {
        this.views = newViews;
    }

    @Override
    public void paint(Graphics2D g) {
        Rectangle clip = g.getClipBounds();
        int cx = clip.x;
        int cy = clip.y;
        int tileX = this.tileX(cx);
        int tileX2 = this.tileX(cx + clip.width - 1);
        int tileY = this.tileY(cy);
        int tileY2 = this.tileY(cy + clip.height - 1);
        for (int y = tileY; y <= tileY2; ++y) {
            for (int x = tileX; x <= tileX2; ++x) {
                this.paintTile(x, y, g);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintTile(int tileX, int tileY, Graphics2D g) {
        int x = tileX * this.tileWidth;
        int y = tileY * this.tileHeight;
        GraphicsConfiguration config = g.getDeviceConfiguration();
        Tile tile = null;
        VolatileImage vi = null;
        boolean repaint = false;
        TileView tileView = this;
        synchronized (tileView) {
            Tile t = this.firstTile;
            while (t != null) {
                if (t.tileX == tileX && t.tileY == tileY) {
                    tile = t;
                    vi = t.image;
                    if (t.valid) {
                        ++this.reuseTileCounter;
                    } else {
                        repaint = true;
                        ++this.repaintTileCounter;
                    }
                    if (t == this.firstTile) break;
                    t.prev.next = t.next;
                    if (t.next == null) {
                        this.lastTile = t.prev;
                    } else {
                        t.next.prev = t.prev;
                    }
                    t.prev = null;
                    t.next = this.firstTile;
                    this.firstTile.prev = t;
                    this.firstTile = t;
                    break;
                }
                t = t.next;
            }
            if (vi == null) {
                if (this.tileCacheCount < this.maxTileCacheCount) {
                    tile = new Tile();
                    tile.tileX = tileX;
                    tile.tileY = tileY;
                    tile.image = vi = this.createVolatileImage(config, this.tileWidth + 1, this.tileHeight + 1);
                    tile.next = this.firstTile;
                    if (this.firstTile == null) {
                        this.lastTile = tile;
                    } else {
                        this.firstTile.prev = tile;
                    }
                    this.firstTile = tile;
                    ++this.tileCacheCount;
                    ++this.createTileCounter;
                } else {
                    tile = this.lastTile;
                    if (tile != this.firstTile) {
                        this.lastTile = this.lastTile.prev;
                        this.lastTile.next = null;
                        tile.prev = null;
                        tile.next = this.firstTile;
                        this.firstTile.prev = tile;
                        this.firstTile = tile;
                    }
                    tile.tileX = tileX;
                    tile.tileY = tileY;
                    vi = tile.image;
                    ++this.recycleTileCounter;
                }
                repaint = true;
            }
        }
        while (true) {
            switch (vi.validate(config)) {
                case 1: {
                    repaint = true;
                    ++this.restoreImageCounter;
                    break;
                }
                case 2: {
                    vi.flush();
                    tile.image = vi = this.createVolatileImage(config, this.tileWidth + 1, this.tileHeight + 1);
                    repaint = true;
                    ++this.incompatibleImageCounter;
                }
            }
            if (repaint) {
                tile.valid = true;
                Graphics2D vg = vi.createGraphics();
                vg.translate(1 - x, 1 - y);
                vg.clipRect(x - 1, y - 1, this.tileWidth + 1, this.tileHeight + 1);
                this.paintContent(vg, x, y, this.tileWidth + 1, this.tileHeight + 1);
                vg.dispose();
            }
            g.drawImage(vi, x, y, x + this.tileWidth, y + this.tileHeight, 1, 1, this.tileWidth + 1, this.tileHeight + 1, null);
            if (!vi.contentsLost()) break;
            ++this.contentLostCounter;
        }
    }

    protected VolatileImage createVolatileImage(GraphicsConfiguration config, int width, int height) {
        VolatileImage offImage;
        try {
            boolean accelerated = true;
            ImageCapabilities caps = new ImageCapabilities(accelerated);
            offImage = config.createCompatibleVolatileImage(width, height, caps, 1);
        }
        catch (Throwable e) {
            offImage = config.createCompatibleVolatileImage(width, height);
        }
        return offImage;
    }

    protected void paintContent(Graphics2D g, int x, int y, int w, int h) {
        g.setPaint(this.background);
        g.fillRect(x - 1, y - 1, w + 2, h + 2);
        int n = this.views.length;
        for (int i = 0; i < n; ++i) {
            this.views[i].paint(g);
        }
    }

    private int tileX(int x) {
        if (x >= 0) {
            return x / this.tileWidth;
        }
        return (x + 1) / this.tileWidth - 1;
    }

    private int tileY(int y) {
        if (y >= 0) {
            return y / this.tileHeight;
        }
        return (y + 1) / this.tileHeight - 1;
    }

    public synchronized void invalidate() {
        Tile t = this.firstTile;
        while (t != null) {
            t.valid = false;
            t = t.next;
        }
    }

    public synchronized void invalidate(Rectangle rect) {
        int cx = rect.x;
        int cy = rect.y;
        int tileX = this.tileX(cx);
        int tileX2 = this.tileX(cx + rect.width - 1);
        int tileY = this.tileY(cy);
        int tileY2 = this.tileY(cy + rect.height - 1);
        Tile t = this.firstTile;
        while (t != null) {
            if (t.tileX >= tileX && t.tileX <= tileX2 && t.tileY >= tileY && t.tileY <= tileY2) {
                t.valid = false;
            }
            t = t.next;
        }
    }

    public synchronized void invalidate(int cx, int cy, int cw, int ch) {
        int tileX = this.tileX(cx);
        int tileX2 = this.tileX(cx + cw - 1);
        int tileY = this.tileY(cy);
        int tileY2 = this.tileY(cy + ch - 1);
        Tile t = this.firstTile;
        while (t != null) {
            if (t.tileX >= tileX && t.tileX <= tileX2 && t.tileY >= tileY && t.tileY <= tileY2) {
                t.valid = false;
            }
            t = t.next;
        }
    }

    @Override
    public void flush() {
        Tile t = this.firstTile;
        this.firstTile = null;
        this.lastTile = null;
        this.tileCacheCount = 0;
        while (t != null) {
            VolatileImage vi = t.image;
            if (vi != null) {
                vi.flush();
            }
            t.image = null;
            t = t.next;
        }
        int n = this.views.length;
        for (int i = 0; i < n; ++i) {
            this.views[i].flush();
        }
    }

    public int getMaxTileCacheCount() {
        return this.maxTileCacheCount;
    }

    public synchronized void setMaxTileCacheCount(int maxTileCacheCount) {
        if (maxTileCacheCount < 1) {
            return;
        }
        this.maxTileCacheCount = maxTileCacheCount;
        if (maxTileCacheCount < this.tileCacheCount) {
            int num = this.tileCacheCount - maxTileCacheCount;
            for (int i = 0; i < num; ++i) {
                Tile tile = this.lastTile;
                if (tile.prev == null) {
                    this.firstTile = null;
                } else {
                    tile.prev.next = null;
                }
                this.lastTile = tile.prev;
                --this.tileCacheCount;
                VolatileImage vi = tile.image;
                if (vi != null) {
                    vi.flush();
                }
                tile.image = null;
            }
        }
    }

    public Paint getBackground() {
        return this.background;
    }

    public void setBackground(Paint background) {
        this.background = background;
    }

    public int getCreateTileCounter() {
        return this.createTileCounter;
    }

    public int getReuseTileCounter() {
        return this.reuseTileCounter;
    }

    public int getRepaintTileCounter() {
        return this.repaintTileCounter;
    }

    public int getRecycleTileCounter() {
        return this.recycleTileCounter;
    }

    public int getContentLostCounter() {
        return this.contentLostCounter;
    }

    public int getRestoreImageCounter() {
        return this.restoreImageCounter;
    }

    public int getIncompatibleImageCounter() {
        return this.incompatibleImageCounter;
    }

    public int getTileWidth() {
        return this.tileWidth;
    }

    public int getTileHeight() {
        return this.tileHeight;
    }

    protected static class Tile {
        Tile prev;
        Tile next;
        int tileX;
        int tileY;
        VolatileImage image;
        volatile boolean valid;

        protected Tile() {
        }
    }
}

