/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.model.impl;

import com.waxmonster.model.LineUtil;
import com.waxmonster.model.MutableLineChunk;

public abstract class AbstractLineChunk
implements MutableLineChunk {
    protected final int idHash = System.identityHashCode(this);
    long chunkOfs;
    long chunkEnd;
    int zOrder;
    long modelOfs;
    long modelEnd;

    public AbstractLineChunk(long chunkOfs, long chunkEnd, long modelOfs, long modelEnd) {
        this.chunkOfs = chunkOfs;
        this.chunkEnd = chunkEnd;
        this.modelOfs = modelOfs;
        this.modelEnd = modelEnd;
    }

    public String toString() {
        return super.toString() + "[ofs=" + LineUtil.humanNanos((long)this.chunkOfs) + ", end=" + LineUtil.humanNanos((long)this.chunkEnd) + "]";
    }

    public final int getIdHash() {
        return this.idHash;
    }

    public long getChunkOfs() {
        return this.chunkOfs;
    }

    final void setChunkOfs(long chunkOfs) {
        this.chunkOfs = chunkOfs;
    }

    public long getChunkEnd() {
        return this.chunkEnd;
    }

    final void setChunkEnd(long chunkEnd) {
        this.chunkEnd = chunkEnd;
    }

    public final int getZOrder() {
        return this.zOrder;
    }

    final void setZOrder(int zOrder) {
        this.zOrder = zOrder;
    }

    public long getModelOfs() {
        return this.modelOfs;
    }

    final void setModelOfs(long modelOfs) {
        this.modelOfs = modelOfs;
    }

    public long getModelEnd() {
        return this.modelEnd;
    }

    final void setModelEnd(long modelEnd) {
        this.modelEnd = modelEnd;
    }

    protected long computeLineEnd(long unitLen, double unitRate) {
        long len = Math.min(this.chunkEnd - this.chunkOfs, Math.min(this.modelEnd, LineUtil.getNanoOfs((long)unitLen, (double)unitRate)) - this.modelOfs);
        return len > 0L ? this.chunkOfs + len : this.chunkOfs;
    }
}

