/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.model.impl;

import com.spacekiller.util.TimeUnit;
import com.spacekiller.util.lock.LockFactory;
import com.spacekiller.util.lock.ReadWriteLock;
import com.waxmonster.model.LineUtil;
import com.waxmonster.model.MetaModel;
import com.waxmonster.model.impl.AbstractLineModel;
import com.waxmonster.scratch.ScratchMeta;
import com.waxmonster.scratch.ScratchMetaModel;
import com.waxmonster.scratch.ScratchMetaNode;

public abstract class AbstractMetaModel
extends AbstractLineModel
implements MetaModel {
    protected ScratchMetaModel metaModel;
    protected final LockFactory lockFactory;
    protected final boolean fair;
    protected final ReadWriteLock lock;
    protected TimeUnit timeUnit;
    protected float tickRate;
    protected long tickLen;

    public AbstractMetaModel(ScratchMetaModel metaModel, TimeUnit timeUnit, LockFactory lockFactory, boolean fair) {
        this.metaModel = metaModel;
        this.lockFactory = lockFactory;
        this.fair = fair;
        this.lock = lockFactory.createReadWriteLock(fair);
        this.setTimeUnit(timeUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ScratchMetaModel getMetaModel() {
        try {
            this.lock.lockRead();
            ScratchMetaModel scratchMetaModel = this.metaModel;
            return scratchMetaModel;
        }
        finally {
            this.lock.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScratchMetaNode newNode(long tick, ScratchMeta meta) {
        try {
            this.lock.lockRead();
            ScratchMetaNode scratchMetaNode = this.metaModel.newNode(tick, meta);
            return scratchMetaNode;
        }
        finally {
            this.lock.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScratchMetaNode scratchFirst() {
        try {
            this.lock.lockRead();
            ScratchMetaNode scratchMetaNode = this.metaModel.scratchFirst();
            return scratchMetaNode;
        }
        finally {
            this.lock.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScratchMetaNode scratchLast() {
        try {
            this.lock.lockRead();
            ScratchMetaNode scratchMetaNode = this.metaModel.scratchLast();
            return scratchMetaNode;
        }
        finally {
            this.lock.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScratchMetaNode scratchPrev(ScratchMetaNode node) {
        try {
            this.lock.lockRead();
            ScratchMetaNode scratchMetaNode = this.metaModel.scratchPrev(node);
            return scratchMetaNode;
        }
        finally {
            this.lock.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScratchMetaNode scratchNext(ScratchMetaNode node) {
        try {
            this.lock.lockRead();
            ScratchMetaNode scratchMetaNode = this.metaModel.scratchNext(node);
            return scratchMetaNode;
        }
        finally {
            this.lock.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimeUnit getTimeUnit() {
        try {
            this.lock.lockRead();
            TimeUnit timeUnit = this.timeUnit;
            return timeUnit;
        }
        finally {
            this.lock.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeUnit(TimeUnit timeUnit) {
        float rate = (float)timeUnit.unitsPerSecond();
        try {
            this.lock.lockWrite();
            this.timeUnit = timeUnit;
            this.tickRate = rate;
        }
        finally {
            this.lock.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getTickRate() {
        try {
            this.lock.lockRead();
            float f = this.tickRate;
            return f;
        }
        finally {
            this.lock.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTickLength() {
        try {
            this.lock.lockRead();
            long l = this.tickLen;
            return l;
        }
        finally {
            this.lock.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getUnitLength() {
        try {
            this.lock.lockRead();
            long l = this.tickLen;
            return l;
        }
        finally {
            this.lock.unlockRead();
        }
    }

    public float getUnitRate() {
        return this.tickRate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNanoLength() {
        try {
            this.lock.lockRead();
            long l = (long)Math.ceil(LineUtil.getNanoPos((long)this.tickLen, (double)this.tickRate));
            return l;
        }
        finally {
            this.lock.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkIntegrity() throws IllegalStateException {
        try {
            this.lock.lockRead();
            ScratchMetaModel tm = this.metaModel;
            if (tm != null) {
                tm.checkIntegrity();
            }
        }
        finally {
            this.lock.unlockRead();
        }
    }
}

