/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.model.impl;

import com.spacekiller.util.TimeUnit;
import com.spacekiller.util.lock.LockFactory;
import com.spacekiller.util.lock.ReadWriteLock;
import com.spacekiller.util.midi.model.Node;
import com.spacekiller.util.midi.model.NodeConsumer;
import com.spacekiller.util.midi.model.StateModel;
import com.spacekiller.util.midi.model.TrackModel;
import com.spacekiller.util.midi.model.TrackNode;
import com.waxmonster.model.LineUtil;
import com.waxmonster.model.MidiModel;
import com.waxmonster.model.impl.AbstractLineModel;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractMidiModel
extends AbstractLineModel
implements MidiModel {
    private static final Logger logger = Logger.getLogger(AbstractMidiModel.class.getName());
    protected final TrackModel trackModel;
    protected StateModel stateModel;
    protected final LockFactory lockFactory;
    protected final boolean fair;
    protected final ReadWriteLock lock;
    protected TimeUnit timeUnit;
    protected float tickRate;
    protected long tickLen;

    public AbstractMidiModel(TrackModel trackModel, StateModel stateModel, LockFactory lockFactory, boolean fair) {
        this.trackModel = trackModel;
        this.stateModel = stateModel;
        this.lockFactory = lockFactory;
        this.fair = fair;
        this.lock = lockFactory.createReadWriteLock(fair);
    }

    protected TrackModel getTrackModel() {
        return this.trackModel;
    }

    public StateModel getStateModel() {
        return this.stateModel;
    }

    protected void setStateModel(StateModel stateModel) {
        this.stateModel = stateModel;
    }

    public TrackNode newNode(long tick, TrackNode node) {
        return this.trackModel.newNode(tick, node);
    }

    public TrackNode newNode(long tick, int status) {
        return this.trackModel.newNode(tick, status);
    }

    public TrackNode newNode(long tick, int status, int data1) {
        return this.trackModel.newNode(tick, status, data1);
    }

    public TrackNode newNode(long tick, int status, int data1, int data2) {
        return this.trackModel.newNode(tick, status, data1, data2);
    }

    public TrackNode newNode(long tick, int status, byte[] data, int off, int len) {
        return this.trackModel.newNode(tick, status, data, off, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimeUnit getTimeUnit() {
        try {
            this.lock.lockRead();
            TimeUnit timeUnit = this.timeUnit;
            return timeUnit;
        }
        finally {
            this.lock.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getTickRate() {
        try {
            this.lock.lockRead();
            float f = this.tickRate;
            return f;
        }
        finally {
            this.lock.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTickLength() {
        try {
            this.lock.lockRead();
            long l = this.tickLen;
            return l;
        }
        finally {
            this.lock.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getUnitLength() {
        try {
            this.lock.lockRead();
            long l = this.tickLen;
            return l;
        }
        finally {
            this.lock.unlockRead();
        }
    }

    public float getUnitRate() {
        return this.tickRate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getTimeLength() {
        try {
            this.lock.lockRead();
            double d = (double)this.tickLen * 1000.0 / (double)this.tickRate;
            return d;
        }
        finally {
            this.lock.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNanoLength() {
        try {
            this.lock.lockRead();
            long l = (long)Math.ceil(LineUtil.getNanoPos((long)this.tickLen, (double)this.tickRate));
            return l;
        }
        finally {
            this.lock.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkIntegrity() throws IllegalStateException {
        try {
            this.lock.lockRead();
            TrackModel tm = this.trackModel;
            if (tm != null) {
                tm.checkIntegrity();
            }
        }
        finally {
            this.lock.unlockRead();
        }
    }

    protected void setTimeUnitImpl(TimeUnit timeUnit) {
        float rate = (float)timeUnit.unitsPerSecond();
        this.timeUnit = timeUnit;
        this.tickRate = rate;
    }

    protected int mergeMidiModelImpl(long ofs, long end, TrackModel src, TimeUnit srcUnit, long srcOfs, long srcEnd) {
        long lastTick;
        long srcLen = srcEnd - srcOfs;
        if (srcLen < 1L) {
            return 0;
        }
        TimeUnit dstUnit = this.getTimeUnit();
        double srcRate = srcUnit.unitsPerSecond();
        double dstRate = dstUnit.unitsPerSecond();
        double factor = dstRate / srcRate;
        if (factor <= 0.0) {
            return 0;
        }
        if (Double.isInfinite(factor)) {
            return 0;
        }
        if (Double.isNaN(factor)) {
            return 0;
        }
        Merger dst = new Merger(ofs, end, src, srcOfs, srcEnd, factor);
        src.getNodes(srcOfs, srcEnd, (NodeConsumer)dst);
        int mergeCount = dst.mergeCount;
        if (mergeCount > 0 && (lastTick = dst.lastTick) >= this.tickLen) {
            this.tickLen = lastTick + 1L;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("mergeMidiModel: mergeCount=" + mergeCount + ", tickLen=" + this.tickLen + ", roundErrors=" + dst.roundErrors);
        }
        return mergeCount;
    }

    protected class Merger
    implements NodeConsumer {
        protected long ofs;
        protected long end;
        protected TrackModel src;
        protected long srcOfs;
        protected long srcEnd;
        protected double factor;
        protected int mergeCount;
        protected long lastTick;
        protected int roundErrors;

        public Merger(long ofs, long end, TrackModel src, long srcOfs, long srcEnd, double factor) {
            this.ofs = ofs;
            this.end = end;
            this.src = src;
            this.srcOfs = srcOfs;
            this.srcEnd = srcEnd;
            this.factor = factor;
            this.mergeCount = 0;
            this.lastTick = Long.MIN_VALUE;
        }

        public boolean consume(Node node) {
            long tick;
            TrackNode n = (TrackNode)node;
            long t = n.getTick();
            if (t < this.srcOfs) {
                return true;
            }
            if (t >= this.srcEnd) {
                return true;
            }
            double td = (double)(t - this.srcOfs) * this.factor;
            long tt = Math.round(td);
            if ((double)tt != td) {
                ++this.roundErrors;
            }
            if ((tick = this.ofs + tt) < this.ofs) {
                return true;
            }
            if (tick >= this.end) {
                return true;
            }
            if (AbstractMidiModel.this.addNode(AbstractMidiModel.this.newNode(tick, n))) {
                ++this.mergeCount;
                if (tick > this.lastTick) {
                    this.lastTick = tick;
                }
            }
            return true;
        }
    }
}

