/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.model.impl;

import com.spacekiller.util.Resource;
import com.spacekiller.util.lock.LockFactory;
import com.spacekiller.util.sound.AudioFile;
import com.spacekiller.util.sound.RawSampleBuffer;
import com.spacekiller.util.sound.SampleBuffer;
import com.spacekiller.util.sound.SampleType;
import com.spacekiller.util.thread.ThreadPool;
import com.waxmonster.model.AudioModel;
import com.waxmonster.model.LineUtil;
import com.waxmonster.model.MutableLineChunk;
import com.waxmonster.model.impl.AbstractLineChunk;
import com.waxmonster.model.impl.CachedAudioChunk;
import com.waxmonster.model.impl.CachedSampleModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class CachedAudioModel
extends CachedSampleModel
implements AudioModel {
    private final AudioFile audioFile;
    private final SampleType sampleType;
    private final int sampleSize;
    private final int partFrames;
    private String name;
    private Resource resource;
    private String[] trackIds;
    protected List chunks;

    public CachedAudioModel(int channels, float frameRate, int partSize, int maxLoadedParts, LockFactory lockFactory, boolean fair, boolean flushAsync, ThreadPool writerThreadPool, AudioFile audioFile, SampleType sampleType) throws InterruptedException {
        super(channels, frameRate, audioFile.getFrameLength() * (long)audioFile.getChannels(), partSize, maxLoadedParts, lockFactory, fair, flushAsync, writerThreadPool, (SampleBuffer)sampleType.createRawSampleBuffer(channels, frameRate, partSize));
        this.partFrames = partSize / channels;
        this.audioFile = audioFile;
        this.sampleType = sampleType;
        this.sampleSize = audioFile.getFrameSize() / channels;
        if (partSize != this.partFrames * channels) {
            throw new IllegalArgumentException("Invalid part size: " + partSize + ", channels=" + channels);
        }
    }

    public String toString() {
        return super.toString() + "[audioFile=" + this.audioFile + "]";
    }

    public AudioFile getAudioFile() {
        return this.audioFile;
    }

    @Override
    protected SampleBuffer alloc(int samples) {
        return this.sampleType.createRawSampleBuffer(this.channels, this.frameRate, samples);
    }

    @Override
    protected synchronized void load(long pos, SampleBuffer dst, int off, int len) throws IOException {
        this.audioFile.read(pos / (long)this.channels, (RawSampleBuffer)dst, off * this.sampleSize, len * this.sampleSize);
    }

    @Override
    protected synchronized void save(long pos, SampleBuffer src, int off, int len) throws IOException {
        this.audioFile.write(pos / (long)this.channels, (RawSampleBuffer)src, off * this.sampleSize, len * this.sampleSize);
    }

    @Override
    public synchronized void flush() throws IOException {
        super.flush();
        this.audioFile.flush();
    }

    @Override
    public synchronized void close() throws IOException {
        this.chunks = null;
        super.close();
        this.audioFile.close();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public String[] getTrackIds() {
        return this.trackIds;
    }

    public void setTrackIds(String[] trackIds) {
        this.trackIds = trackIds;
    }

    public long getFrameLength() {
        return this.getSamples() / (long)this.channels;
    }

    public long getUnitLength() {
        return this.getSamples() / (long)this.channels;
    }

    public float getUnitRate() {
        return this.frameRate;
    }

    public long getNanoLength() {
        return (long)Math.ceil(LineUtil.getNanoPos((long)this.getFrameLength(), (double)this.frameRate));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getValues(double framePos, double fpu, double[] dst, int off, int len) throws IOException {
        if (framePos < 0.0) {
            throw new IOException("Invalid frame position: " + framePos);
        }
        if (fpu <= 0.0) {
            throw new IOException("Invalid frames per unit: " + fpu);
        }
        int num = len / this.channels;
        long es = (long)(framePos + (double)(num - 1) * fpu) * (long)this.channels;
        long samples = this.getSamples();
        if (es >= samples) {
            throw new IOException("Invalid sample range: framePos=" + framePos + ", fpu=" + fpu + ", len=" + len + ", es=" + es + ", samples=" + samples);
        }
        long fp = (long)framePos;
        long i = fp * (long)this.channels;
        int p = (int)(i / (long)this.partSize);
        double d = framePos - (double)(p * this.partFrames);
        int end = off + len;
        while (off < end) {
            if (d < (double)this.partFrames) {
                CachedSampleModel.Part a = this.readLock(p);
                try {
                    SampleBuffer sb = a.buf;
                    while (d < (double)this.partFrames && off < end) {
                        int x = (int)d * this.channels;
                        int z = x + this.channels;
                        while (x < z) {
                            dst[off++] = sb.getDouble(x++);
                        }
                        d += fpu;
                    }
                }
                finally {
                    a.lock.unlockRead();
                }
            }
            ++p;
            d -= (double)this.partFrames;
        }
    }

    protected final synchronized void chunkCreated(AbstractLineChunk chunk) {
        if (this.chunks == null) {
            this.chunks = new ArrayList();
        }
        this.chunks.add(chunk);
    }

    protected final synchronized void chunkClosed(AbstractLineChunk chunk) {
        if (this.chunks == null) {
            return;
        }
        this.chunks.remove(chunk);
    }

    public final synchronized int getChunkCount() {
        return this.chunks == null ? 0 : this.chunks.size();
    }

    public MutableLineChunk createLineChunk(long chunkOfs, long chunkEnd, long modelOfs, long modelEnd) {
        CachedAudioChunk chunk = new CachedAudioChunk(chunkOfs, chunkEnd, modelOfs, modelEnd, this);
        this.chunkCreated(chunk);
        return chunk;
    }
}

