/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.model.impl;

import com.spacekiller.util.Data;
import com.spacekiller.util.Resource;
import com.spacekiller.util.lock.LockFactory;
import com.spacekiller.util.sound.FloatArraySampleBuffer;
import com.spacekiller.util.sound.SampleBuffer;
import com.spacekiller.util.thread.ThreadPool;
import com.waxmonster.model.FaderModel;
import com.waxmonster.model.LineUtil;
import com.waxmonster.model.MutableLineChunk;
import com.waxmonster.model.impl.AbstractLineChunk;
import com.waxmonster.model.impl.CachedFaderChunk;
import com.waxmonster.model.impl.CachedSampleModel;
import com.waxmonster.model.impl.FaderFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class CachedFaderModel
extends CachedSampleModel
implements FaderModel {
    private final FaderFile faderFile;
    private String name;
    private Resource resource;
    private String[] trackIds;
    protected List chunks;
    private byte[] io;

    public CachedFaderModel(float frameRate, long samples, int partSize, int maxLoadedParts, LockFactory lockFactory, boolean fair, boolean flushAsync, ThreadPool writerThreadPool, FaderFile faderFile) throws InterruptedException {
        super(1, frameRate, samples, partSize, maxLoadedParts, lockFactory, fair, flushAsync, writerThreadPool, CachedFaderModel.createEmptyBuf(partSize, frameRate));
        this.faderFile = faderFile;
        this.io = new byte[partSize * 4];
    }

    public String toString() {
        return super.toString() + "[faderFile=" + this.faderFile + "]";
    }

    public FaderFile getFaderFile() {
        return this.faderFile;
    }

    private static SampleBuffer createEmptyBuf(int partSize, float frameRate) {
        return new FloatArraySampleBuffer(1, partSize, frameRate, new float[partSize]);
    }

    @Override
    protected SampleBuffer alloc(int samples) {
        return new FloatArraySampleBuffer(1, samples, this.frameRate, new float[samples]);
    }

    @Override
    protected synchronized void load(long pos, SampleBuffer dst, int off, int len) throws IOException {
        float[] arr = ((FloatArraySampleBuffer)dst).array();
        int byteLen = len * 4;
        this.faderFile.read(pos, this.io, 0, byteLen);
        for (int o = 0; o < byteLen; o += 4) {
            arr[off++] = Data.getFloat((byte[])this.io, (int)o);
        }
    }

    @Override
    protected synchronized void save(long pos, SampleBuffer src, int off, int len) throws IOException {
        float[] arr = ((FloatArraySampleBuffer)src).array();
        int byteLen = len * 4;
        for (int o = 0; o < byteLen; o += 4) {
            Data.setFloat((byte[])this.io, (int)o, (float)arr[off++]);
        }
        this.faderFile.write(pos, this.io, 0, byteLen);
    }

    @Override
    public synchronized void flush() throws IOException {
        super.flush();
        this.faderFile.flush();
    }

    @Override
    public synchronized void close() throws IOException {
        super.close();
        this.faderFile.close();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public String[] getTrackIds() {
        return this.trackIds;
    }

    public void setTrackIds(String[] trackIds) {
        this.trackIds = trackIds;
    }

    public long getFrameLength() {
        return this.getSamples();
    }

    public long getUnitLength() {
        return this.getSamples();
    }

    public float getUnitRate() {
        return this.frameRate;
    }

    public long getNanoLength() {
        return (long)Math.ceil(LineUtil.getNanoPos((long)this.getSamples(), (double)this.frameRate));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getValues(double framePos, double fpu, double[] dst, int off, int len) throws IOException {
        if (framePos < 0.0) {
            throw new IOException("Invalid frame position: " + framePos);
        }
        if (fpu <= 0.0) {
            throw new IOException("Invalid frames per unit: " + fpu);
        }
        long samples = this.getSamples();
        if ((long)(framePos + (double)(len - 1) * fpu) >= samples) {
            throw new IOException("Invalid sample range: framePos=" + framePos + ", fpu=" + fpu + ", len=" + len + ", samples=" + samples);
        }
        long i = (long)framePos;
        int p = (int)(i / (long)this.partSize);
        double d = framePos - (double)(p * this.partSize);
        int end = off + len;
        while (off < end) {
            if (d < (double)this.partSize) {
                CachedSampleModel.Part a = this.readLock(p);
                try {
                    SampleBuffer sb = a.buf;
                    while (d < (double)this.partSize && off < end) {
                        dst[off++] = sb.getDouble((int)d);
                        d += fpu;
                    }
                }
                finally {
                    a.lock.unlockRead();
                }
            }
            ++p;
            d -= (double)this.partSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getValues(double framePos, double fpu, float[] dst, int off, int len) throws IOException {
        if (framePos < 0.0) {
            throw new IOException("Invalid frame position: " + framePos);
        }
        if (fpu <= 0.0) {
            throw new IOException("Invalid frames per unit: " + fpu);
        }
        long samples = this.getSamples();
        if ((long)(framePos + (double)(len - 1) * fpu) >= samples) {
            throw new IOException("Invalid sample range: framePos=" + framePos + ", fpu=" + fpu + ", len=" + len + ", samples=" + samples);
        }
        long i = (long)framePos;
        int p = (int)(i / (long)this.partSize);
        double d = framePos - (double)(p * this.partSize);
        int end = off + len;
        while (off < end) {
            if (d < (double)this.partSize) {
                CachedSampleModel.Part a = this.readLock(p);
                try {
                    SampleBuffer sb = a.buf;
                    while (d < (double)this.partSize && off < end) {
                        dst[off++] = sb.getFloat((int)d);
                        d += fpu;
                    }
                }
                finally {
                    a.lock.unlockRead();
                }
            }
            ++p;
            d -= (double)this.partSize;
        }
    }

    protected final synchronized void chunkCreated(AbstractLineChunk chunk) {
        if (this.chunks == null) {
            this.chunks = new ArrayList();
        }
        this.chunks.add(chunk);
    }

    protected final synchronized void chunkClosed(AbstractLineChunk chunk) {
        if (this.chunks == null) {
            return;
        }
        this.chunks.remove(chunk);
    }

    public final synchronized int getChunkCount() {
        return this.chunks == null ? 0 : this.chunks.size();
    }

    public MutableLineChunk createLineChunk(long chunkOfs, long chunkEnd, long modelOfs, long modelEnd) {
        CachedFaderChunk chunk = new CachedFaderChunk(chunkOfs, chunkEnd, modelOfs, modelEnd, this);
        this.chunkCreated(chunk);
        return chunk;
    }
}

