/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.model.impl;

import com.spacekiller.util.TimeUnit;
import com.spacekiller.util.lock.LockFactory;
import com.spacekiller.util.midi.file.FileTrackModel;
import com.spacekiller.util.midi.file.TrackModelFile;
import com.spacekiller.util.midi.model.StateModel;
import com.spacekiller.util.midi.model.TrackModel;
import com.waxmonster.model.MidiModel;
import com.waxmonster.model.impl.DefaultMidiModel;
import java.io.IOException;

public class CachedMidiModel
extends DefaultMidiModel
implements MidiModel {
    protected final FileTrackModel fileTrackModel;
    private final TrackModelFile trackModelFile;

    public CachedMidiModel(FileTrackModel trackModel, StateModel stateModel, TimeUnit timeUnit, LockFactory lockFactory, boolean fair, TrackModelFile trackModelFile) {
        super((TrackModel)trackModel, stateModel, timeUnit, lockFactory, fair);
        this.fileTrackModel = trackModel;
        this.trackModelFile = trackModelFile;
    }

    @Override
    public String toString() {
        return super.toString() + "[trackModelFile=" + this.trackModelFile + "]";
    }

    public FileTrackModel getFileTrackModel() {
        return this.fileTrackModel;
    }

    public TrackModelFile getTrackModelFile() {
        return this.trackModelFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        try {
            this.lock.lockWrite();
            super.flush();
            if (this.fileTrackModel != null) {
                this.fileTrackModel.flush();
            }
        }
        finally {
            this.lock.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.lock.lockWrite();
            super.close();
            if (this.fileTrackModel != null) {
                this.fileTrackModel.close();
            }
        }
        finally {
            this.lock.unlockWrite();
        }
    }
}

